# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .message import Message
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ToolMessage(Message):
    """
    Represents a single instance of tool message.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ToolMessage object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.ToolMessage.role` attribute
        of this class is ``TOOL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param role:
            The value to assign to the role property of this ToolMessage.
            Allowed values for this property are: "SYSTEM", "ASSISTANT", "USER", "TOOL", "DEVELOPER"
        :type role: str

        :param content:
            The value to assign to the content property of this ToolMessage.
        :type content: list[oci.generative_ai_inference.models.ChatContent]

        :param tool_call_id:
            The value to assign to the tool_call_id property of this ToolMessage.
        :type tool_call_id: str

        """
        self.swagger_types = {
            'role': 'str',
            'content': 'list[ChatContent]',
            'tool_call_id': 'str'
        }
        self.attribute_map = {
            'role': 'role',
            'content': 'content',
            'tool_call_id': 'toolCallId'
        }
        self._role = None
        self._content = None
        self._tool_call_id = None
        self._role = 'TOOL'

    @property
    def tool_call_id(self):
        """
        Gets the tool_call_id of this ToolMessage.
        Tool call that this message is responding to. The ID is the unique string generated by the model.


        :return: The tool_call_id of this ToolMessage.
        :rtype: str
        """
        return self._tool_call_id

    @tool_call_id.setter
    def tool_call_id(self, tool_call_id):
        """
        Sets the tool_call_id of this ToolMessage.
        Tool call that this message is responding to. The ID is the unique string generated by the model.


        :param tool_call_id: The tool_call_id of this ToolMessage.
        :type: str
        """
        self._tool_call_id = tool_call_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
