# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407

from .create_pipeline_details import CreatePipelineDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateZeroEtlPipelineDetails(CreatePipelineDetails):
    """
    Creation details for a new ZeroETL pipeline.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateZeroEtlPipelineDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.golden_gate.models.CreateZeroEtlPipelineDetails.recipe_type` attribute
        of this class is ``ZERO_ETL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param recipe_type:
            The value to assign to the recipe_type property of this CreateZeroEtlPipelineDetails.
            Allowed values for this property are: "ZERO_ETL"
        :type recipe_type: str

        :param display_name:
            The value to assign to the display_name property of this CreateZeroEtlPipelineDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateZeroEtlPipelineDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateZeroEtlPipelineDetails.
        :type compartment_id: str

        :param license_model:
            The value to assign to the license_model property of this CreateZeroEtlPipelineDetails.
            Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"
        :type license_model: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateZeroEtlPipelineDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateZeroEtlPipelineDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param locks:
            The value to assign to the locks property of this CreateZeroEtlPipelineDetails.
        :type locks: list[oci.golden_gate.models.ResourceLock]

        :param source_connection_details:
            The value to assign to the source_connection_details property of this CreateZeroEtlPipelineDetails.
        :type source_connection_details: oci.golden_gate.models.SourcePipelineConnectionDetails

        :param target_connection_details:
            The value to assign to the target_connection_details property of this CreateZeroEtlPipelineDetails.
        :type target_connection_details: oci.golden_gate.models.TargetPipelineConnectionDetails

        :param subnet_id:
            The value to assign to the subnet_id property of this CreateZeroEtlPipelineDetails.
        :type subnet_id: str

        :param process_options:
            The value to assign to the process_options property of this CreateZeroEtlPipelineDetails.
        :type process_options: oci.golden_gate.models.ProcessOptions

        """
        self.swagger_types = {
            'recipe_type': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'license_model': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'locks': 'list[ResourceLock]',
            'source_connection_details': 'SourcePipelineConnectionDetails',
            'target_connection_details': 'TargetPipelineConnectionDetails',
            'subnet_id': 'str',
            'process_options': 'ProcessOptions'
        }
        self.attribute_map = {
            'recipe_type': 'recipeType',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'license_model': 'licenseModel',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'locks': 'locks',
            'source_connection_details': 'sourceConnectionDetails',
            'target_connection_details': 'targetConnectionDetails',
            'subnet_id': 'subnetId',
            'process_options': 'processOptions'
        }
        self._recipe_type = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._license_model = None
        self._freeform_tags = None
        self._defined_tags = None
        self._locks = None
        self._source_connection_details = None
        self._target_connection_details = None
        self._subnet_id = None
        self._process_options = None
        self._recipe_type = 'ZERO_ETL'

    @property
    def process_options(self):
        """
        Gets the process_options of this CreateZeroEtlPipelineDetails.

        :return: The process_options of this CreateZeroEtlPipelineDetails.
        :rtype: oci.golden_gate.models.ProcessOptions
        """
        return self._process_options

    @process_options.setter
    def process_options(self, process_options):
        """
        Sets the process_options of this CreateZeroEtlPipelineDetails.

        :param process_options: The process_options of this CreateZeroEtlPipelineDetails.
        :type: oci.golden_gate.models.ProcessOptions
        """
        self._process_options = process_options

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
