# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: release


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExternalKeyManagerMetadata(object):
    """
    Metadata required for accessing External Key manager
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExternalKeyManagerMetadata object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param oauth_metadata:
            The value to assign to the oauth_metadata property of this ExternalKeyManagerMetadata.
        :type oauth_metadata: oci.key_management.models.OauthMetadata

        :param external_vault_endpoint_url:
            The value to assign to the external_vault_endpoint_url property of this ExternalKeyManagerMetadata.
        :type external_vault_endpoint_url: str

        :param private_endpoint_id:
            The value to assign to the private_endpoint_id property of this ExternalKeyManagerMetadata.
        :type private_endpoint_id: str

        """
        self.swagger_types = {
            'oauth_metadata': 'OauthMetadata',
            'external_vault_endpoint_url': 'str',
            'private_endpoint_id': 'str'
        }
        self.attribute_map = {
            'oauth_metadata': 'oauthMetadata',
            'external_vault_endpoint_url': 'externalVaultEndpointUrl',
            'private_endpoint_id': 'privateEndpointId'
        }
        self._oauth_metadata = None
        self._external_vault_endpoint_url = None
        self._private_endpoint_id = None

    @property
    def oauth_metadata(self):
        """
        **[Required]** Gets the oauth_metadata of this ExternalKeyManagerMetadata.

        :return: The oauth_metadata of this ExternalKeyManagerMetadata.
        :rtype: oci.key_management.models.OauthMetadata
        """
        return self._oauth_metadata

    @oauth_metadata.setter
    def oauth_metadata(self, oauth_metadata):
        """
        Sets the oauth_metadata of this ExternalKeyManagerMetadata.

        :param oauth_metadata: The oauth_metadata of this ExternalKeyManagerMetadata.
        :type: oci.key_management.models.OauthMetadata
        """
        self._oauth_metadata = oauth_metadata

    @property
    def external_vault_endpoint_url(self):
        """
        **[Required]** Gets the external_vault_endpoint_url of this ExternalKeyManagerMetadata.
        URI of the vault on external key manager.


        :return: The external_vault_endpoint_url of this ExternalKeyManagerMetadata.
        :rtype: str
        """
        return self._external_vault_endpoint_url

    @external_vault_endpoint_url.setter
    def external_vault_endpoint_url(self, external_vault_endpoint_url):
        """
        Sets the external_vault_endpoint_url of this ExternalKeyManagerMetadata.
        URI of the vault on external key manager.


        :param external_vault_endpoint_url: The external_vault_endpoint_url of this ExternalKeyManagerMetadata.
        :type: str
        """
        self._external_vault_endpoint_url = external_vault_endpoint_url

    @property
    def private_endpoint_id(self):
        """
        **[Required]** Gets the private_endpoint_id of this ExternalKeyManagerMetadata.
        OCID of private endpoint created by customer.


        :return: The private_endpoint_id of this ExternalKeyManagerMetadata.
        :rtype: str
        """
        return self._private_endpoint_id

    @private_endpoint_id.setter
    def private_endpoint_id(self, private_endpoint_id):
        """
        Sets the private_endpoint_id of this ExternalKeyManagerMetadata.
        OCID of private endpoint created by customer.


        :param private_endpoint_id: The private_endpoint_id of this ExternalKeyManagerMetadata.
        :type: str
        """
        self._private_endpoint_id = private_endpoint_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
