# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: release


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExternalKeyManagerMetadataSummary(object):
    """
    Summary about metadata of external key manager to be returned to the customer as a response.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExternalKeyManagerMetadataSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vendor:
            The value to assign to the vendor property of this ExternalKeyManagerMetadataSummary.
        :type vendor: str

        :param external_vault_endpoint_url:
            The value to assign to the external_vault_endpoint_url property of this ExternalKeyManagerMetadataSummary.
        :type external_vault_endpoint_url: str

        :param private_endpoint_id:
            The value to assign to the private_endpoint_id property of this ExternalKeyManagerMetadataSummary.
        :type private_endpoint_id: str

        :param oauth_metadata_summary:
            The value to assign to the oauth_metadata_summary property of this ExternalKeyManagerMetadataSummary.
        :type oauth_metadata_summary: oci.key_management.models.OauthMetadataSummary

        """
        self.swagger_types = {
            'vendor': 'str',
            'external_vault_endpoint_url': 'str',
            'private_endpoint_id': 'str',
            'oauth_metadata_summary': 'OauthMetadataSummary'
        }
        self.attribute_map = {
            'vendor': 'vendor',
            'external_vault_endpoint_url': 'externalVaultEndpointUrl',
            'private_endpoint_id': 'privateEndpointId',
            'oauth_metadata_summary': 'oauthMetadataSummary'
        }
        self._vendor = None
        self._external_vault_endpoint_url = None
        self._private_endpoint_id = None
        self._oauth_metadata_summary = None

    @property
    def vendor(self):
        """
        Gets the vendor of this ExternalKeyManagerMetadataSummary.
        Vendor of the external key manager.


        :return: The vendor of this ExternalKeyManagerMetadataSummary.
        :rtype: str
        """
        return self._vendor

    @vendor.setter
    def vendor(self, vendor):
        """
        Sets the vendor of this ExternalKeyManagerMetadataSummary.
        Vendor of the external key manager.


        :param vendor: The vendor of this ExternalKeyManagerMetadataSummary.
        :type: str
        """
        self._vendor = vendor

    @property
    def external_vault_endpoint_url(self):
        """
        **[Required]** Gets the external_vault_endpoint_url of this ExternalKeyManagerMetadataSummary.
        URL of the vault on external key manager.


        :return: The external_vault_endpoint_url of this ExternalKeyManagerMetadataSummary.
        :rtype: str
        """
        return self._external_vault_endpoint_url

    @external_vault_endpoint_url.setter
    def external_vault_endpoint_url(self, external_vault_endpoint_url):
        """
        Sets the external_vault_endpoint_url of this ExternalKeyManagerMetadataSummary.
        URL of the vault on external key manager.


        :param external_vault_endpoint_url: The external_vault_endpoint_url of this ExternalKeyManagerMetadataSummary.
        :type: str
        """
        self._external_vault_endpoint_url = external_vault_endpoint_url

    @property
    def private_endpoint_id(self):
        """
        **[Required]** Gets the private_endpoint_id of this ExternalKeyManagerMetadataSummary.
        OCID of the private endpoint.


        :return: The private_endpoint_id of this ExternalKeyManagerMetadataSummary.
        :rtype: str
        """
        return self._private_endpoint_id

    @private_endpoint_id.setter
    def private_endpoint_id(self, private_endpoint_id):
        """
        Sets the private_endpoint_id of this ExternalKeyManagerMetadataSummary.
        OCID of the private endpoint.


        :param private_endpoint_id: The private_endpoint_id of this ExternalKeyManagerMetadataSummary.
        :type: str
        """
        self._private_endpoint_id = private_endpoint_id

    @property
    def oauth_metadata_summary(self):
        """
        Gets the oauth_metadata_summary of this ExternalKeyManagerMetadataSummary.

        :return: The oauth_metadata_summary of this ExternalKeyManagerMetadataSummary.
        :rtype: oci.key_management.models.OauthMetadataSummary
        """
        return self._oauth_metadata_summary

    @oauth_metadata_summary.setter
    def oauth_metadata_summary(self, oauth_metadata_summary):
        """
        Sets the oauth_metadata_summary of this ExternalKeyManagerMetadataSummary.

        :param oauth_metadata_summary: The oauth_metadata_summary of this ExternalKeyManagerMetadataSummary.
        :type: oci.key_management.models.OauthMetadataSummary
        """
        self._oauth_metadata_summary = oauth_metadata_summary

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
