# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LogAnalyticsTemplate(object):
    """
    A template object.
    """

    #: A constant which can be used with the lifecycle_state property of a LogAnalyticsTemplate.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a LogAnalyticsTemplate.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new LogAnalyticsTemplate object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this LogAnalyticsTemplate.
        :type id: str

        :param description:
            The value to assign to the description property of this LogAnalyticsTemplate.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this LogAnalyticsTemplate.
        :type compartment_id: str

        :param time_created:
            The value to assign to the time_created property of this LogAnalyticsTemplate.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this LogAnalyticsTemplate.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this LogAnalyticsTemplate.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this LogAnalyticsTemplate.
        :type defined_tags: dict(str, dict(str, object))

        :param name:
            The value to assign to the name property of this LogAnalyticsTemplate.
        :type name: str

        :param type:
            The value to assign to the type property of this LogAnalyticsTemplate.
        :type type: str

        :param is_system:
            The value to assign to the is_system property of this LogAnalyticsTemplate.
        :type is_system: bool

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this LogAnalyticsTemplate.
            Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param facets:
            The value to assign to the facets property of this LogAnalyticsTemplate.
        :type facets: list[oci.log_analytics.models.TemplateFacet]

        :param content:
            The value to assign to the content property of this LogAnalyticsTemplate.
        :type content: str

        :param content_format:
            The value to assign to the content_format property of this LogAnalyticsTemplate.
        :type content_format: str

        :param parameters:
            The value to assign to the parameters property of this LogAnalyticsTemplate.
        :type parameters: str

        :param parameters_format:
            The value to assign to the parameters_format property of this LogAnalyticsTemplate.
        :type parameters_format: str

        :param parameters_metadata:
            The value to assign to the parameters_metadata property of this LogAnalyticsTemplate.
        :type parameters_metadata: str

        """
        self.swagger_types = {
            'id': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'name': 'str',
            'type': 'str',
            'is_system': 'bool',
            'lifecycle_state': 'str',
            'facets': 'list[TemplateFacet]',
            'content': 'str',
            'content_format': 'str',
            'parameters': 'str',
            'parameters_format': 'str',
            'parameters_metadata': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'name': 'name',
            'type': 'type',
            'is_system': 'isSystem',
            'lifecycle_state': 'lifecycleState',
            'facets': 'facets',
            'content': 'content',
            'content_format': 'contentFormat',
            'parameters': 'parameters',
            'parameters_format': 'parametersFormat',
            'parameters_metadata': 'parametersMetadata'
        }
        self._id = None
        self._description = None
        self._compartment_id = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._name = None
        self._type = None
        self._is_system = None
        self._lifecycle_state = None
        self._facets = None
        self._content = None
        self._content_format = None
        self._parameters = None
        self._parameters_format = None
        self._parameters_metadata = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this LogAnalyticsTemplate.
        The log analytics entity OCID. This ID is a reference used by log analytics features and it represents
        a resource that is provisioned and managed by the customer on their premises or on the cloud.


        :return: The id of this LogAnalyticsTemplate.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this LogAnalyticsTemplate.
        The log analytics entity OCID. This ID is a reference used by log analytics features and it represents
        a resource that is provisioned and managed by the customer on their premises or on the cloud.


        :param id: The id of this LogAnalyticsTemplate.
        :type: str
        """
        self._id = id

    @property
    def description(self):
        """
        Gets the description of this LogAnalyticsTemplate.
        Description for this resource.


        :return: The description of this LogAnalyticsTemplate.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this LogAnalyticsTemplate.
        Description for this resource.


        :param description: The description of this LogAnalyticsTemplate.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this LogAnalyticsTemplate.
        Compartment Identifier `OCID]`__.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this LogAnalyticsTemplate.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this LogAnalyticsTemplate.
        Compartment Identifier `OCID]`__.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this LogAnalyticsTemplate.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this LogAnalyticsTemplate.
        The date and time the resource was created, in the format defined by RFC3339.


        :return: The time_created of this LogAnalyticsTemplate.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this LogAnalyticsTemplate.
        The date and time the resource was created, in the format defined by RFC3339.


        :param time_created: The time_created of this LogAnalyticsTemplate.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this LogAnalyticsTemplate.
        The date and time the resource was last updated, in the format defined by RFC3339.


        :return: The time_updated of this LogAnalyticsTemplate.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this LogAnalyticsTemplate.
        The date and time the resource was last updated, in the format defined by RFC3339.


        :param time_updated: The time_updated of this LogAnalyticsTemplate.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this LogAnalyticsTemplate.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this LogAnalyticsTemplate.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this LogAnalyticsTemplate.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this LogAnalyticsTemplate.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this LogAnalyticsTemplate.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this LogAnalyticsTemplate.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this LogAnalyticsTemplate.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this LogAnalyticsTemplate.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def name(self):
        """
        **[Required]** Gets the name of this LogAnalyticsTemplate.
        The template name.


        :return: The name of this LogAnalyticsTemplate.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this LogAnalyticsTemplate.
        The template name.


        :param name: The name of this LogAnalyticsTemplate.
        :type: str
        """
        self._name = name

    @property
    def type(self):
        """
        Gets the type of this LogAnalyticsTemplate.
        The template type.


        :return: The type of this LogAnalyticsTemplate.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this LogAnalyticsTemplate.
        The template type.


        :param type: The type of this LogAnalyticsTemplate.
        :type: str
        """
        self._type = type

    @property
    def is_system(self):
        """
        Gets the is_system of this LogAnalyticsTemplate.
        The system flag.  A value of false denotes a custom, or user
        defined object.  A value of true denotes a built in object.


        :return: The is_system of this LogAnalyticsTemplate.
        :rtype: bool
        """
        return self._is_system

    @is_system.setter
    def is_system(self, is_system):
        """
        Sets the is_system of this LogAnalyticsTemplate.
        The system flag.  A value of false denotes a custom, or user
        defined object.  A value of true denotes a built in object.


        :param is_system: The is_system of this LogAnalyticsTemplate.
        :type: bool
        """
        self._is_system = is_system

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this LogAnalyticsTemplate.
        The current state of the template.

        Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this LogAnalyticsTemplate.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this LogAnalyticsTemplate.
        The current state of the template.


        :param lifecycle_state: The lifecycle_state of this LogAnalyticsTemplate.
        :type: str
        """
        allowed_values = ["ACTIVE", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def facets(self):
        """
        Gets the facets of this LogAnalyticsTemplate.
        Facets of the template


        :return: The facets of this LogAnalyticsTemplate.
        :rtype: list[oci.log_analytics.models.TemplateFacet]
        """
        return self._facets

    @facets.setter
    def facets(self, facets):
        """
        Sets the facets of this LogAnalyticsTemplate.
        Facets of the template


        :param facets: The facets of this LogAnalyticsTemplate.
        :type: list[oci.log_analytics.models.TemplateFacet]
        """
        self._facets = facets

    @property
    def content(self):
        """
        Gets the content of this LogAnalyticsTemplate.
        Base64 encoded template content.


        :return: The content of this LogAnalyticsTemplate.
        :rtype: str
        """
        return self._content

    @content.setter
    def content(self, content):
        """
        Sets the content of this LogAnalyticsTemplate.
        Base64 encoded template content.


        :param content: The content of this LogAnalyticsTemplate.
        :type: str
        """
        self._content = content

    @property
    def content_format(self):
        """
        Gets the content_format of this LogAnalyticsTemplate.
        Content format. For example - XML.


        :return: The content_format of this LogAnalyticsTemplate.
        :rtype: str
        """
        return self._content_format

    @content_format.setter
    def content_format(self, content_format):
        """
        Sets the content_format of this LogAnalyticsTemplate.
        Content format. For example - XML.


        :param content_format: The content_format of this LogAnalyticsTemplate.
        :type: str
        """
        self._content_format = content_format

    @property
    def parameters(self):
        """
        Gets the parameters of this LogAnalyticsTemplate.
        Base64 encoded template parameters.


        :return: The parameters of this LogAnalyticsTemplate.
        :rtype: str
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """
        Sets the parameters of this LogAnalyticsTemplate.
        Base64 encoded template parameters.


        :param parameters: The parameters of this LogAnalyticsTemplate.
        :type: str
        """
        self._parameters = parameters

    @property
    def parameters_format(self):
        """
        Gets the parameters_format of this LogAnalyticsTemplate.
        Parameters format.  For example - NAME_VALUE_PAIR.


        :return: The parameters_format of this LogAnalyticsTemplate.
        :rtype: str
        """
        return self._parameters_format

    @parameters_format.setter
    def parameters_format(self, parameters_format):
        """
        Sets the parameters_format of this LogAnalyticsTemplate.
        Parameters format.  For example - NAME_VALUE_PAIR.


        :param parameters_format: The parameters_format of this LogAnalyticsTemplate.
        :type: str
        """
        self._parameters_format = parameters_format

    @property
    def parameters_metadata(self):
        """
        Gets the parameters_metadata of this LogAnalyticsTemplate.
        Base64 encoded parameters metadata definition.


        :return: The parameters_metadata of this LogAnalyticsTemplate.
        :rtype: str
        """
        return self._parameters_metadata

    @parameters_metadata.setter
    def parameters_metadata(self, parameters_metadata):
        """
        Sets the parameters_metadata of this LogAnalyticsTemplate.
        Base64 encoded parameters metadata definition.


        :param parameters_metadata: The parameters_metadata of this LogAnalyticsTemplate.
        :type: str
        """
        self._parameters_metadata = parameters_metadata

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
