# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateLookupMetadataDetails(object):
    """
    UpdateLookupMetadataDetails
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateLookupMetadataDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param default_match_value:
            The value to assign to the default_match_value property of this UpdateLookupMetadataDetails.
        :type default_match_value: str

        :param description:
            The value to assign to the description property of this UpdateLookupMetadataDetails.
        :type description: str

        :param fields:
            The value to assign to the fields property of this UpdateLookupMetadataDetails.
        :type fields: list[oci.log_analytics.models.LogAnalyticsLookupFields]

        :param max_matches:
            The value to assign to the max_matches property of this UpdateLookupMetadataDetails.
        :type max_matches: int

        :param categories:
            The value to assign to the categories property of this UpdateLookupMetadataDetails.
        :type categories: list[oci.log_analytics.models.LogAnalyticsCategory]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateLookupMetadataDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateLookupMetadataDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'default_match_value': 'str',
            'description': 'str',
            'fields': 'list[LogAnalyticsLookupFields]',
            'max_matches': 'int',
            'categories': 'list[LogAnalyticsCategory]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'default_match_value': 'defaultMatchValue',
            'description': 'description',
            'fields': 'fields',
            'max_matches': 'maxMatches',
            'categories': 'categories',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._default_match_value = None
        self._description = None
        self._fields = None
        self._max_matches = None
        self._categories = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def default_match_value(self):
        """
        Gets the default_match_value of this UpdateLookupMetadataDetails.
        The default match value.


        :return: The default_match_value of this UpdateLookupMetadataDetails.
        :rtype: str
        """
        return self._default_match_value

    @default_match_value.setter
    def default_match_value(self, default_match_value):
        """
        Sets the default_match_value of this UpdateLookupMetadataDetails.
        The default match value.


        :param default_match_value: The default_match_value of this UpdateLookupMetadataDetails.
        :type: str
        """
        self._default_match_value = default_match_value

    @property
    def description(self):
        """
        Gets the description of this UpdateLookupMetadataDetails.
        The lookup description.


        :return: The description of this UpdateLookupMetadataDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateLookupMetadataDetails.
        The lookup description.


        :param description: The description of this UpdateLookupMetadataDetails.
        :type: str
        """
        self._description = description

    @property
    def fields(self):
        """
        Gets the fields of this UpdateLookupMetadataDetails.
        The lookup fields.


        :return: The fields of this UpdateLookupMetadataDetails.
        :rtype: list[oci.log_analytics.models.LogAnalyticsLookupFields]
        """
        return self._fields

    @fields.setter
    def fields(self, fields):
        """
        Sets the fields of this UpdateLookupMetadataDetails.
        The lookup fields.


        :param fields: The fields of this UpdateLookupMetadataDetails.
        :type: list[oci.log_analytics.models.LogAnalyticsLookupFields]
        """
        self._fields = fields

    @property
    def max_matches(self):
        """
        Gets the max_matches of this UpdateLookupMetadataDetails.
        The maximum number of matches.


        :return: The max_matches of this UpdateLookupMetadataDetails.
        :rtype: int
        """
        return self._max_matches

    @max_matches.setter
    def max_matches(self, max_matches):
        """
        Sets the max_matches of this UpdateLookupMetadataDetails.
        The maximum number of matches.


        :param max_matches: The max_matches of this UpdateLookupMetadataDetails.
        :type: int
        """
        self._max_matches = max_matches

    @property
    def categories(self):
        """
        Gets the categories of this UpdateLookupMetadataDetails.
        An array of categories to assign to the lookup. Specifying the name attribute for each category would suffice.
        Oracle-defined category assignments cannot be removed.


        :return: The categories of this UpdateLookupMetadataDetails.
        :rtype: list[oci.log_analytics.models.LogAnalyticsCategory]
        """
        return self._categories

    @categories.setter
    def categories(self, categories):
        """
        Sets the categories of this UpdateLookupMetadataDetails.
        An array of categories to assign to the lookup. Specifying the name attribute for each category would suffice.
        Oracle-defined category assignments cannot be removed.


        :param categories: The categories of this UpdateLookupMetadataDetails.
        :type: list[oci.log_analytics.models.LogAnalyticsCategory]
        """
        self._categories = categories

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateLookupMetadataDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateLookupMetadataDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateLookupMetadataDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateLookupMetadataDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateLookupMetadataDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateLookupMetadataDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateLookupMetadataDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateLookupMetadataDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
