# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VariableDefinition(object):
    """
    Defines a variable used in a macro or the initization section of a query.
    """

    #: A constant which can be used with the type property of a VariableDefinition.
    #: This constant has a value of "NUMBER"
    TYPE_NUMBER = "NUMBER"

    #: A constant which can be used with the type property of a VariableDefinition.
    #: This constant has a value of "STRING"
    TYPE_STRING = "STRING"

    #: A constant which can be used with the type property of a VariableDefinition.
    #: This constant has a value of "TIMESTAMP"
    TYPE_TIMESTAMP = "TIMESTAMP"

    def __init__(self, **kwargs):
        """
        Initializes a new VariableDefinition object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this VariableDefinition.
        :type name: str

        :param description:
            The value to assign to the description property of this VariableDefinition.
        :type description: str

        :param type:
            The value to assign to the type property of this VariableDefinition.
            Allowed values for this property are: "NUMBER", "STRING", "TIMESTAMP", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param default_value:
            The value to assign to the default_value property of this VariableDefinition.
        :type default_value: str

        :param properties:
            The value to assign to the properties property of this VariableDefinition.
        :type properties: list[oci.log_analytics.models.PropertyDefinition]

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'type': 'str',
            'default_value': 'str',
            'properties': 'list[PropertyDefinition]'
        }
        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'type': 'type',
            'default_value': 'defaultValue',
            'properties': 'properties'
        }
        self._name = None
        self._description = None
        self._type = None
        self._default_value = None
        self._properties = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this VariableDefinition.
        Name of the variable preceded by a $.


        :return: The name of this VariableDefinition.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this VariableDefinition.
        Name of the variable preceded by a $.


        :param name: The name of this VariableDefinition.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this VariableDefinition.
        Descripion of the variable to show the user.


        :return: The description of this VariableDefinition.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this VariableDefinition.
        Descripion of the variable to show the user.


        :param description: The description of this VariableDefinition.
        :type: str
        """
        self._description = description

    @property
    def type(self):
        """
        Gets the type of this VariableDefinition.
        Type of the variable to show the user.

        Allowed values for this property are: "NUMBER", "STRING", "TIMESTAMP", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this VariableDefinition.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this VariableDefinition.
        Type of the variable to show the user.


        :param type: The type of this VariableDefinition.
        :type: str
        """
        allowed_values = ["NUMBER", "STRING", "TIMESTAMP"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def default_value(self):
        """
        Gets the default_value of this VariableDefinition.
        Default value of the variable is not already set.


        :return: The default_value of this VariableDefinition.
        :rtype: str
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """
        Sets the default_value of this VariableDefinition.
        Default value of the variable is not already set.


        :param default_value: The default_value of this VariableDefinition.
        :type: str
        """
        self._default_value = default_value

    @property
    def properties(self):
        """
        Gets the properties of this VariableDefinition.
        Optional list of properties for the variable.


        :return: The properties of this VariableDefinition.
        :rtype: list[oci.log_analytics.models.PropertyDefinition]
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this VariableDefinition.
        Optional list of properties for the variable.


        :param properties: The properties of this VariableDefinition.
        :type: list[oci.log_analytics.models.PropertyDefinition]
        """
        self._properties = properties

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
