# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LustreFileSystemSummary(object):
    """
    Summary information about a Lustre file system.
    """

    #: A constant which can be used with the performance_tier property of a LustreFileSystemSummary.
    #: This constant has a value of "MBPS_PER_TB_125"
    PERFORMANCE_TIER_MBPS_PER_TB_125 = "MBPS_PER_TB_125"

    #: A constant which can be used with the performance_tier property of a LustreFileSystemSummary.
    #: This constant has a value of "MBPS_PER_TB_250"
    PERFORMANCE_TIER_MBPS_PER_TB_250 = "MBPS_PER_TB_250"

    #: A constant which can be used with the performance_tier property of a LustreFileSystemSummary.
    #: This constant has a value of "MBPS_PER_TB_500"
    PERFORMANCE_TIER_MBPS_PER_TB_500 = "MBPS_PER_TB_500"

    #: A constant which can be used with the performance_tier property of a LustreFileSystemSummary.
    #: This constant has a value of "MBPS_PER_TB_1000"
    PERFORMANCE_TIER_MBPS_PER_TB_1000 = "MBPS_PER_TB_1000"

    def __init__(self, **kwargs):
        """
        Initializes a new LustreFileSystemSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this LustreFileSystemSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this LustreFileSystemSummary.
        :type compartment_id: str

        :param availability_domain:
            The value to assign to the availability_domain property of this LustreFileSystemSummary.
        :type availability_domain: str

        :param display_name:
            The value to assign to the display_name property of this LustreFileSystemSummary.
        :type display_name: str

        :param file_system_description:
            The value to assign to the file_system_description property of this LustreFileSystemSummary.
        :type file_system_description: str

        :param time_created:
            The value to assign to the time_created property of this LustreFileSystemSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this LustreFileSystemSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this LustreFileSystemSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this LustreFileSystemSummary.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this LustreFileSystemSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this LustreFileSystemSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this LustreFileSystemSummary.
        :type system_tags: dict(str, dict(str, object))

        :param nsg_ids:
            The value to assign to the nsg_ids property of this LustreFileSystemSummary.
        :type nsg_ids: list[str]

        :param file_system_name:
            The value to assign to the file_system_name property of this LustreFileSystemSummary.
        :type file_system_name: str

        :param kms_key_id:
            The value to assign to the kms_key_id property of this LustreFileSystemSummary.
        :type kms_key_id: str

        :param capacity_in_gbs:
            The value to assign to the capacity_in_gbs property of this LustreFileSystemSummary.
        :type capacity_in_gbs: int

        :param subnet_id:
            The value to assign to the subnet_id property of this LustreFileSystemSummary.
        :type subnet_id: str

        :param performance_tier:
            The value to assign to the performance_tier property of this LustreFileSystemSummary.
            Allowed values for this property are: "MBPS_PER_TB_125", "MBPS_PER_TB_250", "MBPS_PER_TB_500", "MBPS_PER_TB_1000", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type performance_tier: str

        :param time_billing_cycle_end:
            The value to assign to the time_billing_cycle_end property of this LustreFileSystemSummary.
        :type time_billing_cycle_end: datetime

        :param management_service_address:
            The value to assign to the management_service_address property of this LustreFileSystemSummary.
        :type management_service_address: str

        :param lnet:
            The value to assign to the lnet property of this LustreFileSystemSummary.
        :type lnet: str

        :param cluster_placement_group_id:
            The value to assign to the cluster_placement_group_id property of this LustreFileSystemSummary.
        :type cluster_placement_group_id: str

        :param major_version:
            The value to assign to the major_version property of this LustreFileSystemSummary.
        :type major_version: str

        :param root_squash_configuration:
            The value to assign to the root_squash_configuration property of this LustreFileSystemSummary.
        :type root_squash_configuration: oci.lustre_file_storage.models.RootSquashConfiguration

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'availability_domain': 'str',
            'display_name': 'str',
            'file_system_description': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'nsg_ids': 'list[str]',
            'file_system_name': 'str',
            'kms_key_id': 'str',
            'capacity_in_gbs': 'int',
            'subnet_id': 'str',
            'performance_tier': 'str',
            'time_billing_cycle_end': 'datetime',
            'management_service_address': 'str',
            'lnet': 'str',
            'cluster_placement_group_id': 'str',
            'major_version': 'str',
            'root_squash_configuration': 'RootSquashConfiguration'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'availability_domain': 'availabilityDomain',
            'display_name': 'displayName',
            'file_system_description': 'fileSystemDescription',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'nsg_ids': 'nsgIds',
            'file_system_name': 'fileSystemName',
            'kms_key_id': 'kmsKeyId',
            'capacity_in_gbs': 'capacityInGBs',
            'subnet_id': 'subnetId',
            'performance_tier': 'performanceTier',
            'time_billing_cycle_end': 'timeBillingCycleEnd',
            'management_service_address': 'managementServiceAddress',
            'lnet': 'lnet',
            'cluster_placement_group_id': 'clusterPlacementGroupId',
            'major_version': 'majorVersion',
            'root_squash_configuration': 'rootSquashConfiguration'
        }
        self._id = None
        self._compartment_id = None
        self._availability_domain = None
        self._display_name = None
        self._file_system_description = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._nsg_ids = None
        self._file_system_name = None
        self._kms_key_id = None
        self._capacity_in_gbs = None
        self._subnet_id = None
        self._performance_tier = None
        self._time_billing_cycle_end = None
        self._management_service_address = None
        self._lnet = None
        self._cluster_placement_group_id = None
        self._major_version = None
        self._root_squash_configuration = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this LustreFileSystemSummary.
        The `OCID`__ of the Lustre file system.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this LustreFileSystemSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this LustreFileSystemSummary.
        The `OCID`__ of the Lustre file system.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this LustreFileSystemSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this LustreFileSystemSummary.
        The `OCID`__ of the compartment that contains the Lustre file system.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this LustreFileSystemSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this LustreFileSystemSummary.
        The `OCID`__ of the compartment that contains the Lustre file system.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this LustreFileSystemSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this LustreFileSystemSummary.
        The availability domain the file system is in. May be unset
        as a blank or NULL value.

        Example: `Uocm:PHX-AD-1`


        :return: The availability_domain of this LustreFileSystemSummary.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this LustreFileSystemSummary.
        The availability domain the file system is in. May be unset
        as a blank or NULL value.

        Example: `Uocm:PHX-AD-1`


        :param availability_domain: The availability_domain of this LustreFileSystemSummary.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this LustreFileSystemSummary.
        A user-friendly name. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.

        Example: `My Lustre file system`


        :return: The display_name of this LustreFileSystemSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this LustreFileSystemSummary.
        A user-friendly name. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.

        Example: `My Lustre file system`


        :param display_name: The display_name of this LustreFileSystemSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def file_system_description(self):
        """
        **[Required]** Gets the file_system_description of this LustreFileSystemSummary.
        Short description of the Lustre file system.
        Avoid entering confidential information.


        :return: The file_system_description of this LustreFileSystemSummary.
        :rtype: str
        """
        return self._file_system_description

    @file_system_description.setter
    def file_system_description(self, file_system_description):
        """
        Sets the file_system_description of this LustreFileSystemSummary.
        Short description of the Lustre file system.
        Avoid entering confidential information.


        :param file_system_description: The file_system_description of this LustreFileSystemSummary.
        :type: str
        """
        self._file_system_description = file_system_description

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this LustreFileSystemSummary.
        The date and time the Lustre file system was created, expressed
        in `RFC 3339`__ timestamp format.

        Example: `2024-04-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this LustreFileSystemSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this LustreFileSystemSummary.
        The date and time the Lustre file system was created, expressed
        in `RFC 3339`__ timestamp format.

        Example: `2024-04-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this LustreFileSystemSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this LustreFileSystemSummary.
        The date and time the Lustre file system was updated, in the format defined by `RFC 3339`__.

        Example: `2024-04-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this LustreFileSystemSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this LustreFileSystemSummary.
        The date and time the Lustre file system was updated, in the format defined by `RFC 3339`__.

        Example: `2024-04-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this LustreFileSystemSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this LustreFileSystemSummary.
        The current state of the Lustre file system.


        :return: The lifecycle_state of this LustreFileSystemSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this LustreFileSystemSummary.
        The current state of the Lustre file system.


        :param lifecycle_state: The lifecycle_state of this LustreFileSystemSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this LustreFileSystemSummary.
        A message that describes the current state of the Lustre file system in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this LustreFileSystemSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this LustreFileSystemSummary.
        A message that describes the current state of the Lustre file system in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this LustreFileSystemSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this LustreFileSystemSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this LustreFileSystemSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this LustreFileSystemSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this LustreFileSystemSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this LustreFileSystemSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this LustreFileSystemSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this LustreFileSystemSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this LustreFileSystemSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        **[Required]** Gets the system_tags of this LustreFileSystemSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this LustreFileSystemSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this LustreFileSystemSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this LustreFileSystemSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this LustreFileSystemSummary.
        A list of Network Security Group `OCIDs`__ associated with this lustre file system.
        A maximum of 5 is allowed.
        Setting this to an empty array after the list is created removes the lustre file system from all NSGs.
        For more information about NSGs, see `Security Rules`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/Network/Concepts/securityrules.htm


        :return: The nsg_ids of this LustreFileSystemSummary.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this LustreFileSystemSummary.
        A list of Network Security Group `OCIDs`__ associated with this lustre file system.
        A maximum of 5 is allowed.
        Setting this to an empty array after the list is created removes the lustre file system from all NSGs.
        For more information about NSGs, see `Security Rules`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/Network/Concepts/securityrules.htm


        :param nsg_ids: The nsg_ids of this LustreFileSystemSummary.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def file_system_name(self):
        """
        **[Required]** Gets the file_system_name of this LustreFileSystemSummary.
        The Lustre file system name. This is used in mount commands and other aspects of the client command line interface.
        The default file system name is 'lustre'. The file system name is limited to 8 characters. Allowed characters are lower and upper case English letters, numbers, and '_'.


        :return: The file_system_name of this LustreFileSystemSummary.
        :rtype: str
        """
        return self._file_system_name

    @file_system_name.setter
    def file_system_name(self, file_system_name):
        """
        Sets the file_system_name of this LustreFileSystemSummary.
        The Lustre file system name. This is used in mount commands and other aspects of the client command line interface.
        The default file system name is 'lustre'. The file system name is limited to 8 characters. Allowed characters are lower and upper case English letters, numbers, and '_'.


        :param file_system_name: The file_system_name of this LustreFileSystemSummary.
        :type: str
        """
        self._file_system_name = file_system_name

    @property
    def kms_key_id(self):
        """
        Gets the kms_key_id of this LustreFileSystemSummary.
        The `OCID`__ of the KMS key used to encrypt the encryption keys associated with this file system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The kms_key_id of this LustreFileSystemSummary.
        :rtype: str
        """
        return self._kms_key_id

    @kms_key_id.setter
    def kms_key_id(self, kms_key_id):
        """
        Sets the kms_key_id of this LustreFileSystemSummary.
        The `OCID`__ of the KMS key used to encrypt the encryption keys associated with this file system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param kms_key_id: The kms_key_id of this LustreFileSystemSummary.
        :type: str
        """
        self._kms_key_id = kms_key_id

    @property
    def capacity_in_gbs(self):
        """
        **[Required]** Gets the capacity_in_gbs of this LustreFileSystemSummary.
        Capacity of the Lustre file system in GB.


        :return: The capacity_in_gbs of this LustreFileSystemSummary.
        :rtype: int
        """
        return self._capacity_in_gbs

    @capacity_in_gbs.setter
    def capacity_in_gbs(self, capacity_in_gbs):
        """
        Sets the capacity_in_gbs of this LustreFileSystemSummary.
        Capacity of the Lustre file system in GB.


        :param capacity_in_gbs: The capacity_in_gbs of this LustreFileSystemSummary.
        :type: int
        """
        self._capacity_in_gbs = capacity_in_gbs

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this LustreFileSystemSummary.
        The `OCID`__ of the subnet the Lustre file system is in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this LustreFileSystemSummary.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this LustreFileSystemSummary.
        The `OCID`__ of the subnet the Lustre file system is in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this LustreFileSystemSummary.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def performance_tier(self):
        """
        **[Required]** Gets the performance_tier of this LustreFileSystemSummary.
        The Lustre file system performance tier. A value of `MBPS_PER_TB_125` represents 125 megabytes per second per terabyte.

        Allowed values for this property are: "MBPS_PER_TB_125", "MBPS_PER_TB_250", "MBPS_PER_TB_500", "MBPS_PER_TB_1000", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The performance_tier of this LustreFileSystemSummary.
        :rtype: str
        """
        return self._performance_tier

    @performance_tier.setter
    def performance_tier(self, performance_tier):
        """
        Sets the performance_tier of this LustreFileSystemSummary.
        The Lustre file system performance tier. A value of `MBPS_PER_TB_125` represents 125 megabytes per second per terabyte.


        :param performance_tier: The performance_tier of this LustreFileSystemSummary.
        :type: str
        """
        allowed_values = ["MBPS_PER_TB_125", "MBPS_PER_TB_250", "MBPS_PER_TB_500", "MBPS_PER_TB_1000"]
        if not value_allowed_none_or_none_sentinel(performance_tier, allowed_values):
            performance_tier = 'UNKNOWN_ENUM_VALUE'
        self._performance_tier = performance_tier

    @property
    def time_billing_cycle_end(self):
        """
        **[Required]** Gets the time_billing_cycle_end of this LustreFileSystemSummary.
        The date and time the LustreFileSystem current billing cycle will end, expressed in
        `RFC 3339`__ timestamp format. Once a cycle ends,
        it is updated automatically to next timestamp which is after 30 days.
        File systems deleted earlier will still incur charges till this date.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_billing_cycle_end of this LustreFileSystemSummary.
        :rtype: datetime
        """
        return self._time_billing_cycle_end

    @time_billing_cycle_end.setter
    def time_billing_cycle_end(self, time_billing_cycle_end):
        """
        Sets the time_billing_cycle_end of this LustreFileSystemSummary.
        The date and time the LustreFileSystem current billing cycle will end, expressed in
        `RFC 3339`__ timestamp format. Once a cycle ends,
        it is updated automatically to next timestamp which is after 30 days.
        File systems deleted earlier will still incur charges till this date.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_billing_cycle_end: The time_billing_cycle_end of this LustreFileSystemSummary.
        :type: datetime
        """
        self._time_billing_cycle_end = time_billing_cycle_end

    @property
    def management_service_address(self):
        """
        **[Required]** Gets the management_service_address of this LustreFileSystemSummary.
        The IPv4 address of MGS (Lustre Management Service) used by clients to mount the file system.

        Example: `10.0.0.4`


        :return: The management_service_address of this LustreFileSystemSummary.
        :rtype: str
        """
        return self._management_service_address

    @management_service_address.setter
    def management_service_address(self, management_service_address):
        """
        Sets the management_service_address of this LustreFileSystemSummary.
        The IPv4 address of MGS (Lustre Management Service) used by clients to mount the file system.

        Example: `10.0.0.4`


        :param management_service_address: The management_service_address of this LustreFileSystemSummary.
        :type: str
        """
        self._management_service_address = management_service_address

    @property
    def lnet(self):
        """
        **[Required]** Gets the lnet of this LustreFileSystemSummary.
        Type of network used by clients to mount the file system.

        Example: `tcp`


        :return: The lnet of this LustreFileSystemSummary.
        :rtype: str
        """
        return self._lnet

    @lnet.setter
    def lnet(self, lnet):
        """
        Sets the lnet of this LustreFileSystemSummary.
        Type of network used by clients to mount the file system.

        Example: `tcp`


        :param lnet: The lnet of this LustreFileSystemSummary.
        :type: str
        """
        self._lnet = lnet

    @property
    def cluster_placement_group_id(self):
        """
        Gets the cluster_placement_group_id of this LustreFileSystemSummary.
        The `OCID`__ of the cluster placement group in which the Lustre file system exists.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The cluster_placement_group_id of this LustreFileSystemSummary.
        :rtype: str
        """
        return self._cluster_placement_group_id

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, cluster_placement_group_id):
        """
        Sets the cluster_placement_group_id of this LustreFileSystemSummary.
        The `OCID`__ of the cluster placement group in which the Lustre file system exists.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param cluster_placement_group_id: The cluster_placement_group_id of this LustreFileSystemSummary.
        :type: str
        """
        self._cluster_placement_group_id = cluster_placement_group_id

    @property
    def major_version(self):
        """
        **[Required]** Gets the major_version of this LustreFileSystemSummary.
        Major version of Lustre running in the Lustre file system.

        Example: `2.15`


        :return: The major_version of this LustreFileSystemSummary.
        :rtype: str
        """
        return self._major_version

    @major_version.setter
    def major_version(self, major_version):
        """
        Sets the major_version of this LustreFileSystemSummary.
        Major version of Lustre running in the Lustre file system.

        Example: `2.15`


        :param major_version: The major_version of this LustreFileSystemSummary.
        :type: str
        """
        self._major_version = major_version

    @property
    def root_squash_configuration(self):
        """
        **[Required]** Gets the root_squash_configuration of this LustreFileSystemSummary.

        :return: The root_squash_configuration of this LustreFileSystemSummary.
        :rtype: oci.lustre_file_storage.models.RootSquashConfiguration
        """
        return self._root_squash_configuration

    @root_squash_configuration.setter
    def root_squash_configuration(self, root_squash_configuration):
        """
        Sets the root_squash_configuration of this LustreFileSystemSummary.

        :param root_squash_configuration: The root_squash_configuration of this LustreFileSystemSummary.
        :type: oci.lustre_file_storage.models.RootSquashConfiguration
        """
        self._root_squash_configuration = root_squash_configuration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
