# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200202


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DataSource(object):
    """
    A representation of a source configuration setup in the Management Agent.
    """

    #: A constant which can be used with the type property of a DataSource.
    #: This constant has a value of "KUBERNETES_CLUSTER"
    TYPE_KUBERNETES_CLUSTER = "KUBERNETES_CLUSTER"

    #: A constant which can be used with the type property of a DataSource.
    #: This constant has a value of "PROMETHEUS_EMITTER"
    TYPE_PROMETHEUS_EMITTER = "PROMETHEUS_EMITTER"

    #: A constant which can be used with the state property of a DataSource.
    #: This constant has a value of "CREATING"
    STATE_CREATING = "CREATING"

    #: A constant which can be used with the state property of a DataSource.
    #: This constant has a value of "UPDATING"
    STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the state property of a DataSource.
    #: This constant has a value of "ACTIVE"
    STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the state property of a DataSource.
    #: This constant has a value of "INACTIVE"
    STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the state property of a DataSource.
    #: This constant has a value of "TERMINATED"
    STATE_TERMINATED = "TERMINATED"

    #: A constant which can be used with the state property of a DataSource.
    #: This constant has a value of "DELETING"
    STATE_DELETING = "DELETING"

    #: A constant which can be used with the state property of a DataSource.
    #: This constant has a value of "DELETED"
    STATE_DELETED = "DELETED"

    #: A constant which can be used with the state property of a DataSource.
    #: This constant has a value of "FAILED"
    STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new DataSource object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.management_agent.models.KubernetesClusterDataSource`
        * :class:`~oci.management_agent.models.PrometheusEmitterDataSource`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this DataSource.
        :type key: str

        :param type:
            The value to assign to the type property of this DataSource.
            Allowed values for this property are: "KUBERNETES_CLUSTER", "PROMETHEUS_EMITTER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param name:
            The value to assign to the name property of this DataSource.
        :type name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DataSource.
        :type compartment_id: str

        :param state:
            The value to assign to the state property of this DataSource.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "TERMINATED", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type state: str

        :param time_created:
            The value to assign to the time_created property of this DataSource.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DataSource.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'key': 'str',
            'type': 'str',
            'name': 'str',
            'compartment_id': 'str',
            'state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime'
        }
        self.attribute_map = {
            'key': 'key',
            'type': 'type',
            'name': 'name',
            'compartment_id': 'compartmentId',
            'state': 'state',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated'
        }
        self._key = None
        self._type = None
        self._name = None
        self._compartment_id = None
        self._state = None
        self._time_created = None
        self._time_updated = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'KUBERNETES_CLUSTER':
            return 'KubernetesClusterDataSource'

        if type == 'PROMETHEUS_EMITTER':
            return 'PrometheusEmitterDataSource'
        else:
            return 'DataSource'

    @property
    def key(self):
        """
        **[Required]** Gets the key of this DataSource.
        Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.


        :return: The key of this DataSource.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this DataSource.
        Identifier for DataSource. This represents the type and name for the data source associated with the Management Agent.


        :param key: The key of this DataSource.
        :type: str
        """
        self._key = key

    @property
    def type(self):
        """
        **[Required]** Gets the type of this DataSource.
        The type of the DataSource.

        Allowed values for this property are: "KUBERNETES_CLUSTER", "PROMETHEUS_EMITTER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this DataSource.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this DataSource.
        The type of the DataSource.


        :param type: The type of this DataSource.
        :type: str
        """
        allowed_values = ["KUBERNETES_CLUSTER", "PROMETHEUS_EMITTER"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def name(self):
        """
        **[Required]** Gets the name of this DataSource.
        Unique name of the DataSource.


        :return: The name of this DataSource.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DataSource.
        Unique name of the DataSource.


        :param name: The name of this DataSource.
        :type: str
        """
        self._name = name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DataSource.
        Compartment owning this DataSource.


        :return: The compartment_id of this DataSource.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DataSource.
        Compartment owning this DataSource.


        :param compartment_id: The compartment_id of this DataSource.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def state(self):
        """
        **[Required]** Gets the state of this DataSource.
        State of the DataSource.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "TERMINATED", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The state of this DataSource.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this DataSource.
        State of the DataSource.


        :param state: The state of this DataSource.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "INACTIVE", "TERMINATED", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(state, allowed_values):
            state = 'UNKNOWN_ENUM_VALUE'
        self._state = state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DataSource.
        The time the DataSource was created. An RFC3339 formatted datetime string


        :return: The time_created of this DataSource.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DataSource.
        The time the DataSource was created. An RFC3339 formatted datetime string


        :param time_created: The time_created of this DataSource.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this DataSource.
        The time the DataSource data was last received. An RFC3339 formatted datetime string


        :return: The time_updated of this DataSource.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DataSource.
        The time the DataSource data was last received. An RFC3339 formatted datetime string


        :param time_updated: The time_updated of this DataSource.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
