# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200202


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NamedCredential(object):
    """
    A representation of a named credential in the Management Agent.
    """

    #: A constant which can be used with the lifecycle_state property of a NamedCredential.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a NamedCredential.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a NamedCredential.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a NamedCredential.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a NamedCredential.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a NamedCredential.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new NamedCredential object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this NamedCredential.
        :type id: str

        :param name:
            The value to assign to the name property of this NamedCredential.
        :type name: str

        :param type:
            The value to assign to the type property of this NamedCredential.
        :type type: str

        :param management_agent_id:
            The value to assign to the management_agent_id property of this NamedCredential.
        :type management_agent_id: str

        :param description:
            The value to assign to the description property of this NamedCredential.
        :type description: str

        :param time_created:
            The value to assign to the time_created property of this NamedCredential.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this NamedCredential.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this NamedCredential.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param properties:
            The value to assign to the properties property of this NamedCredential.
        :type properties: list[oci.management_agent.models.NamedCredentialProperty]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this NamedCredential.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this NamedCredential.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this NamedCredential.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'type': 'str',
            'management_agent_id': 'str',
            'description': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'properties': 'list[NamedCredentialProperty]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'type': 'type',
            'management_agent_id': 'managementAgentId',
            'description': 'description',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'properties': 'properties',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._name = None
        self._type = None
        self._management_agent_id = None
        self._description = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._properties = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this NamedCredential.
        Identifier for Named Credential.


        :return: The id of this NamedCredential.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this NamedCredential.
        Identifier for Named Credential.


        :param id: The id of this NamedCredential.
        :type: str
        """
        self._id = id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this NamedCredential.
        Name for Named Credential. This is unique for the Management Agent.


        :return: The name of this NamedCredential.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this NamedCredential.
        Name for Named Credential. This is unique for the Management Agent.


        :param name: The name of this NamedCredential.
        :type: str
        """
        self._name = name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this NamedCredential.
        The type of the Named Credential.


        :return: The type of this NamedCredential.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this NamedCredential.
        The type of the Named Credential.


        :param type: The type of this NamedCredential.
        :type: str
        """
        self._type = type

    @property
    def management_agent_id(self):
        """
        **[Required]** Gets the management_agent_id of this NamedCredential.
        The Management Agent parent resource to associated with this named credential. This is the ManagementAgent resource OCID.


        :return: The management_agent_id of this NamedCredential.
        :rtype: str
        """
        return self._management_agent_id

    @management_agent_id.setter
    def management_agent_id(self, management_agent_id):
        """
        Sets the management_agent_id of this NamedCredential.
        The Management Agent parent resource to associated with this named credential. This is the ManagementAgent resource OCID.


        :param management_agent_id: The management_agent_id of this NamedCredential.
        :type: str
        """
        self._management_agent_id = management_agent_id

    @property
    def description(self):
        """
        Gets the description of this NamedCredential.
        Description of the Named Credential.


        :return: The description of this NamedCredential.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this NamedCredential.
        Description of the Named Credential.


        :param description: The description of this NamedCredential.
        :type: str
        """
        self._description = description

    @property
    def time_created(self):
        """
        Gets the time_created of this NamedCredential.
        The time the Named Credential was created. An RFC3339 formatted datetime string


        :return: The time_created of this NamedCredential.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this NamedCredential.
        The time the Named Credential was created. An RFC3339 formatted datetime string


        :param time_created: The time_created of this NamedCredential.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this NamedCredential.
        The time the Named Credential data was last updated. An RFC3339 formatted datetime string


        :return: The time_updated of this NamedCredential.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this NamedCredential.
        The time the Named Credential data was last updated. An RFC3339 formatted datetime string


        :param time_updated: The time_updated of this NamedCredential.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this NamedCredential.
        The current state of the named credential

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this NamedCredential.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this NamedCredential.
        The current state of the named credential


        :param lifecycle_state: The lifecycle_state of this NamedCredential.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def properties(self):
        """
        **[Required]** Gets the properties of this NamedCredential.
        Properties for the named credential


        :return: The properties of this NamedCredential.
        :rtype: list[oci.management_agent.models.NamedCredentialProperty]
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this NamedCredential.
        Properties for the named credential


        :param properties: The properties of this NamedCredential.
        :type: list[oci.management_agent.models.NamedCredentialProperty]
        """
        self._properties = properties

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this NamedCredential.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this NamedCredential.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this NamedCredential.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this NamedCredential.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this NamedCredential.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this NamedCredential.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this NamedCredential.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this NamedCredential.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this NamedCredential.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{ \"orcl-cloud\": { \"free-tier-retained\": \"true\" } }`


        :return: The system_tags of this NamedCredential.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this NamedCredential.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{ \"orcl-cloud\": { \"free-tier-retained\": \"true\" } }`


        :param system_tags: The system_tags of this NamedCredential.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
