# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Pricing(object):
    """
    the pricing information for the offer
    """

    #: A constant which can be used with the billing_cycle property of a Pricing.
    #: This constant has a value of "ONE_TIME"
    BILLING_CYCLE_ONE_TIME = "ONE_TIME"

    def __init__(self, **kwargs):
        """
        Initializes a new Pricing object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param currency_type:
            The value to assign to the currency_type property of this Pricing.
        :type currency_type: str

        :param total_amount:
            The value to assign to the total_amount property of this Pricing.
        :type total_amount: int

        :param billing_cycle:
            The value to assign to the billing_cycle property of this Pricing.
            Allowed values for this property are: "ONE_TIME", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type billing_cycle: str

        """
        self.swagger_types = {
            'currency_type': 'str',
            'total_amount': 'int',
            'billing_cycle': 'str'
        }
        self.attribute_map = {
            'currency_type': 'currencyType',
            'total_amount': 'totalAmount',
            'billing_cycle': 'billingCycle'
        }
        self._currency_type = None
        self._total_amount = None
        self._billing_cycle = None

    @property
    def currency_type(self):
        """
        Gets the currency_type of this Pricing.
        The currency supported for a given Offer, in the format specified by ISO-4217


        :return: The currency_type of this Pricing.
        :rtype: str
        """
        return self._currency_type

    @currency_type.setter
    def currency_type(self, currency_type):
        """
        Sets the currency_type of this Pricing.
        The currency supported for a given Offer, in the format specified by ISO-4217


        :param currency_type: The currency_type of this Pricing.
        :type: str
        """
        self._currency_type = currency_type

    @property
    def total_amount(self):
        """
        Gets the total_amount of this Pricing.
        The total amount an Offer costs


        :return: The total_amount of this Pricing.
        :rtype: int
        """
        return self._total_amount

    @total_amount.setter
    def total_amount(self, total_amount):
        """
        Sets the total_amount of this Pricing.
        The total amount an Offer costs


        :param total_amount: The total_amount of this Pricing.
        :type: int
        """
        self._total_amount = total_amount

    @property
    def billing_cycle(self):
        """
        Gets the billing_cycle of this Pricing.
        The frequency at which the customer is billed for the Offer

        Allowed values for this property are: "ONE_TIME", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The billing_cycle of this Pricing.
        :rtype: str
        """
        return self._billing_cycle

    @billing_cycle.setter
    def billing_cycle(self, billing_cycle):
        """
        Sets the billing_cycle of this Pricing.
        The frequency at which the customer is billed for the Offer


        :param billing_cycle: The billing_cycle of this Pricing.
        :type: str
        """
        allowed_values = ["ONE_TIME"]
        if not value_allowed_none_or_none_sentinel(billing_cycle, allowed_values):
            billing_cycle = 'UNKNOWN_ENUM_VALUE'
        self._billing_cycle = billing_cycle

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
