# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201

from .create_listing_revision_details import CreateListingRevisionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateOciListingRevisionDetails(CreateListingRevisionDetails):
    """
    Listing revision update details for listings
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateOciListingRevisionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.marketplace_publisher.models.CreateOciListingRevisionDetails.listing_type` attribute
        of this class is ``OCI_APPLICATION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateOciListingRevisionDetails.
        :type display_name: str

        :param listing_id:
            The value to assign to the listing_id property of this CreateOciListingRevisionDetails.
        :type listing_id: str

        :param listing_type:
            The value to assign to the listing_type property of this CreateOciListingRevisionDetails.
            Allowed values for this property are: "OCI_APPLICATION", "LEAD_GENERATION", "SERVICE"
        :type listing_type: str

        :param headline:
            The value to assign to the headline property of this CreateOciListingRevisionDetails.
        :type headline: str

        :param tagline:
            The value to assign to the tagline property of this CreateOciListingRevisionDetails.
        :type tagline: str

        :param keywords:
            The value to assign to the keywords property of this CreateOciListingRevisionDetails.
        :type keywords: str

        :param short_description:
            The value to assign to the short_description property of this CreateOciListingRevisionDetails.
        :type short_description: str

        :param usage_information:
            The value to assign to the usage_information property of this CreateOciListingRevisionDetails.
        :type usage_information: str

        :param long_description:
            The value to assign to the long_description property of this CreateOciListingRevisionDetails.
        :type long_description: str

        :param content_language:
            The value to assign to the content_language property of this CreateOciListingRevisionDetails.
        :type content_language: oci.marketplace_publisher.models.LanguageItem

        :param supportedlanguages:
            The value to assign to the supportedlanguages property of this CreateOciListingRevisionDetails.
        :type supportedlanguages: list[oci.marketplace_publisher.models.LanguageItem]

        :param support_contacts:
            The value to assign to the support_contacts property of this CreateOciListingRevisionDetails.
        :type support_contacts: list[oci.marketplace_publisher.models.SupportContact]

        :param support_links:
            The value to assign to the support_links property of this CreateOciListingRevisionDetails.
        :type support_links: list[oci.marketplace_publisher.models.NamedLink]

        :param status:
            The value to assign to the status property of this CreateOciListingRevisionDetails.
        :type status: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateOciListingRevisionDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateOciListingRevisionDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param version_details:
            The value to assign to the version_details property of this CreateOciListingRevisionDetails.
        :type version_details: oci.marketplace_publisher.models.VersionDetails

        :param system_requirements:
            The value to assign to the system_requirements property of this CreateOciListingRevisionDetails.
        :type system_requirements: str

        :param pricing_type:
            The value to assign to the pricing_type property of this CreateOciListingRevisionDetails.
        :type pricing_type: str

        :param products:
            The value to assign to the products property of this CreateOciListingRevisionDetails.
        :type products: list[oci.marketplace_publisher.models.ListingProduct]

        :param pricing_plans:
            The value to assign to the pricing_plans property of this CreateOciListingRevisionDetails.
        :type pricing_plans: list[oci.marketplace_publisher.models.PricingPlan]

        :param vanity_url:
            The value to assign to the vanity_url property of this CreateOciListingRevisionDetails.
        :type vanity_url: str

        :param recommended_service_provider_listing_ids:
            The value to assign to the recommended_service_provider_listing_ids property of this CreateOciListingRevisionDetails.
        :type recommended_service_provider_listing_ids: list[str]

        :param availability_and_pricing_policy:
            The value to assign to the availability_and_pricing_policy property of this CreateOciListingRevisionDetails.
        :type availability_and_pricing_policy: str

        :param is_rover_exportable:
            The value to assign to the is_rover_exportable property of this CreateOciListingRevisionDetails.
        :type is_rover_exportable: bool

        """
        self.swagger_types = {
            'display_name': 'str',
            'listing_id': 'str',
            'listing_type': 'str',
            'headline': 'str',
            'tagline': 'str',
            'keywords': 'str',
            'short_description': 'str',
            'usage_information': 'str',
            'long_description': 'str',
            'content_language': 'LanguageItem',
            'supportedlanguages': 'list[LanguageItem]',
            'support_contacts': 'list[SupportContact]',
            'support_links': 'list[NamedLink]',
            'status': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'version_details': 'VersionDetails',
            'system_requirements': 'str',
            'pricing_type': 'str',
            'products': 'list[ListingProduct]',
            'pricing_plans': 'list[PricingPlan]',
            'vanity_url': 'str',
            'recommended_service_provider_listing_ids': 'list[str]',
            'availability_and_pricing_policy': 'str',
            'is_rover_exportable': 'bool'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'listing_id': 'listingId',
            'listing_type': 'listingType',
            'headline': 'headline',
            'tagline': 'tagline',
            'keywords': 'keywords',
            'short_description': 'shortDescription',
            'usage_information': 'usageInformation',
            'long_description': 'longDescription',
            'content_language': 'contentLanguage',
            'supportedlanguages': 'supportedlanguages',
            'support_contacts': 'supportContacts',
            'support_links': 'supportLinks',
            'status': 'status',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'version_details': 'versionDetails',
            'system_requirements': 'systemRequirements',
            'pricing_type': 'pricingType',
            'products': 'products',
            'pricing_plans': 'pricingPlans',
            'vanity_url': 'vanityUrl',
            'recommended_service_provider_listing_ids': 'recommendedServiceProviderListingIds',
            'availability_and_pricing_policy': 'availabilityAndPricingPolicy',
            'is_rover_exportable': 'isRoverExportable'
        }
        self._display_name = None
        self._listing_id = None
        self._listing_type = None
        self._headline = None
        self._tagline = None
        self._keywords = None
        self._short_description = None
        self._usage_information = None
        self._long_description = None
        self._content_language = None
        self._supportedlanguages = None
        self._support_contacts = None
        self._support_links = None
        self._status = None
        self._freeform_tags = None
        self._defined_tags = None
        self._version_details = None
        self._system_requirements = None
        self._pricing_type = None
        self._products = None
        self._pricing_plans = None
        self._vanity_url = None
        self._recommended_service_provider_listing_ids = None
        self._availability_and_pricing_policy = None
        self._is_rover_exportable = None
        self._listing_type = 'OCI_APPLICATION'

    @property
    def version_details(self):
        """
        Gets the version_details of this CreateOciListingRevisionDetails.

        :return: The version_details of this CreateOciListingRevisionDetails.
        :rtype: oci.marketplace_publisher.models.VersionDetails
        """
        return self._version_details

    @version_details.setter
    def version_details(self, version_details):
        """
        Sets the version_details of this CreateOciListingRevisionDetails.

        :param version_details: The version_details of this CreateOciListingRevisionDetails.
        :type: oci.marketplace_publisher.models.VersionDetails
        """
        self._version_details = version_details

    @property
    def system_requirements(self):
        """
        Gets the system_requirements of this CreateOciListingRevisionDetails.
        System requirements for the listing revision.


        :return: The system_requirements of this CreateOciListingRevisionDetails.
        :rtype: str
        """
        return self._system_requirements

    @system_requirements.setter
    def system_requirements(self, system_requirements):
        """
        Sets the system_requirements of this CreateOciListingRevisionDetails.
        System requirements for the listing revision.


        :param system_requirements: The system_requirements of this CreateOciListingRevisionDetails.
        :type: str
        """
        self._system_requirements = system_requirements

    @property
    def pricing_type(self):
        """
        **[Required]** Gets the pricing_type of this CreateOciListingRevisionDetails.
        The pricing model for the listing revision.


        :return: The pricing_type of this CreateOciListingRevisionDetails.
        :rtype: str
        """
        return self._pricing_type

    @pricing_type.setter
    def pricing_type(self, pricing_type):
        """
        Sets the pricing_type of this CreateOciListingRevisionDetails.
        The pricing model for the listing revision.


        :param pricing_type: The pricing_type of this CreateOciListingRevisionDetails.
        :type: str
        """
        self._pricing_type = pricing_type

    @property
    def products(self):
        """
        **[Required]** Gets the products of this CreateOciListingRevisionDetails.
        List of Products subscribed by listing.


        :return: The products of this CreateOciListingRevisionDetails.
        :rtype: list[oci.marketplace_publisher.models.ListingProduct]
        """
        return self._products

    @products.setter
    def products(self, products):
        """
        Sets the products of this CreateOciListingRevisionDetails.
        List of Products subscribed by listing.


        :param products: The products of this CreateOciListingRevisionDetails.
        :type: list[oci.marketplace_publisher.models.ListingProduct]
        """
        self._products = products

    @property
    def pricing_plans(self):
        """
        Gets the pricing_plans of this CreateOciListingRevisionDetails.
        List of Pricing Plans provider by publisher.


        :return: The pricing_plans of this CreateOciListingRevisionDetails.
        :rtype: list[oci.marketplace_publisher.models.PricingPlan]
        """
        return self._pricing_plans

    @pricing_plans.setter
    def pricing_plans(self, pricing_plans):
        """
        Sets the pricing_plans of this CreateOciListingRevisionDetails.
        List of Pricing Plans provider by publisher.


        :param pricing_plans: The pricing_plans of this CreateOciListingRevisionDetails.
        :type: list[oci.marketplace_publisher.models.PricingPlan]
        """
        self._pricing_plans = pricing_plans

    @property
    def vanity_url(self):
        """
        Gets the vanity_url of this CreateOciListingRevisionDetails.
        Custom link to the listing


        :return: The vanity_url of this CreateOciListingRevisionDetails.
        :rtype: str
        """
        return self._vanity_url

    @vanity_url.setter
    def vanity_url(self, vanity_url):
        """
        Sets the vanity_url of this CreateOciListingRevisionDetails.
        Custom link to the listing


        :param vanity_url: The vanity_url of this CreateOciListingRevisionDetails.
        :type: str
        """
        self._vanity_url = vanity_url

    @property
    def recommended_service_provider_listing_ids(self):
        """
        Gets the recommended_service_provider_listing_ids of this CreateOciListingRevisionDetails.
        OCIDs of service listings attached to lead gen listing


        :return: The recommended_service_provider_listing_ids of this CreateOciListingRevisionDetails.
        :rtype: list[str]
        """
        return self._recommended_service_provider_listing_ids

    @recommended_service_provider_listing_ids.setter
    def recommended_service_provider_listing_ids(self, recommended_service_provider_listing_ids):
        """
        Sets the recommended_service_provider_listing_ids of this CreateOciListingRevisionDetails.
        OCIDs of service listings attached to lead gen listing


        :param recommended_service_provider_listing_ids: The recommended_service_provider_listing_ids of this CreateOciListingRevisionDetails.
        :type: list[str]
        """
        self._recommended_service_provider_listing_ids = recommended_service_provider_listing_ids

    @property
    def availability_and_pricing_policy(self):
        """
        Gets the availability_and_pricing_policy of this CreateOciListingRevisionDetails.
        Listing availability and Pricing Policy statement.


        :return: The availability_and_pricing_policy of this CreateOciListingRevisionDetails.
        :rtype: str
        """
        return self._availability_and_pricing_policy

    @availability_and_pricing_policy.setter
    def availability_and_pricing_policy(self, availability_and_pricing_policy):
        """
        Sets the availability_and_pricing_policy of this CreateOciListingRevisionDetails.
        Listing availability and Pricing Policy statement.


        :param availability_and_pricing_policy: The availability_and_pricing_policy of this CreateOciListingRevisionDetails.
        :type: str
        """
        self._availability_and_pricing_policy = availability_and_pricing_policy

    @property
    def is_rover_exportable(self):
        """
        Gets the is_rover_exportable of this CreateOciListingRevisionDetails.
        Is this listing rover exportable


        :return: The is_rover_exportable of this CreateOciListingRevisionDetails.
        :rtype: bool
        """
        return self._is_rover_exportable

    @is_rover_exportable.setter
    def is_rover_exportable(self, is_rover_exportable):
        """
        Sets the is_rover_exportable of this CreateOciListingRevisionDetails.
        Is this listing rover exportable


        :param is_rover_exportable: The is_rover_exportable of this CreateOciListingRevisionDetails.
        :type: bool
        """
        self._is_rover_exportable = is_rover_exportable

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
