# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201

from .create_listing_revision_details import CreateListingRevisionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateServiceListingRevisionDetails(CreateListingRevisionDetails):
    """
    Listing revision update details for listings
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateServiceListingRevisionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.marketplace_publisher.models.CreateServiceListingRevisionDetails.listing_type` attribute
        of this class is ``SERVICE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateServiceListingRevisionDetails.
        :type display_name: str

        :param listing_id:
            The value to assign to the listing_id property of this CreateServiceListingRevisionDetails.
        :type listing_id: str

        :param listing_type:
            The value to assign to the listing_type property of this CreateServiceListingRevisionDetails.
            Allowed values for this property are: "OCI_APPLICATION", "LEAD_GENERATION", "SERVICE"
        :type listing_type: str

        :param headline:
            The value to assign to the headline property of this CreateServiceListingRevisionDetails.
        :type headline: str

        :param tagline:
            The value to assign to the tagline property of this CreateServiceListingRevisionDetails.
        :type tagline: str

        :param keywords:
            The value to assign to the keywords property of this CreateServiceListingRevisionDetails.
        :type keywords: str

        :param short_description:
            The value to assign to the short_description property of this CreateServiceListingRevisionDetails.
        :type short_description: str

        :param usage_information:
            The value to assign to the usage_information property of this CreateServiceListingRevisionDetails.
        :type usage_information: str

        :param long_description:
            The value to assign to the long_description property of this CreateServiceListingRevisionDetails.
        :type long_description: str

        :param content_language:
            The value to assign to the content_language property of this CreateServiceListingRevisionDetails.
        :type content_language: oci.marketplace_publisher.models.LanguageItem

        :param supportedlanguages:
            The value to assign to the supportedlanguages property of this CreateServiceListingRevisionDetails.
        :type supportedlanguages: list[oci.marketplace_publisher.models.LanguageItem]

        :param support_contacts:
            The value to assign to the support_contacts property of this CreateServiceListingRevisionDetails.
        :type support_contacts: list[oci.marketplace_publisher.models.SupportContact]

        :param support_links:
            The value to assign to the support_links property of this CreateServiceListingRevisionDetails.
        :type support_links: list[oci.marketplace_publisher.models.NamedLink]

        :param status:
            The value to assign to the status property of this CreateServiceListingRevisionDetails.
        :type status: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateServiceListingRevisionDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateServiceListingRevisionDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param contact_us:
            The value to assign to the contact_us property of this CreateServiceListingRevisionDetails.
        :type contact_us: str

        :param product_codes:
            The value to assign to the product_codes property of this CreateServiceListingRevisionDetails.
        :type product_codes: list[str]

        :param industries:
            The value to assign to the industries property of this CreateServiceListingRevisionDetails.
        :type industries: list[str]

        :param trained_professionals:
            The value to assign to the trained_professionals property of this CreateServiceListingRevisionDetails.
        :type trained_professionals: list[oci.marketplace_publisher.models.TrainedProfessionals]

        :param vanity_url:
            The value to assign to the vanity_url property of this CreateServiceListingRevisionDetails.
        :type vanity_url: str

        :param geo_locations:
            The value to assign to the geo_locations property of this CreateServiceListingRevisionDetails.
        :type geo_locations: list[oci.marketplace_publisher.models.GeoLocation]

        """
        self.swagger_types = {
            'display_name': 'str',
            'listing_id': 'str',
            'listing_type': 'str',
            'headline': 'str',
            'tagline': 'str',
            'keywords': 'str',
            'short_description': 'str',
            'usage_information': 'str',
            'long_description': 'str',
            'content_language': 'LanguageItem',
            'supportedlanguages': 'list[LanguageItem]',
            'support_contacts': 'list[SupportContact]',
            'support_links': 'list[NamedLink]',
            'status': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'contact_us': 'str',
            'product_codes': 'list[str]',
            'industries': 'list[str]',
            'trained_professionals': 'list[TrainedProfessionals]',
            'vanity_url': 'str',
            'geo_locations': 'list[GeoLocation]'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'listing_id': 'listingId',
            'listing_type': 'listingType',
            'headline': 'headline',
            'tagline': 'tagline',
            'keywords': 'keywords',
            'short_description': 'shortDescription',
            'usage_information': 'usageInformation',
            'long_description': 'longDescription',
            'content_language': 'contentLanguage',
            'supportedlanguages': 'supportedlanguages',
            'support_contacts': 'supportContacts',
            'support_links': 'supportLinks',
            'status': 'status',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'contact_us': 'contactUs',
            'product_codes': 'productCodes',
            'industries': 'industries',
            'trained_professionals': 'trainedProfessionals',
            'vanity_url': 'vanityUrl',
            'geo_locations': 'geoLocations'
        }
        self._display_name = None
        self._listing_id = None
        self._listing_type = None
        self._headline = None
        self._tagline = None
        self._keywords = None
        self._short_description = None
        self._usage_information = None
        self._long_description = None
        self._content_language = None
        self._supportedlanguages = None
        self._support_contacts = None
        self._support_links = None
        self._status = None
        self._freeform_tags = None
        self._defined_tags = None
        self._contact_us = None
        self._product_codes = None
        self._industries = None
        self._trained_professionals = None
        self._vanity_url = None
        self._geo_locations = None
        self._listing_type = 'SERVICE'

    @property
    def contact_us(self):
        """
        Gets the contact_us of this CreateServiceListingRevisionDetails.
        Custom text by partner regarding contact information


        :return: The contact_us of this CreateServiceListingRevisionDetails.
        :rtype: str
        """
        return self._contact_us

    @contact_us.setter
    def contact_us(self, contact_us):
        """
        Sets the contact_us of this CreateServiceListingRevisionDetails.
        Custom text by partner regarding contact information


        :param contact_us: The contact_us of this CreateServiceListingRevisionDetails.
        :type: str
        """
        self._contact_us = contact_us

    @property
    def product_codes(self):
        """
        **[Required]** Gets the product_codes of this CreateServiceListingRevisionDetails.
        List of product codes subscribed by listing.


        :return: The product_codes of this CreateServiceListingRevisionDetails.
        :rtype: list[str]
        """
        return self._product_codes

    @product_codes.setter
    def product_codes(self, product_codes):
        """
        Sets the product_codes of this CreateServiceListingRevisionDetails.
        List of product codes subscribed by listing.


        :param product_codes: The product_codes of this CreateServiceListingRevisionDetails.
        :type: list[str]
        """
        self._product_codes = product_codes

    @property
    def industries(self):
        """
        **[Required]** Gets the industries of this CreateServiceListingRevisionDetails.
        List of industries subscribed by listing.


        :return: The industries of this CreateServiceListingRevisionDetails.
        :rtype: list[str]
        """
        return self._industries

    @industries.setter
    def industries(self, industries):
        """
        Sets the industries of this CreateServiceListingRevisionDetails.
        List of industries subscribed by listing.


        :param industries: The industries of this CreateServiceListingRevisionDetails.
        :type: list[str]
        """
        self._industries = industries

    @property
    def trained_professionals(self):
        """
        Gets the trained_professionals of this CreateServiceListingRevisionDetails.
        Number of trained professional per product


        :return: The trained_professionals of this CreateServiceListingRevisionDetails.
        :rtype: list[oci.marketplace_publisher.models.TrainedProfessionals]
        """
        return self._trained_professionals

    @trained_professionals.setter
    def trained_professionals(self, trained_professionals):
        """
        Sets the trained_professionals of this CreateServiceListingRevisionDetails.
        Number of trained professional per product


        :param trained_professionals: The trained_professionals of this CreateServiceListingRevisionDetails.
        :type: list[oci.marketplace_publisher.models.TrainedProfessionals]
        """
        self._trained_professionals = trained_professionals

    @property
    def vanity_url(self):
        """
        Gets the vanity_url of this CreateServiceListingRevisionDetails.
        Custom link to the listing


        :return: The vanity_url of this CreateServiceListingRevisionDetails.
        :rtype: str
        """
        return self._vanity_url

    @vanity_url.setter
    def vanity_url(self, vanity_url):
        """
        Sets the vanity_url of this CreateServiceListingRevisionDetails.
        Custom link to the listing


        :param vanity_url: The vanity_url of this CreateServiceListingRevisionDetails.
        :type: str
        """
        self._vanity_url = vanity_url

    @property
    def geo_locations(self):
        """
        Gets the geo_locations of this CreateServiceListingRevisionDetails.
        Support details based on geographic location


        :return: The geo_locations of this CreateServiceListingRevisionDetails.
        :rtype: list[oci.marketplace_publisher.models.GeoLocation]
        """
        return self._geo_locations

    @geo_locations.setter
    def geo_locations(self, geo_locations):
        """
        Sets the geo_locations of this CreateServiceListingRevisionDetails.
        Support details based on geographic location


        :param geo_locations: The geo_locations of this CreateServiceListingRevisionDetails.
        :type: list[oci.marketplace_publisher.models.GeoLocation]
        """
        self._geo_locations = geo_locations

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
