# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201

from .listing_revision_attachment import ListingRevisionAttachment
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CustomerSuccessAttachment(ListingRevisionAttachment):
    """
    Customer success story attachment for the service listing revision.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CustomerSuccessAttachment object with values from keyword arguments. The default value of the :py:attr:`~oci.marketplace_publisher.models.CustomerSuccessAttachment.attachment_type` attribute
        of this class is ``CUSTOMER_SUCCESS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CustomerSuccessAttachment.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CustomerSuccessAttachment.
        :type compartment_id: str

        :param listing_revision_id:
            The value to assign to the listing_revision_id property of this CustomerSuccessAttachment.
        :type listing_revision_id: str

        :param display_name:
            The value to assign to the display_name property of this CustomerSuccessAttachment.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CustomerSuccessAttachment.
        :type description: str

        :param attachment_type:
            The value to assign to the attachment_type property of this CustomerSuccessAttachment.
            Allowed values for this property are: "RELATED_DOCUMENT", "SCREENSHOT", "VIDEO", "REVIEW_SUPPORT_DOCUMENT", "CUSTOMER_SUCCESS", "SUPPORTED_SERVICES"
        :type attachment_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this CustomerSuccessAttachment.
            Allowed values for this property are: "ACTIVE", "INACTIVE", "DELETED"
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this CustomerSuccessAttachment.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this CustomerSuccessAttachment.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CustomerSuccessAttachment.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CustomerSuccessAttachment.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this CustomerSuccessAttachment.
        :type system_tags: dict(str, dict(str, object))

        :param customer_name:
            The value to assign to the customer_name property of this CustomerSuccessAttachment.
        :type customer_name: str

        :param url:
            The value to assign to the url property of this CustomerSuccessAttachment.
        :type url: str

        :param product_codes:
            The value to assign to the product_codes property of this CustomerSuccessAttachment.
        :type product_codes: list[str]

        :param content_url:
            The value to assign to the content_url property of this CustomerSuccessAttachment.
        :type content_url: str

        :param mime_type:
            The value to assign to the mime_type property of this CustomerSuccessAttachment.
        :type mime_type: str

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'listing_revision_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'attachment_type': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'customer_name': 'str',
            'url': 'str',
            'product_codes': 'list[str]',
            'content_url': 'str',
            'mime_type': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'listing_revision_id': 'listingRevisionId',
            'display_name': 'displayName',
            'description': 'description',
            'attachment_type': 'attachmentType',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'customer_name': 'customerName',
            'url': 'url',
            'product_codes': 'productCodes',
            'content_url': 'contentUrl',
            'mime_type': 'mimeType'
        }
        self._id = None
        self._compartment_id = None
        self._listing_revision_id = None
        self._display_name = None
        self._description = None
        self._attachment_type = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._customer_name = None
        self._url = None
        self._product_codes = None
        self._content_url = None
        self._mime_type = None
        self._attachment_type = 'CUSTOMER_SUCCESS'

    @property
    def customer_name(self):
        """
        **[Required]** Gets the customer_name of this CustomerSuccessAttachment.
        Name of the customer


        :return: The customer_name of this CustomerSuccessAttachment.
        :rtype: str
        """
        return self._customer_name

    @customer_name.setter
    def customer_name(self, customer_name):
        """
        Sets the customer_name of this CustomerSuccessAttachment.
        Name of the customer


        :param customer_name: The customer_name of this CustomerSuccessAttachment.
        :type: str
        """
        self._customer_name = customer_name

    @property
    def url(self):
        """
        Gets the url of this CustomerSuccessAttachment.
        Optional url to success story


        :return: The url of this CustomerSuccessAttachment.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this CustomerSuccessAttachment.
        Optional url to success story


        :param url: The url of this CustomerSuccessAttachment.
        :type: str
        """
        self._url = url

    @property
    def product_codes(self):
        """
        Gets the product_codes of this CustomerSuccessAttachment.
        List of product codes for customer story


        :return: The product_codes of this CustomerSuccessAttachment.
        :rtype: list[str]
        """
        return self._product_codes

    @product_codes.setter
    def product_codes(self, product_codes):
        """
        Sets the product_codes of this CustomerSuccessAttachment.
        List of product codes for customer story


        :param product_codes: The product_codes of this CustomerSuccessAttachment.
        :type: list[str]
        """
        self._product_codes = product_codes

    @property
    def content_url(self):
        """
        Gets the content_url of this CustomerSuccessAttachment.
        URL of the uploaded document.


        :return: The content_url of this CustomerSuccessAttachment.
        :rtype: str
        """
        return self._content_url

    @content_url.setter
    def content_url(self, content_url):
        """
        Sets the content_url of this CustomerSuccessAttachment.
        URL of the uploaded document.


        :param content_url: The content_url of this CustomerSuccessAttachment.
        :type: str
        """
        self._content_url = content_url

    @property
    def mime_type(self):
        """
        Gets the mime_type of this CustomerSuccessAttachment.
        The MIME type of the uploaded data.


        :return: The mime_type of this CustomerSuccessAttachment.
        :rtype: str
        """
        return self._mime_type

    @mime_type.setter
    def mime_type(self, mime_type):
        """
        Sets the mime_type of this CustomerSuccessAttachment.
        The MIME type of the uploaded data.


        :param mime_type: The mime_type of this CustomerSuccessAttachment.
        :type: str
        """
        self._mime_type = mime_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
