# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GeoLocation(object):
    """
    Support details based on geographic location
    """

    #: A constant which can be used with the geographic_region property of a GeoLocation.
    #: This constant has a value of "AFRICA"
    GEOGRAPHIC_REGION_AFRICA = "AFRICA"

    #: A constant which can be used with the geographic_region property of a GeoLocation.
    #: This constant has a value of "ASIA_PACIFIC"
    GEOGRAPHIC_REGION_ASIA_PACIFIC = "ASIA_PACIFIC"

    #: A constant which can be used with the geographic_region property of a GeoLocation.
    #: This constant has a value of "EUROPE"
    GEOGRAPHIC_REGION_EUROPE = "EUROPE"

    #: A constant which can be used with the geographic_region property of a GeoLocation.
    #: This constant has a value of "JAPAN"
    GEOGRAPHIC_REGION_JAPAN = "JAPAN"

    #: A constant which can be used with the geographic_region property of a GeoLocation.
    #: This constant has a value of "LATIN_AMERICA"
    GEOGRAPHIC_REGION_LATIN_AMERICA = "LATIN_AMERICA"

    #: A constant which can be used with the geographic_region property of a GeoLocation.
    #: This constant has a value of "MIDDLE_EAST"
    GEOGRAPHIC_REGION_MIDDLE_EAST = "MIDDLE_EAST"

    #: A constant which can be used with the geographic_region property of a GeoLocation.
    #: This constant has a value of "NORTH_AMERICA"
    GEOGRAPHIC_REGION_NORTH_AMERICA = "NORTH_AMERICA"

    def __init__(self, **kwargs):
        """
        Initializes a new GeoLocation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param geographic_region:
            The value to assign to the geographic_region property of this GeoLocation.
            Allowed values for this property are: "AFRICA", "ASIA_PACIFIC", "EUROPE", "JAPAN", "LATIN_AMERICA", "MIDDLE_EAST", "NORTH_AMERICA", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type geographic_region: str

        :param details:
            The value to assign to the details property of this GeoLocation.
        :type details: str

        """
        self.swagger_types = {
            'geographic_region': 'str',
            'details': 'str'
        }
        self.attribute_map = {
            'geographic_region': 'geographicRegion',
            'details': 'details'
        }
        self._geographic_region = None
        self._details = None

    @property
    def geographic_region(self):
        """
        **[Required]** Gets the geographic_region of this GeoLocation.
        Region for geographic location

        Allowed values for this property are: "AFRICA", "ASIA_PACIFIC", "EUROPE", "JAPAN", "LATIN_AMERICA", "MIDDLE_EAST", "NORTH_AMERICA", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The geographic_region of this GeoLocation.
        :rtype: str
        """
        return self._geographic_region

    @geographic_region.setter
    def geographic_region(self, geographic_region):
        """
        Sets the geographic_region of this GeoLocation.
        Region for geographic location


        :param geographic_region: The geographic_region of this GeoLocation.
        :type: str
        """
        allowed_values = ["AFRICA", "ASIA_PACIFIC", "EUROPE", "JAPAN", "LATIN_AMERICA", "MIDDLE_EAST", "NORTH_AMERICA"]
        if not value_allowed_none_or_none_sentinel(geographic_region, allowed_values):
            geographic_region = 'UNKNOWN_ENUM_VALUE'
        self._geographic_region = geographic_region

    @property
    def details(self):
        """
        **[Required]** Gets the details of this GeoLocation.
        Support details for specific region


        :return: The details of this GeoLocation.
        :rtype: str
        """
        return self._details

    @details.setter
    def details(self, details):
        """
        Sets the details of this GeoLocation.
        Support details for specific region


        :param details: The details of this GeoLocation.
        :type: str
        """
        self._details = details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
