# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LeadSummary(object):
    """
    A placeholder for list of leads
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LeadSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this LeadSummary.
        :type id: str

        :param listing_id:
            The value to assign to the listing_id property of this LeadSummary.
        :type listing_id: str

        :param listing_name:
            The value to assign to the listing_name property of this LeadSummary.
        :type listing_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this LeadSummary.
        :type compartment_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this LeadSummary.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this LeadSummary.
        :type time_created: datetime

        :param additional_info:
            The value to assign to the additional_info property of this LeadSummary.
        :type additional_info: oci.marketplace_publisher.models.AdditionalInfo

        :param system_tags:
            The value to assign to the system_tags property of this LeadSummary.
        :type system_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this LeadSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this LeadSummary.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'listing_id': 'str',
            'listing_name': 'str',
            'compartment_id': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'additional_info': 'AdditionalInfo',
            'system_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'listing_id': 'listingId',
            'listing_name': 'listingName',
            'compartment_id': 'compartmentId',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'additional_info': 'additionalInfo',
            'system_tags': 'systemTags',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._id = None
        self._listing_id = None
        self._listing_name = None
        self._compartment_id = None
        self._lifecycle_state = None
        self._time_created = None
        self._additional_info = None
        self._system_tags = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        Gets the id of this LeadSummary.
        Unique OCID identifier for the listing.


        :return: The id of this LeadSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this LeadSummary.
        Unique OCID identifier for the listing.


        :param id: The id of this LeadSummary.
        :type: str
        """
        self._id = id

    @property
    def listing_id(self):
        """
        Gets the listing_id of this LeadSummary.
        The unique identifier for the listing.


        :return: The listing_id of this LeadSummary.
        :rtype: str
        """
        return self._listing_id

    @listing_id.setter
    def listing_id(self, listing_id):
        """
        Sets the listing_id of this LeadSummary.
        The unique identifier for the listing.


        :param listing_id: The listing_id of this LeadSummary.
        :type: str
        """
        self._listing_id = listing_id

    @property
    def listing_name(self):
        """
        Gets the listing_name of this LeadSummary.
        The name of the listing.


        :return: The listing_name of this LeadSummary.
        :rtype: str
        """
        return self._listing_name

    @listing_name.setter
    def listing_name(self, listing_name):
        """
        Sets the listing_name of this LeadSummary.
        The name of the listing.


        :param listing_name: The listing_name of this LeadSummary.
        :type: str
        """
        self._listing_name = listing_name

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this LeadSummary.
        The unique identifier for the compartment.


        :return: The compartment_id of this LeadSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this LeadSummary.
        The unique identifier for the compartment.


        :param compartment_id: The compartment_id of this LeadSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this LeadSummary.
        The state for the listing.


        :return: The lifecycle_state of this LeadSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this LeadSummary.
        The state for the listing.


        :param lifecycle_state: The lifecycle_state of this LeadSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        Gets the time_created of this LeadSummary.
        The date and time the listing was created, in the format defined by `RFC3339`__.

        Example: `2023-03-27T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this LeadSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this LeadSummary.
        The date and time the listing was created, in the format defined by `RFC3339`__.

        Example: `2023-03-27T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this LeadSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def additional_info(self):
        """
        Gets the additional_info of this LeadSummary.

        :return: The additional_info of this LeadSummary.
        :rtype: oci.marketplace_publisher.models.AdditionalInfo
        """
        return self._additional_info

    @additional_info.setter
    def additional_info(self, additional_info):
        """
        Sets the additional_info of this LeadSummary.

        :param additional_info: The additional_info of this LeadSummary.
        :type: oci.marketplace_publisher.models.AdditionalInfo
        """
        self._additional_info = additional_info

    @property
    def system_tags(self):
        """
        Gets the system_tags of this LeadSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this LeadSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this LeadSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this LeadSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this LeadSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this LeadSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this LeadSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this LeadSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this LeadSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this LeadSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this LeadSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this LeadSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
