# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201

from .listing_revision import ListingRevision
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ServiceListingRevision(ListingRevision):
    """
    Listing revision details for service listings
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ServiceListingRevision object with values from keyword arguments. The default value of the :py:attr:`~oci.marketplace_publisher.models.ServiceListingRevision.listing_type` attribute
        of this class is ``SERVICE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ServiceListingRevision.
        :type id: str

        :param listing_id:
            The value to assign to the listing_id property of this ServiceListingRevision.
        :type listing_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ServiceListingRevision.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this ServiceListingRevision.
        :type display_name: str

        :param revision_number:
            The value to assign to the revision_number property of this ServiceListingRevision.
        :type revision_number: str

        :param headline:
            The value to assign to the headline property of this ServiceListingRevision.
        :type headline: str

        :param tagline:
            The value to assign to the tagline property of this ServiceListingRevision.
        :type tagline: str

        :param keywords:
            The value to assign to the keywords property of this ServiceListingRevision.
        :type keywords: str

        :param short_description:
            The value to assign to the short_description property of this ServiceListingRevision.
        :type short_description: str

        :param usage_information:
            The value to assign to the usage_information property of this ServiceListingRevision.
        :type usage_information: str

        :param long_description:
            The value to assign to the long_description property of this ServiceListingRevision.
        :type long_description: str

        :param time_created:
            The value to assign to the time_created property of this ServiceListingRevision.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ServiceListingRevision.
        :type time_updated: datetime

        :param content_language:
            The value to assign to the content_language property of this ServiceListingRevision.
        :type content_language: oci.marketplace_publisher.models.LanguageItem

        :param supportedlanguages:
            The value to assign to the supportedlanguages property of this ServiceListingRevision.
        :type supportedlanguages: list[oci.marketplace_publisher.models.LanguageItem]

        :param support_contacts:
            The value to assign to the support_contacts property of this ServiceListingRevision.
        :type support_contacts: list[oci.marketplace_publisher.models.SupportContact]

        :param support_links:
            The value to assign to the support_links property of this ServiceListingRevision.
        :type support_links: list[oci.marketplace_publisher.models.NamedLink]

        :param icon:
            The value to assign to the icon property of this ServiceListingRevision.
        :type icon: oci.marketplace_publisher.models.ListingRevisionIconAttachment

        :param status:
            The value to assign to the status property of this ServiceListingRevision.
            Allowed values for this property are: "NEW", "PENDING_REVIEW", "REVIEW_IN_PROGRESS", "REJECTED", "APPROVED", "PUBLISH_IN_PROGRESS", "PUBLISH_FAILED", "PUBLISHED", "PUBLISH_AS_PRIVATE_FAILED", "PUBLISHED_AS_PRIVATE", "PUBLISH_AS_PRIVATE_IN_PROGRESS", "UNPUBLISH_IN_PROGRESS", "UNPUBLISHED"
        :type status: str

        :param status_notes:
            The value to assign to the status_notes property of this ServiceListingRevision.
        :type status_notes: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ServiceListingRevision.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"
        :type lifecycle_state: str

        :param package_type:
            The value to assign to the package_type property of this ServiceListingRevision.
            Allowed values for this property are: "CONTAINER_IMAGE", "HELM_CHART", "MACHINE_IMAGE", "STACK", "NONE"
        :type package_type: str

        :param listing_type:
            The value to assign to the listing_type property of this ServiceListingRevision.
            Allowed values for this property are: "OCI_APPLICATION", "LEAD_GENERATION", "SERVICE"
        :type listing_type: str

        :param extended_metadata:
            The value to assign to the extended_metadata property of this ServiceListingRevision.
        :type extended_metadata: dict(str, str)

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ServiceListingRevision.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ServiceListingRevision.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ServiceListingRevision.
        :type system_tags: dict(str, dict(str, object))

        :param contact_us:
            The value to assign to the contact_us property of this ServiceListingRevision.
        :type contact_us: str

        :param product_codes:
            The value to assign to the product_codes property of this ServiceListingRevision.
        :type product_codes: list[str]

        :param industries:
            The value to assign to the industries property of this ServiceListingRevision.
        :type industries: list[str]

        :param trained_professionals:
            The value to assign to the trained_professionals property of this ServiceListingRevision.
        :type trained_professionals: list[oci.marketplace_publisher.models.TrainedProfessionals]

        :param vanity_url:
            The value to assign to the vanity_url property of this ServiceListingRevision.
        :type vanity_url: str

        :param geo_locations:
            The value to assign to the geo_locations property of this ServiceListingRevision.
        :type geo_locations: list[oci.marketplace_publisher.models.GeoLocation]

        """
        self.swagger_types = {
            'id': 'str',
            'listing_id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'revision_number': 'str',
            'headline': 'str',
            'tagline': 'str',
            'keywords': 'str',
            'short_description': 'str',
            'usage_information': 'str',
            'long_description': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'content_language': 'LanguageItem',
            'supportedlanguages': 'list[LanguageItem]',
            'support_contacts': 'list[SupportContact]',
            'support_links': 'list[NamedLink]',
            'icon': 'ListingRevisionIconAttachment',
            'status': 'str',
            'status_notes': 'str',
            'lifecycle_state': 'str',
            'package_type': 'str',
            'listing_type': 'str',
            'extended_metadata': 'dict(str, str)',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'contact_us': 'str',
            'product_codes': 'list[str]',
            'industries': 'list[str]',
            'trained_professionals': 'list[TrainedProfessionals]',
            'vanity_url': 'str',
            'geo_locations': 'list[GeoLocation]'
        }
        self.attribute_map = {
            'id': 'id',
            'listing_id': 'listingId',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'revision_number': 'revisionNumber',
            'headline': 'headline',
            'tagline': 'tagline',
            'keywords': 'keywords',
            'short_description': 'shortDescription',
            'usage_information': 'usageInformation',
            'long_description': 'longDescription',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'content_language': 'contentLanguage',
            'supportedlanguages': 'supportedlanguages',
            'support_contacts': 'supportContacts',
            'support_links': 'supportLinks',
            'icon': 'icon',
            'status': 'status',
            'status_notes': 'statusNotes',
            'lifecycle_state': 'lifecycleState',
            'package_type': 'packageType',
            'listing_type': 'listingType',
            'extended_metadata': 'extendedMetadata',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'contact_us': 'contactUs',
            'product_codes': 'productCodes',
            'industries': 'industries',
            'trained_professionals': 'trainedProfessionals',
            'vanity_url': 'vanityUrl',
            'geo_locations': 'geoLocations'
        }
        self._id = None
        self._listing_id = None
        self._compartment_id = None
        self._display_name = None
        self._revision_number = None
        self._headline = None
        self._tagline = None
        self._keywords = None
        self._short_description = None
        self._usage_information = None
        self._long_description = None
        self._time_created = None
        self._time_updated = None
        self._content_language = None
        self._supportedlanguages = None
        self._support_contacts = None
        self._support_links = None
        self._icon = None
        self._status = None
        self._status_notes = None
        self._lifecycle_state = None
        self._package_type = None
        self._listing_type = None
        self._extended_metadata = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._contact_us = None
        self._product_codes = None
        self._industries = None
        self._trained_professionals = None
        self._vanity_url = None
        self._geo_locations = None
        self._listing_type = 'SERVICE'

    @property
    def contact_us(self):
        """
        Gets the contact_us of this ServiceListingRevision.
        Custom text by partner regarding contact information


        :return: The contact_us of this ServiceListingRevision.
        :rtype: str
        """
        return self._contact_us

    @contact_us.setter
    def contact_us(self, contact_us):
        """
        Sets the contact_us of this ServiceListingRevision.
        Custom text by partner regarding contact information


        :param contact_us: The contact_us of this ServiceListingRevision.
        :type: str
        """
        self._contact_us = contact_us

    @property
    def product_codes(self):
        """
        **[Required]** Gets the product_codes of this ServiceListingRevision.
        List of product codes subscribed by listing.


        :return: The product_codes of this ServiceListingRevision.
        :rtype: list[str]
        """
        return self._product_codes

    @product_codes.setter
    def product_codes(self, product_codes):
        """
        Sets the product_codes of this ServiceListingRevision.
        List of product codes subscribed by listing.


        :param product_codes: The product_codes of this ServiceListingRevision.
        :type: list[str]
        """
        self._product_codes = product_codes

    @property
    def industries(self):
        """
        **[Required]** Gets the industries of this ServiceListingRevision.
        List of industries subscribed by listing.


        :return: The industries of this ServiceListingRevision.
        :rtype: list[str]
        """
        return self._industries

    @industries.setter
    def industries(self, industries):
        """
        Sets the industries of this ServiceListingRevision.
        List of industries subscribed by listing.


        :param industries: The industries of this ServiceListingRevision.
        :type: list[str]
        """
        self._industries = industries

    @property
    def trained_professionals(self):
        """
        Gets the trained_professionals of this ServiceListingRevision.
        Number of trained professional per product


        :return: The trained_professionals of this ServiceListingRevision.
        :rtype: list[oci.marketplace_publisher.models.TrainedProfessionals]
        """
        return self._trained_professionals

    @trained_professionals.setter
    def trained_professionals(self, trained_professionals):
        """
        Sets the trained_professionals of this ServiceListingRevision.
        Number of trained professional per product


        :param trained_professionals: The trained_professionals of this ServiceListingRevision.
        :type: list[oci.marketplace_publisher.models.TrainedProfessionals]
        """
        self._trained_professionals = trained_professionals

    @property
    def vanity_url(self):
        """
        Gets the vanity_url of this ServiceListingRevision.
        Custom link to the listing


        :return: The vanity_url of this ServiceListingRevision.
        :rtype: str
        """
        return self._vanity_url

    @vanity_url.setter
    def vanity_url(self, vanity_url):
        """
        Sets the vanity_url of this ServiceListingRevision.
        Custom link to the listing


        :param vanity_url: The vanity_url of this ServiceListingRevision.
        :type: str
        """
        self._vanity_url = vanity_url

    @property
    def geo_locations(self):
        """
        Gets the geo_locations of this ServiceListingRevision.
        Support details based on geographic location


        :return: The geo_locations of this ServiceListingRevision.
        :rtype: list[oci.marketplace_publisher.models.GeoLocation]
        """
        return self._geo_locations

    @geo_locations.setter
    def geo_locations(self, geo_locations):
        """
        Sets the geo_locations of this ServiceListingRevision.
        Support details based on geographic location


        :param geo_locations: The geo_locations of this ServiceListingRevision.
        :type: list[oci.marketplace_publisher.models.GeoLocation]
        """
        self._geo_locations = geo_locations

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
