# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201

from .listing_revision_attachment import ListingRevisionAttachment
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SupportedServiceAttachment(ListingRevisionAttachment):
    """
    Supported services attachment for the service listing revision.
    """

    #: A constant which can be used with the type property of a SupportedServiceAttachment.
    #: This constant has a value of "IMPLEMENTATION_SERVICE"
    TYPE_IMPLEMENTATION_SERVICE = "IMPLEMENTATION_SERVICE"

    #: A constant which can be used with the type property of a SupportedServiceAttachment.
    #: This constant has a value of "CONSULTING_SERVICE"
    TYPE_CONSULTING_SERVICE = "CONSULTING_SERVICE"

    #: A constant which can be used with the type property of a SupportedServiceAttachment.
    #: This constant has a value of "APP_DEVELOPMENT_SERVICE"
    TYPE_APP_DEVELOPMENT_SERVICE = "APP_DEVELOPMENT_SERVICE"

    #: A constant which can be used with the type property of a SupportedServiceAttachment.
    #: This constant has a value of "MANAGED_SERVICE"
    TYPE_MANAGED_SERVICE = "MANAGED_SERVICE"

    #: A constant which can be used with the type property of a SupportedServiceAttachment.
    #: This constant has a value of "OTHER"
    TYPE_OTHER = "OTHER"

    def __init__(self, **kwargs):
        """
        Initializes a new SupportedServiceAttachment object with values from keyword arguments. The default value of the :py:attr:`~oci.marketplace_publisher.models.SupportedServiceAttachment.attachment_type` attribute
        of this class is ``SUPPORTED_SERVICES`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this SupportedServiceAttachment.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this SupportedServiceAttachment.
        :type compartment_id: str

        :param listing_revision_id:
            The value to assign to the listing_revision_id property of this SupportedServiceAttachment.
        :type listing_revision_id: str

        :param display_name:
            The value to assign to the display_name property of this SupportedServiceAttachment.
        :type display_name: str

        :param description:
            The value to assign to the description property of this SupportedServiceAttachment.
        :type description: str

        :param attachment_type:
            The value to assign to the attachment_type property of this SupportedServiceAttachment.
            Allowed values for this property are: "RELATED_DOCUMENT", "SCREENSHOT", "VIDEO", "REVIEW_SUPPORT_DOCUMENT", "CUSTOMER_SUCCESS", "SUPPORTED_SERVICES", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type attachment_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this SupportedServiceAttachment.
            Allowed values for this property are: "ACTIVE", "INACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this SupportedServiceAttachment.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this SupportedServiceAttachment.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this SupportedServiceAttachment.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this SupportedServiceAttachment.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this SupportedServiceAttachment.
        :type system_tags: dict(str, dict(str, object))

        :param service_name:
            The value to assign to the service_name property of this SupportedServiceAttachment.
        :type service_name: str

        :param url:
            The value to assign to the url property of this SupportedServiceAttachment.
        :type url: str

        :param type:
            The value to assign to the type property of this SupportedServiceAttachment.
            Allowed values for this property are: "IMPLEMENTATION_SERVICE", "CONSULTING_SERVICE", "APP_DEVELOPMENT_SERVICE", "MANAGED_SERVICE", "OTHER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param content_url:
            The value to assign to the content_url property of this SupportedServiceAttachment.
        :type content_url: str

        :param mime_type:
            The value to assign to the mime_type property of this SupportedServiceAttachment.
        :type mime_type: str

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'listing_revision_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'attachment_type': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'service_name': 'str',
            'url': 'str',
            'type': 'str',
            'content_url': 'str',
            'mime_type': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'listing_revision_id': 'listingRevisionId',
            'display_name': 'displayName',
            'description': 'description',
            'attachment_type': 'attachmentType',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'service_name': 'serviceName',
            'url': 'url',
            'type': 'type',
            'content_url': 'contentUrl',
            'mime_type': 'mimeType'
        }
        self._id = None
        self._compartment_id = None
        self._listing_revision_id = None
        self._display_name = None
        self._description = None
        self._attachment_type = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._service_name = None
        self._url = None
        self._type = None
        self._content_url = None
        self._mime_type = None
        self._attachment_type = 'SUPPORTED_SERVICES'

    @property
    def service_name(self):
        """
        **[Required]** Gets the service_name of this SupportedServiceAttachment.
        Name of the service


        :return: The service_name of this SupportedServiceAttachment.
        :rtype: str
        """
        return self._service_name

    @service_name.setter
    def service_name(self, service_name):
        """
        Sets the service_name of this SupportedServiceAttachment.
        Name of the service


        :param service_name: The service_name of this SupportedServiceAttachment.
        :type: str
        """
        self._service_name = service_name

    @property
    def url(self):
        """
        Gets the url of this SupportedServiceAttachment.
        Optional url to service


        :return: The url of this SupportedServiceAttachment.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this SupportedServiceAttachment.
        Optional url to service


        :param url: The url of this SupportedServiceAttachment.
        :type: str
        """
        self._url = url

    @property
    def type(self):
        """
        **[Required]** Gets the type of this SupportedServiceAttachment.
        Type of service

        Allowed values for this property are: "IMPLEMENTATION_SERVICE", "CONSULTING_SERVICE", "APP_DEVELOPMENT_SERVICE", "MANAGED_SERVICE", "OTHER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this SupportedServiceAttachment.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this SupportedServiceAttachment.
        Type of service


        :param type: The type of this SupportedServiceAttachment.
        :type: str
        """
        allowed_values = ["IMPLEMENTATION_SERVICE", "CONSULTING_SERVICE", "APP_DEVELOPMENT_SERVICE", "MANAGED_SERVICE", "OTHER"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def content_url(self):
        """
        Gets the content_url of this SupportedServiceAttachment.
        URL of the uploaded document.


        :return: The content_url of this SupportedServiceAttachment.
        :rtype: str
        """
        return self._content_url

    @content_url.setter
    def content_url(self, content_url):
        """
        Sets the content_url of this SupportedServiceAttachment.
        URL of the uploaded document.


        :param content_url: The content_url of this SupportedServiceAttachment.
        :type: str
        """
        self._content_url = content_url

    @property
    def mime_type(self):
        """
        Gets the mime_type of this SupportedServiceAttachment.
        The MIME type of the uploaded data.


        :return: The mime_type of this SupportedServiceAttachment.
        :rtype: str
        """
        return self._mime_type

    @mime_type.setter
    def mime_type(self, mime_type):
        """
        Sets the mime_type of this SupportedServiceAttachment.
        The MIME type of the uploaded data.


        :param mime_type: The mime_type of this SupportedServiceAttachment.
        :type: str
        """
        self._mime_type = mime_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
