# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TrainedProfessionals(object):
    """
    Number of trained professional per product
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TrainedProfessionals object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param professionals_count:
            The value to assign to the professionals_count property of this TrainedProfessionals.
        :type professionals_count: int

        :param product_code:
            The value to assign to the product_code property of this TrainedProfessionals.
        :type product_code: str

        """
        self.swagger_types = {
            'professionals_count': 'int',
            'product_code': 'str'
        }
        self.attribute_map = {
            'professionals_count': 'professionalsCount',
            'product_code': 'productCode'
        }
        self._professionals_count = None
        self._product_code = None

    @property
    def professionals_count(self):
        """
        **[Required]** Gets the professionals_count of this TrainedProfessionals.
        Count of trained professional


        :return: The professionals_count of this TrainedProfessionals.
        :rtype: int
        """
        return self._professionals_count

    @professionals_count.setter
    def professionals_count(self, professionals_count):
        """
        Sets the professionals_count of this TrainedProfessionals.
        Count of trained professional


        :param professionals_count: The professionals_count of this TrainedProfessionals.
        :type: int
        """
        self._professionals_count = professionals_count

    @property
    def product_code(self):
        """
        **[Required]** Gets the product_code of this TrainedProfessionals.
        Product code on which professional is trained on


        :return: The product_code of this TrainedProfessionals.
        :rtype: str
        """
        return self._product_code

    @product_code.setter
    def product_code(self, product_code):
        """
        Sets the product_code of this TrainedProfessionals.
        Product code on which professional is trained on


        :param product_code: The product_code of this TrainedProfessionals.
        :type: str
        """
        self._product_code = product_code

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
