# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250320


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OpsActionCreateMacDeviceDetails(object):
    """
    The data to create a MacDevice in MAC_DEVICE bucket.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OpsActionCreateMacDeviceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param serial_number:
            The value to assign to the serial_number property of this OpsActionCreateMacDeviceDetails.
        :type serial_number: str

        :param ip_address:
            The value to assign to the ip_address property of this OpsActionCreateMacDeviceDetails.
        :type ip_address: str

        """
        self.swagger_types = {
            'serial_number': 'str',
            'ip_address': 'str'
        }
        self.attribute_map = {
            'serial_number': 'serialNumber',
            'ip_address': 'ipAddress'
        }
        self._serial_number = None
        self._ip_address = None

    @property
    def serial_number(self):
        """
        **[Required]** Gets the serial_number of this OpsActionCreateMacDeviceDetails.
        The serial number of the MacDevice.


        :return: The serial_number of this OpsActionCreateMacDeviceDetails.
        :rtype: str
        """
        return self._serial_number

    @serial_number.setter
    def serial_number(self, serial_number):
        """
        Sets the serial_number of this OpsActionCreateMacDeviceDetails.
        The serial number of the MacDevice.


        :param serial_number: The serial_number of this OpsActionCreateMacDeviceDetails.
        :type: str
        """
        self._serial_number = serial_number

    @property
    def ip_address(self):
        """
        **[Required]** Gets the ip_address of this OpsActionCreateMacDeviceDetails.
        The IP address assigned to the MacDevice.


        :return: The ip_address of this OpsActionCreateMacDeviceDetails.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this OpsActionCreateMacDeviceDetails.
        The IP address assigned to the MacDevice.


        :param ip_address: The ip_address of this OpsActionCreateMacDeviceDetails.
        :type: str
        """
        self._ip_address = ip_address

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
