# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250320


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OpsActionUpdateMacDeviceDetails(object):
    """
    The data to update a MacDevice in MAC_DEVICE bucket.
    """

    #: A constant which can be used with the lifecycle_state property of a OpsActionUpdateMacDeviceDetails.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a OpsActionUpdateMacDeviceDetails.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a OpsActionUpdateMacDeviceDetails.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a OpsActionUpdateMacDeviceDetails.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a OpsActionUpdateMacDeviceDetails.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new OpsActionUpdateMacDeviceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ip_address:
            The value to assign to the ip_address property of this OpsActionUpdateMacDeviceDetails.
        :type ip_address: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OpsActionUpdateMacDeviceDetails.
            Allowed values for this property are: "CREATING", "ACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED"
        :type lifecycle_state: str

        """
        self.swagger_types = {
            'ip_address': 'str',
            'lifecycle_state': 'str'
        }
        self.attribute_map = {
            'ip_address': 'ipAddress',
            'lifecycle_state': 'lifecycleState'
        }
        self._ip_address = None
        self._lifecycle_state = None

    @property
    def ip_address(self):
        """
        Gets the ip_address of this OpsActionUpdateMacDeviceDetails.
        The IP address assigned to the MacDevice.


        :return: The ip_address of this OpsActionUpdateMacDeviceDetails.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this OpsActionUpdateMacDeviceDetails.
        The IP address assigned to the MacDevice.


        :param ip_address: The ip_address of this OpsActionUpdateMacDeviceDetails.
        :type: str
        """
        self._ip_address = ip_address

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this OpsActionUpdateMacDeviceDetails.
        The current status of the MacDevice.

        Allowed values for this property are: "CREATING", "ACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED"


        :return: The lifecycle_state of this OpsActionUpdateMacDeviceDetails.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this OpsActionUpdateMacDeviceDetails.
        The current status of the MacDevice.


        :param lifecycle_state: The lifecycle_state of this OpsActionUpdateMacDeviceDetails.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            raise ValueError(
                f"Invalid value for `lifecycle_state`, must be None or one of {allowed_values}"
            )
        self._lifecycle_state = lifecycle_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
