# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExternalLocationsMetadatumSummary(object):
    """
    Flat Map of CSP Region -> CSP-Physical-AZ -> CSP-Logical-AZ -> OCI Site Group -> CPG-ID
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExternalLocationsMetadatumSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ExternalLocationsMetadatumSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ExternalLocationsMetadatumSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ExternalLocationsMetadatumSummary.
        :type system_tags: dict(str, dict(str, object))

        :param external_location:
            The value to assign to the external_location property of this ExternalLocationsMetadatumSummary.
        :type external_location: oci.multicloud.models.ExternalLocationDetail

        :param oci_physical_ad:
            The value to assign to the oci_physical_ad property of this ExternalLocationsMetadatumSummary.
        :type oci_physical_ad: str

        :param oci_logical_ad:
            The value to assign to the oci_logical_ad property of this ExternalLocationsMetadatumSummary.
        :type oci_logical_ad: str

        :param oci_region:
            The value to assign to the oci_region property of this ExternalLocationsMetadatumSummary.
        :type oci_region: str

        :param cpg_id:
            The value to assign to the cpg_id property of this ExternalLocationsMetadatumSummary.
        :type cpg_id: str

        :param cluster_placement_group_id:
            The value to assign to the cluster_placement_group_id property of this ExternalLocationsMetadatumSummary.
        :type cluster_placement_group_id: str

        :param partner_cloud_name:
            The value to assign to the partner_cloud_name property of this ExternalLocationsMetadatumSummary.
        :type partner_cloud_name: str

        :param partner_cloud_account_name:
            The value to assign to the partner_cloud_account_name property of this ExternalLocationsMetadatumSummary.
        :type partner_cloud_account_name: str

        :param partner_cloud_account_url:
            The value to assign to the partner_cloud_account_url property of this ExternalLocationsMetadatumSummary.
        :type partner_cloud_account_url: str

        """
        self.swagger_types = {
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'external_location': 'ExternalLocationDetail',
            'oci_physical_ad': 'str',
            'oci_logical_ad': 'str',
            'oci_region': 'str',
            'cpg_id': 'str',
            'cluster_placement_group_id': 'str',
            'partner_cloud_name': 'str',
            'partner_cloud_account_name': 'str',
            'partner_cloud_account_url': 'str'
        }
        self.attribute_map = {
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'external_location': 'externalLocation',
            'oci_physical_ad': 'ociPhysicalAd',
            'oci_logical_ad': 'ociLogicalAd',
            'oci_region': 'ociRegion',
            'cpg_id': 'cpgId',
            'cluster_placement_group_id': 'clusterPlacementGroupId',
            'partner_cloud_name': 'partnerCloudName',
            'partner_cloud_account_name': 'partnerCloudAccountName',
            'partner_cloud_account_url': 'partnerCloudAccountUrl'
        }
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._external_location = None
        self._oci_physical_ad = None
        self._oci_logical_ad = None
        self._oci_region = None
        self._cpg_id = None
        self._cluster_placement_group_id = None
        self._partner_cloud_name = None
        self._partner_cloud_account_name = None
        self._partner_cloud_account_url = None

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this ExternalLocationsMetadatumSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ExternalLocationsMetadatumSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ExternalLocationsMetadatumSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ExternalLocationsMetadatumSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this ExternalLocationsMetadatumSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ExternalLocationsMetadatumSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ExternalLocationsMetadatumSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ExternalLocationsMetadatumSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ExternalLocationsMetadatumSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ExternalLocationsMetadatumSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ExternalLocationsMetadatumSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ExternalLocationsMetadatumSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def external_location(self):
        """
        **[Required]** Gets the external_location of this ExternalLocationsMetadatumSummary.

        :return: The external_location of this ExternalLocationsMetadatumSummary.
        :rtype: oci.multicloud.models.ExternalLocationDetail
        """
        return self._external_location

    @external_location.setter
    def external_location(self, external_location):
        """
        Sets the external_location of this ExternalLocationsMetadatumSummary.

        :param external_location: The external_location of this ExternalLocationsMetadatumSummary.
        :type: oci.multicloud.models.ExternalLocationDetail
        """
        self._external_location = external_location

    @property
    def oci_physical_ad(self):
        """
        **[Required]** Gets the oci_physical_ad of this ExternalLocationsMetadatumSummary.
        OCI physical ad name


        :return: The oci_physical_ad of this ExternalLocationsMetadatumSummary.
        :rtype: str
        """
        return self._oci_physical_ad

    @oci_physical_ad.setter
    def oci_physical_ad(self, oci_physical_ad):
        """
        Sets the oci_physical_ad of this ExternalLocationsMetadatumSummary.
        OCI physical ad name


        :param oci_physical_ad: The oci_physical_ad of this ExternalLocationsMetadatumSummary.
        :type: str
        """
        self._oci_physical_ad = oci_physical_ad

    @property
    def oci_logical_ad(self):
        """
        Gets the oci_logical_ad of this ExternalLocationsMetadatumSummary.
        OCI logical ad name


        :return: The oci_logical_ad of this ExternalLocationsMetadatumSummary.
        :rtype: str
        """
        return self._oci_logical_ad

    @oci_logical_ad.setter
    def oci_logical_ad(self, oci_logical_ad):
        """
        Sets the oci_logical_ad of this ExternalLocationsMetadatumSummary.
        OCI logical ad name


        :param oci_logical_ad: The oci_logical_ad of this ExternalLocationsMetadatumSummary.
        :type: str
        """
        self._oci_logical_ad = oci_logical_ad

    @property
    def oci_region(self):
        """
        **[Required]** Gets the oci_region of this ExternalLocationsMetadatumSummary.
        OCI region identifier https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm


        :return: The oci_region of this ExternalLocationsMetadatumSummary.
        :rtype: str
        """
        return self._oci_region

    @oci_region.setter
    def oci_region(self, oci_region):
        """
        Sets the oci_region of this ExternalLocationsMetadatumSummary.
        OCI region identifier https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm


        :param oci_region: The oci_region of this ExternalLocationsMetadatumSummary.
        :type: str
        """
        self._oci_region = oci_region

    @property
    def cpg_id(self):
        """
        **[Required]** Gets the cpg_id of this ExternalLocationsMetadatumSummary.
        Cluster Placement Group OCID (deprecated representation)


        :return: The cpg_id of this ExternalLocationsMetadatumSummary.
        :rtype: str
        """
        return self._cpg_id

    @cpg_id.setter
    def cpg_id(self, cpg_id):
        """
        Sets the cpg_id of this ExternalLocationsMetadatumSummary.
        Cluster Placement Group OCID (deprecated representation)


        :param cpg_id: The cpg_id of this ExternalLocationsMetadatumSummary.
        :type: str
        """
        self._cpg_id = cpg_id

    @property
    def cluster_placement_group_id(self):
        """
        **[Required]** Gets the cluster_placement_group_id of this ExternalLocationsMetadatumSummary.
        Cluster Placement Group OCID


        :return: The cluster_placement_group_id of this ExternalLocationsMetadatumSummary.
        :rtype: str
        """
        return self._cluster_placement_group_id

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, cluster_placement_group_id):
        """
        Sets the cluster_placement_group_id of this ExternalLocationsMetadatumSummary.
        Cluster Placement Group OCID


        :param cluster_placement_group_id: The cluster_placement_group_id of this ExternalLocationsMetadatumSummary.
        :type: str
        """
        self._cluster_placement_group_id = cluster_placement_group_id

    @property
    def partner_cloud_name(self):
        """
        Gets the partner_cloud_name of this ExternalLocationsMetadatumSummary.
        Partner Cloud Name based on service name


        :return: The partner_cloud_name of this ExternalLocationsMetadatumSummary.
        :rtype: str
        """
        return self._partner_cloud_name

    @partner_cloud_name.setter
    def partner_cloud_name(self, partner_cloud_name):
        """
        Sets the partner_cloud_name of this ExternalLocationsMetadatumSummary.
        Partner Cloud Name based on service name


        :param partner_cloud_name: The partner_cloud_name of this ExternalLocationsMetadatumSummary.
        :type: str
        """
        self._partner_cloud_name = partner_cloud_name

    @property
    def partner_cloud_account_name(self):
        """
        Gets the partner_cloud_account_name of this ExternalLocationsMetadatumSummary.
        User friendly name of account name for customer's subscription


        :return: The partner_cloud_account_name of this ExternalLocationsMetadatumSummary.
        :rtype: str
        """
        return self._partner_cloud_account_name

    @partner_cloud_account_name.setter
    def partner_cloud_account_name(self, partner_cloud_account_name):
        """
        Sets the partner_cloud_account_name of this ExternalLocationsMetadatumSummary.
        User friendly name of account name for customer's subscription


        :param partner_cloud_account_name: The partner_cloud_account_name of this ExternalLocationsMetadatumSummary.
        :type: str
        """
        self._partner_cloud_account_name = partner_cloud_account_name

    @property
    def partner_cloud_account_url(self):
        """
        Gets the partner_cloud_account_url of this ExternalLocationsMetadatumSummary.
        Direct URL to partner cloud for customer's account


        :return: The partner_cloud_account_url of this ExternalLocationsMetadatumSummary.
        :rtype: str
        """
        return self._partner_cloud_account_url

    @partner_cloud_account_url.setter
    def partner_cloud_account_url(self, partner_cloud_account_url):
        """
        Sets the partner_cloud_account_url of this ExternalLocationsMetadatumSummary.
        Direct URL to partner cloud for customer's account


        :param partner_cloud_account_url: The partner_cloud_account_url of this ExternalLocationsMetadatumSummary.
        :type: str
        """
        self._partner_cloud_account_url = partner_cloud_account_url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
