# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateDbSystemDetails(object):
    """
    Details required to update a DB System.
    """

    #: A constant which can be used with the crash_recovery property of a UpdateDbSystemDetails.
    #: This constant has a value of "ENABLED"
    CRASH_RECOVERY_ENABLED = "ENABLED"

    #: A constant which can be used with the crash_recovery property of a UpdateDbSystemDetails.
    #: This constant has a value of "DISABLED"
    CRASH_RECOVERY_DISABLED = "DISABLED"

    #: A constant which can be used with the database_management property of a UpdateDbSystemDetails.
    #: This constant has a value of "ENABLED"
    DATABASE_MANAGEMENT_ENABLED = "ENABLED"

    #: A constant which can be used with the database_management property of a UpdateDbSystemDetails.
    #: This constant has a value of "DISABLED"
    DATABASE_MANAGEMENT_DISABLED = "DISABLED"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateDbSystemDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateDbSystemDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateDbSystemDetails.
        :type description: str

        :param subnet_id:
            The value to assign to the subnet_id property of this UpdateDbSystemDetails.
        :type subnet_id: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this UpdateDbSystemDetails.
        :type nsg_ids: list[str]

        :param security_attributes:
            The value to assign to the security_attributes property of this UpdateDbSystemDetails.
        :type security_attributes: dict(str, dict(str, object))

        :param database_mode:
            The value to assign to the database_mode property of this UpdateDbSystemDetails.
        :type database_mode: str

        :param access_mode:
            The value to assign to the access_mode property of this UpdateDbSystemDetails.
        :type access_mode: str

        :param rest:
            The value to assign to the rest property of this UpdateDbSystemDetails.
        :type rest: oci.mysql.models.UpdateRestDetails

        :param database_console:
            The value to assign to the database_console property of this UpdateDbSystemDetails.
        :type database_console: oci.mysql.models.UpdateDatabaseConsoleDetails

        :param is_highly_available:
            The value to assign to the is_highly_available property of this UpdateDbSystemDetails.
        :type is_highly_available: bool

        :param availability_domain:
            The value to assign to the availability_domain property of this UpdateDbSystemDetails.
        :type availability_domain: str

        :param fault_domain:
            The value to assign to the fault_domain property of this UpdateDbSystemDetails.
        :type fault_domain: str

        :param shape_name:
            The value to assign to the shape_name property of this UpdateDbSystemDetails.
        :type shape_name: str

        :param mysql_version:
            The value to assign to the mysql_version property of this UpdateDbSystemDetails.
        :type mysql_version: str

        :param configuration_id:
            The value to assign to the configuration_id property of this UpdateDbSystemDetails.
        :type configuration_id: str

        :param admin_username:
            The value to assign to the admin_username property of this UpdateDbSystemDetails.
        :type admin_username: str

        :param admin_password:
            The value to assign to the admin_password property of this UpdateDbSystemDetails.
        :type admin_password: str

        :param data_storage_size_in_gbs:
            The value to assign to the data_storage_size_in_gbs property of this UpdateDbSystemDetails.
        :type data_storage_size_in_gbs: int

        :param data_storage:
            The value to assign to the data_storage property of this UpdateDbSystemDetails.
        :type data_storage: oci.mysql.models.DataStorageDetails

        :param hostname_label:
            The value to assign to the hostname_label property of this UpdateDbSystemDetails.
        :type hostname_label: str

        :param ip_address:
            The value to assign to the ip_address property of this UpdateDbSystemDetails.
        :type ip_address: str

        :param port:
            The value to assign to the port property of this UpdateDbSystemDetails.
        :type port: int

        :param port_x:
            The value to assign to the port_x property of this UpdateDbSystemDetails.
        :type port_x: int

        :param backup_policy:
            The value to assign to the backup_policy property of this UpdateDbSystemDetails.
        :type backup_policy: oci.mysql.models.UpdateBackupPolicyDetails

        :param maintenance:
            The value to assign to the maintenance property of this UpdateDbSystemDetails.
        :type maintenance: oci.mysql.models.UpdateMaintenanceDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateDbSystemDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateDbSystemDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param deletion_policy:
            The value to assign to the deletion_policy property of this UpdateDbSystemDetails.
        :type deletion_policy: oci.mysql.models.UpdateDeletionPolicyDetails

        :param crash_recovery:
            The value to assign to the crash_recovery property of this UpdateDbSystemDetails.
            Allowed values for this property are: "ENABLED", "DISABLED"
        :type crash_recovery: str

        :param database_management:
            The value to assign to the database_management property of this UpdateDbSystemDetails.
            Allowed values for this property are: "ENABLED", "DISABLED"
        :type database_management: str

        :param secure_connections:
            The value to assign to the secure_connections property of this UpdateDbSystemDetails.
        :type secure_connections: oci.mysql.models.SecureConnectionDetails

        :param encrypt_data:
            The value to assign to the encrypt_data property of this UpdateDbSystemDetails.
        :type encrypt_data: oci.mysql.models.EncryptDataDetails

        :param customer_contacts:
            The value to assign to the customer_contacts property of this UpdateDbSystemDetails.
        :type customer_contacts: list[oci.mysql.models.CustomerContact]

        :param read_endpoint:
            The value to assign to the read_endpoint property of this UpdateDbSystemDetails.
        :type read_endpoint: oci.mysql.models.UpdateReadEndpointDetails

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'subnet_id': 'str',
            'nsg_ids': 'list[str]',
            'security_attributes': 'dict(str, dict(str, object))',
            'database_mode': 'str',
            'access_mode': 'str',
            'rest': 'UpdateRestDetails',
            'database_console': 'UpdateDatabaseConsoleDetails',
            'is_highly_available': 'bool',
            'availability_domain': 'str',
            'fault_domain': 'str',
            'shape_name': 'str',
            'mysql_version': 'str',
            'configuration_id': 'str',
            'admin_username': 'str',
            'admin_password': 'str',
            'data_storage_size_in_gbs': 'int',
            'data_storage': 'DataStorageDetails',
            'hostname_label': 'str',
            'ip_address': 'str',
            'port': 'int',
            'port_x': 'int',
            'backup_policy': 'UpdateBackupPolicyDetails',
            'maintenance': 'UpdateMaintenanceDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'deletion_policy': 'UpdateDeletionPolicyDetails',
            'crash_recovery': 'str',
            'database_management': 'str',
            'secure_connections': 'SecureConnectionDetails',
            'encrypt_data': 'EncryptDataDetails',
            'customer_contacts': 'list[CustomerContact]',
            'read_endpoint': 'UpdateReadEndpointDetails'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'subnet_id': 'subnetId',
            'nsg_ids': 'nsgIds',
            'security_attributes': 'securityAttributes',
            'database_mode': 'databaseMode',
            'access_mode': 'accessMode',
            'rest': 'rest',
            'database_console': 'databaseConsole',
            'is_highly_available': 'isHighlyAvailable',
            'availability_domain': 'availabilityDomain',
            'fault_domain': 'faultDomain',
            'shape_name': 'shapeName',
            'mysql_version': 'mysqlVersion',
            'configuration_id': 'configurationId',
            'admin_username': 'adminUsername',
            'admin_password': 'adminPassword',
            'data_storage_size_in_gbs': 'dataStorageSizeInGBs',
            'data_storage': 'dataStorage',
            'hostname_label': 'hostnameLabel',
            'ip_address': 'ipAddress',
            'port': 'port',
            'port_x': 'portX',
            'backup_policy': 'backupPolicy',
            'maintenance': 'maintenance',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'deletion_policy': 'deletionPolicy',
            'crash_recovery': 'crashRecovery',
            'database_management': 'databaseManagement',
            'secure_connections': 'secureConnections',
            'encrypt_data': 'encryptData',
            'customer_contacts': 'customerContacts',
            'read_endpoint': 'readEndpoint'
        }
        self._display_name = None
        self._description = None
        self._subnet_id = None
        self._nsg_ids = None
        self._security_attributes = None
        self._database_mode = None
        self._access_mode = None
        self._rest = None
        self._database_console = None
        self._is_highly_available = None
        self._availability_domain = None
        self._fault_domain = None
        self._shape_name = None
        self._mysql_version = None
        self._configuration_id = None
        self._admin_username = None
        self._admin_password = None
        self._data_storage_size_in_gbs = None
        self._data_storage = None
        self._hostname_label = None
        self._ip_address = None
        self._port = None
        self._port_x = None
        self._backup_policy = None
        self._maintenance = None
        self._freeform_tags = None
        self._defined_tags = None
        self._deletion_policy = None
        self._crash_recovery = None
        self._database_management = None
        self._secure_connections = None
        self._encrypt_data = None
        self._customer_contacts = None
        self._read_endpoint = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateDbSystemDetails.
        The user-friendly name for the DB System. It does not have to be unique.


        :return: The display_name of this UpdateDbSystemDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateDbSystemDetails.
        The user-friendly name for the DB System. It does not have to be unique.


        :param display_name: The display_name of this UpdateDbSystemDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateDbSystemDetails.
        User-provided data about the DB System.


        :return: The description of this UpdateDbSystemDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateDbSystemDetails.
        User-provided data about the DB System.


        :param description: The description of this UpdateDbSystemDetails.
        :type: str
        """
        self._description = description

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this UpdateDbSystemDetails.
        The OCID of the subnet the DB System is associated with.


        :return: The subnet_id of this UpdateDbSystemDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this UpdateDbSystemDetails.
        The OCID of the subnet the DB System is associated with.


        :param subnet_id: The subnet_id of this UpdateDbSystemDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this UpdateDbSystemDetails.
        Network Security Group OCIDs used for the VNIC attachment.


        :return: The nsg_ids of this UpdateDbSystemDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this UpdateDbSystemDetails.
        Network Security Group OCIDs used for the VNIC attachment.


        :param nsg_ids: The nsg_ids of this UpdateDbSystemDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def security_attributes(self):
        """
        Gets the security_attributes of this UpdateDbSystemDetails.
        Security Attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `ZPR Artifacts`__.
        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"audit\"}}}`

        __ https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm


        :return: The security_attributes of this UpdateDbSystemDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._security_attributes

    @security_attributes.setter
    def security_attributes(self, security_attributes):
        """
        Sets the security_attributes of this UpdateDbSystemDetails.
        Security Attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `ZPR Artifacts`__.
        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"audit\"}}}`

        __ https://docs.oracle.com/en-us/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm


        :param security_attributes: The security_attributes of this UpdateDbSystemDetails.
        :type: dict(str, dict(str, object))
        """
        self._security_attributes = security_attributes

    @property
    def database_mode(self):
        """
        Gets the database_mode of this UpdateDbSystemDetails.
        The database mode indicating the types of statements that will be allowed to run in the DB system.
        This mode will apply only to statements run by user connections. Replicated write statements will continue
        to be allowed regardless of the DatabaseMode.
          - READ_WRITE: allow running read and write statements on the DB system;
          - READ_ONLY: only allow running read statements on the DB system.


        :return: The database_mode of this UpdateDbSystemDetails.
        :rtype: str
        """
        return self._database_mode

    @database_mode.setter
    def database_mode(self, database_mode):
        """
        Sets the database_mode of this UpdateDbSystemDetails.
        The database mode indicating the types of statements that will be allowed to run in the DB system.
        This mode will apply only to statements run by user connections. Replicated write statements will continue
        to be allowed regardless of the DatabaseMode.
          - READ_WRITE: allow running read and write statements on the DB system;
          - READ_ONLY: only allow running read statements on the DB system.


        :param database_mode: The database_mode of this UpdateDbSystemDetails.
        :type: str
        """
        self._database_mode = database_mode

    @property
    def access_mode(self):
        """
        Gets the access_mode of this UpdateDbSystemDetails.
        The access mode indicating if the database access will be restricted only to administrators or not:
         - UNRESTRICTED: the access to the database is not restricted;
         - RESTRICTED: the access will be allowed only to users with specific privileges;
           RESTRICTED will correspond to setting the MySQL system variable
           `offline_mode`__ to ON.

        __ https://dev.mysql.com/doc/en/server-system-variables.html#sysvar_offline_mode


        :return: The access_mode of this UpdateDbSystemDetails.
        :rtype: str
        """
        return self._access_mode

    @access_mode.setter
    def access_mode(self, access_mode):
        """
        Sets the access_mode of this UpdateDbSystemDetails.
        The access mode indicating if the database access will be restricted only to administrators or not:
         - UNRESTRICTED: the access to the database is not restricted;
         - RESTRICTED: the access will be allowed only to users with specific privileges;
           RESTRICTED will correspond to setting the MySQL system variable
           `offline_mode`__ to ON.

        __ https://dev.mysql.com/doc/en/server-system-variables.html#sysvar_offline_mode


        :param access_mode: The access_mode of this UpdateDbSystemDetails.
        :type: str
        """
        self._access_mode = access_mode

    @property
    def rest(self):
        """
        Gets the rest of this UpdateDbSystemDetails.

        :return: The rest of this UpdateDbSystemDetails.
        :rtype: oci.mysql.models.UpdateRestDetails
        """
        return self._rest

    @rest.setter
    def rest(self, rest):
        """
        Sets the rest of this UpdateDbSystemDetails.

        :param rest: The rest of this UpdateDbSystemDetails.
        :type: oci.mysql.models.UpdateRestDetails
        """
        self._rest = rest

    @property
    def database_console(self):
        """
        Gets the database_console of this UpdateDbSystemDetails.

        :return: The database_console of this UpdateDbSystemDetails.
        :rtype: oci.mysql.models.UpdateDatabaseConsoleDetails
        """
        return self._database_console

    @database_console.setter
    def database_console(self, database_console):
        """
        Sets the database_console of this UpdateDbSystemDetails.

        :param database_console: The database_console of this UpdateDbSystemDetails.
        :type: oci.mysql.models.UpdateDatabaseConsoleDetails
        """
        self._database_console = database_console

    @property
    def is_highly_available(self):
        """
        Gets the is_highly_available of this UpdateDbSystemDetails.
        Specifies if the DB System is highly available.

        Set to true to enable high availability. Two secondary MySQL instances are created and placed in the unused
        availability or fault domains, depending on your region and subnet type.
        Set to false to disable high availability. The secondary MySQL instances are removed and the MySQL instance
        in the preferred location is used.


        :return: The is_highly_available of this UpdateDbSystemDetails.
        :rtype: bool
        """
        return self._is_highly_available

    @is_highly_available.setter
    def is_highly_available(self, is_highly_available):
        """
        Sets the is_highly_available of this UpdateDbSystemDetails.
        Specifies if the DB System is highly available.

        Set to true to enable high availability. Two secondary MySQL instances are created and placed in the unused
        availability or fault domains, depending on your region and subnet type.
        Set to false to disable high availability. The secondary MySQL instances are removed and the MySQL instance
        in the preferred location is used.


        :param is_highly_available: The is_highly_available of this UpdateDbSystemDetails.
        :type: bool
        """
        self._is_highly_available = is_highly_available

    @property
    def availability_domain(self):
        """
        Gets the availability_domain of this UpdateDbSystemDetails.
        The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains
        and the MySQL instance in that domain is promoted to the primary instance.
        This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the availability domain in which the DB System is placed.


        :return: The availability_domain of this UpdateDbSystemDetails.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this UpdateDbSystemDetails.
        The availability domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other availability domains
        and the MySQL instance in that domain is promoted to the primary instance.
        This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the availability domain in which the DB System is placed.


        :param availability_domain: The availability_domain of this UpdateDbSystemDetails.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def fault_domain(self):
        """
        Gets the fault_domain of this UpdateDbSystemDetails.
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains
        and the MySQL instance in that domain is promoted to the primary instance.
        This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the fault domain in which the DB System is placed.


        :return: The fault_domain of this UpdateDbSystemDetails.
        :rtype: str
        """
        return self._fault_domain

    @fault_domain.setter
    def fault_domain(self, fault_domain):
        """
        Sets the fault_domain of this UpdateDbSystemDetails.
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.

        In a failover scenario, the Read/Write endpoint is redirected to one of the other fault domains
        and the MySQL instance in that domain is promoted to the primary instance.
        This redirection does not affect the IP address of the DB System in any way.

        For a standalone DB System, this defines the fault domain in which the DB System is placed.


        :param fault_domain: The fault_domain of this UpdateDbSystemDetails.
        :type: str
        """
        self._fault_domain = fault_domain

    @property
    def shape_name(self):
        """
        Gets the shape_name of this UpdateDbSystemDetails.
        The shape of the DB System. The shape determines resources
        allocated to the DB System - CPU cores and memory for VM
        shapes; CPU cores, memory and storage for non-VM (or bare metal)
        shapes. To get a list of shapes, use the
        :func:`list_shapes`
        operation.

        Changes in Shape will result in a downtime as the MySQL DB System is
        migrated to the new Compute instance.


        :return: The shape_name of this UpdateDbSystemDetails.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this UpdateDbSystemDetails.
        The shape of the DB System. The shape determines resources
        allocated to the DB System - CPU cores and memory for VM
        shapes; CPU cores, memory and storage for non-VM (or bare metal)
        shapes. To get a list of shapes, use the
        :func:`list_shapes`
        operation.

        Changes in Shape will result in a downtime as the MySQL DB System is
        migrated to the new Compute instance.


        :param shape_name: The shape_name of this UpdateDbSystemDetails.
        :type: str
        """
        self._shape_name = shape_name

    @property
    def mysql_version(self):
        """
        Gets the mysql_version of this UpdateDbSystemDetails.
        The specific MySQL version identifier.


        :return: The mysql_version of this UpdateDbSystemDetails.
        :rtype: str
        """
        return self._mysql_version

    @mysql_version.setter
    def mysql_version(self, mysql_version):
        """
        Sets the mysql_version of this UpdateDbSystemDetails.
        The specific MySQL version identifier.


        :param mysql_version: The mysql_version of this UpdateDbSystemDetails.
        :type: str
        """
        self._mysql_version = mysql_version

    @property
    def configuration_id(self):
        """
        Gets the configuration_id of this UpdateDbSystemDetails.
        The OCID of the Configuration to be used for Instances in this DB System.


        :return: The configuration_id of this UpdateDbSystemDetails.
        :rtype: str
        """
        return self._configuration_id

    @configuration_id.setter
    def configuration_id(self, configuration_id):
        """
        Sets the configuration_id of this UpdateDbSystemDetails.
        The OCID of the Configuration to be used for Instances in this DB System.


        :param configuration_id: The configuration_id of this UpdateDbSystemDetails.
        :type: str
        """
        self._configuration_id = configuration_id

    @property
    def admin_username(self):
        """
        Gets the admin_username of this UpdateDbSystemDetails.
        The username for the administrative user for the MySQL Instance.


        :return: The admin_username of this UpdateDbSystemDetails.
        :rtype: str
        """
        return self._admin_username

    @admin_username.setter
    def admin_username(self, admin_username):
        """
        Sets the admin_username of this UpdateDbSystemDetails.
        The username for the administrative user for the MySQL Instance.


        :param admin_username: The admin_username of this UpdateDbSystemDetails.
        :type: str
        """
        self._admin_username = admin_username

    @property
    def admin_password(self):
        """
        Gets the admin_password of this UpdateDbSystemDetails.
        The password for the administrative user. The password must be
        between 8 and 32 characters long, and must contain at least 1
        numeric character, 1 lowercase character, 1 uppercase character, and
        1 special (nonalphanumeric) character.


        :return: The admin_password of this UpdateDbSystemDetails.
        :rtype: str
        """
        return self._admin_password

    @admin_password.setter
    def admin_password(self, admin_password):
        """
        Sets the admin_password of this UpdateDbSystemDetails.
        The password for the administrative user. The password must be
        between 8 and 32 characters long, and must contain at least 1
        numeric character, 1 lowercase character, 1 uppercase character, and
        1 special (nonalphanumeric) character.


        :param admin_password: The admin_password of this UpdateDbSystemDetails.
        :type: str
        """
        self._admin_password = admin_password

    @property
    def data_storage_size_in_gbs(self):
        """
        Gets the data_storage_size_in_gbs of this UpdateDbSystemDetails.
        Expands the DB System's storage to the specified value. Only supports values larger than the current DB System's
        storage size.

        DB Systems with an initial storage size of 400 GB or less can be expanded up to 32 TB.
        DB Systems with an initial storage size between 401-800 GB can be expanded up to 64 TB.
        DB Systems with an initial storage size between 801-1200 GB can be expanded up to 96 TB.
        DB Systems with an initial storage size of 1201 GB or more can be expanded up to 128 TB.

        It is not possible to decrease data storage size.


        :return: The data_storage_size_in_gbs of this UpdateDbSystemDetails.
        :rtype: int
        """
        return self._data_storage_size_in_gbs

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, data_storage_size_in_gbs):
        """
        Sets the data_storage_size_in_gbs of this UpdateDbSystemDetails.
        Expands the DB System's storage to the specified value. Only supports values larger than the current DB System's
        storage size.

        DB Systems with an initial storage size of 400 GB or less can be expanded up to 32 TB.
        DB Systems with an initial storage size between 401-800 GB can be expanded up to 64 TB.
        DB Systems with an initial storage size between 801-1200 GB can be expanded up to 96 TB.
        DB Systems with an initial storage size of 1201 GB or more can be expanded up to 128 TB.

        It is not possible to decrease data storage size.


        :param data_storage_size_in_gbs: The data_storage_size_in_gbs of this UpdateDbSystemDetails.
        :type: int
        """
        self._data_storage_size_in_gbs = data_storage_size_in_gbs

    @property
    def data_storage(self):
        """
        Gets the data_storage of this UpdateDbSystemDetails.

        :return: The data_storage of this UpdateDbSystemDetails.
        :rtype: oci.mysql.models.DataStorageDetails
        """
        return self._data_storage

    @data_storage.setter
    def data_storage(self, data_storage):
        """
        Sets the data_storage of this UpdateDbSystemDetails.

        :param data_storage: The data_storage of this UpdateDbSystemDetails.
        :type: oci.mysql.models.DataStorageDetails
        """
        self._data_storage = data_storage

    @property
    def hostname_label(self):
        """
        Gets the hostname_label of this UpdateDbSystemDetails.
        The hostname for the primary endpoint of the DB System. Used for DNS.
        The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN)
        (for example, \"dbsystem-1\" in FQDN \"dbsystem-1.subnet123.vcn1.oraclevcn.com\").
        Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.


        :return: The hostname_label of this UpdateDbSystemDetails.
        :rtype: str
        """
        return self._hostname_label

    @hostname_label.setter
    def hostname_label(self, hostname_label):
        """
        Sets the hostname_label of this UpdateDbSystemDetails.
        The hostname for the primary endpoint of the DB System. Used for DNS.
        The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN)
        (for example, \"dbsystem-1\" in FQDN \"dbsystem-1.subnet123.vcn1.oraclevcn.com\").
        Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.


        :param hostname_label: The hostname_label of this UpdateDbSystemDetails.
        :type: str
        """
        self._hostname_label = hostname_label

    @property
    def ip_address(self):
        """
        Gets the ip_address of this UpdateDbSystemDetails.
        The IP address the DB System should be configured to listen on the provided subnet.
        It must be a free private IP address within the subnet's CIDR. If you don't specify a
        value, Oracle automatically assigns a private IP address from the subnet. This should
        be a \"dotted-quad\" style IPv4 address.


        :return: The ip_address of this UpdateDbSystemDetails.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this UpdateDbSystemDetails.
        The IP address the DB System should be configured to listen on the provided subnet.
        It must be a free private IP address within the subnet's CIDR. If you don't specify a
        value, Oracle automatically assigns a private IP address from the subnet. This should
        be a \"dotted-quad\" style IPv4 address.


        :param ip_address: The ip_address of this UpdateDbSystemDetails.
        :type: str
        """
        self._ip_address = ip_address

    @property
    def port(self):
        """
        Gets the port of this UpdateDbSystemDetails.
        The port for primary endpoint of the DB System to listen on.


        :return: The port of this UpdateDbSystemDetails.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this UpdateDbSystemDetails.
        The port for primary endpoint of the DB System to listen on.


        :param port: The port of this UpdateDbSystemDetails.
        :type: int
        """
        self._port = port

    @property
    def port_x(self):
        """
        Gets the port_x of this UpdateDbSystemDetails.
        The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.


        :return: The port_x of this UpdateDbSystemDetails.
        :rtype: int
        """
        return self._port_x

    @port_x.setter
    def port_x(self, port_x):
        """
        Sets the port_x of this UpdateDbSystemDetails.
        The TCP network port on which X Plugin listens for connections. This is the X Plugin equivalent of port.


        :param port_x: The port_x of this UpdateDbSystemDetails.
        :type: int
        """
        self._port_x = port_x

    @property
    def backup_policy(self):
        """
        Gets the backup_policy of this UpdateDbSystemDetails.

        :return: The backup_policy of this UpdateDbSystemDetails.
        :rtype: oci.mysql.models.UpdateBackupPolicyDetails
        """
        return self._backup_policy

    @backup_policy.setter
    def backup_policy(self, backup_policy):
        """
        Sets the backup_policy of this UpdateDbSystemDetails.

        :param backup_policy: The backup_policy of this UpdateDbSystemDetails.
        :type: oci.mysql.models.UpdateBackupPolicyDetails
        """
        self._backup_policy = backup_policy

    @property
    def maintenance(self):
        """
        Gets the maintenance of this UpdateDbSystemDetails.

        :return: The maintenance of this UpdateDbSystemDetails.
        :rtype: oci.mysql.models.UpdateMaintenanceDetails
        """
        return self._maintenance

    @maintenance.setter
    def maintenance(self, maintenance):
        """
        Sets the maintenance of this UpdateDbSystemDetails.

        :param maintenance: The maintenance of this UpdateDbSystemDetails.
        :type: oci.mysql.models.UpdateMaintenanceDetails
        """
        self._maintenance = maintenance

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateDbSystemDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateDbSystemDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateDbSystemDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateDbSystemDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateDbSystemDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateDbSystemDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateDbSystemDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateDbSystemDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def deletion_policy(self):
        """
        Gets the deletion_policy of this UpdateDbSystemDetails.

        :return: The deletion_policy of this UpdateDbSystemDetails.
        :rtype: oci.mysql.models.UpdateDeletionPolicyDetails
        """
        return self._deletion_policy

    @deletion_policy.setter
    def deletion_policy(self, deletion_policy):
        """
        Sets the deletion_policy of this UpdateDbSystemDetails.

        :param deletion_policy: The deletion_policy of this UpdateDbSystemDetails.
        :type: oci.mysql.models.UpdateDeletionPolicyDetails
        """
        self._deletion_policy = deletion_policy

    @property
    def crash_recovery(self):
        """
        Gets the crash_recovery of this UpdateDbSystemDetails.
        Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled,
        and whether to enable or disable syncing of the Binary Logs.

        Allowed values for this property are: "ENABLED", "DISABLED"


        :return: The crash_recovery of this UpdateDbSystemDetails.
        :rtype: str
        """
        return self._crash_recovery

    @crash_recovery.setter
    def crash_recovery(self, crash_recovery):
        """
        Sets the crash_recovery of this UpdateDbSystemDetails.
        Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled,
        and whether to enable or disable syncing of the Binary Logs.


        :param crash_recovery: The crash_recovery of this UpdateDbSystemDetails.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(crash_recovery, allowed_values):
            raise ValueError(
                f"Invalid value for `crash_recovery`, must be None or one of {allowed_values}"
            )
        self._crash_recovery = crash_recovery

    @property
    def database_management(self):
        """
        Gets the database_management of this UpdateDbSystemDetails.
        Whether to enable monitoring via the Database Management service.

        Allowed values for this property are: "ENABLED", "DISABLED"


        :return: The database_management of this UpdateDbSystemDetails.
        :rtype: str
        """
        return self._database_management

    @database_management.setter
    def database_management(self, database_management):
        """
        Sets the database_management of this UpdateDbSystemDetails.
        Whether to enable monitoring via the Database Management service.


        :param database_management: The database_management of this UpdateDbSystemDetails.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(database_management, allowed_values):
            raise ValueError(
                f"Invalid value for `database_management`, must be None or one of {allowed_values}"
            )
        self._database_management = database_management

    @property
    def secure_connections(self):
        """
        Gets the secure_connections of this UpdateDbSystemDetails.

        :return: The secure_connections of this UpdateDbSystemDetails.
        :rtype: oci.mysql.models.SecureConnectionDetails
        """
        return self._secure_connections

    @secure_connections.setter
    def secure_connections(self, secure_connections):
        """
        Sets the secure_connections of this UpdateDbSystemDetails.

        :param secure_connections: The secure_connections of this UpdateDbSystemDetails.
        :type: oci.mysql.models.SecureConnectionDetails
        """
        self._secure_connections = secure_connections

    @property
    def encrypt_data(self):
        """
        Gets the encrypt_data of this UpdateDbSystemDetails.

        :return: The encrypt_data of this UpdateDbSystemDetails.
        :rtype: oci.mysql.models.EncryptDataDetails
        """
        return self._encrypt_data

    @encrypt_data.setter
    def encrypt_data(self, encrypt_data):
        """
        Sets the encrypt_data of this UpdateDbSystemDetails.

        :param encrypt_data: The encrypt_data of this UpdateDbSystemDetails.
        :type: oci.mysql.models.EncryptDataDetails
        """
        self._encrypt_data = encrypt_data

    @property
    def customer_contacts(self):
        """
        Gets the customer_contacts of this UpdateDbSystemDetails.
        The list of customer email addresses that receive information from Oracle about the specified OCI DB System resource.
        Oracle uses these email addresses to send notifications about planned and unplanned software maintenance updates, information about system hardware, and other information needed by administrators.
        Up to 10 email addresses can be added to the customer contacts for a DB System.


        :return: The customer_contacts of this UpdateDbSystemDetails.
        :rtype: list[oci.mysql.models.CustomerContact]
        """
        return self._customer_contacts

    @customer_contacts.setter
    def customer_contacts(self, customer_contacts):
        """
        Sets the customer_contacts of this UpdateDbSystemDetails.
        The list of customer email addresses that receive information from Oracle about the specified OCI DB System resource.
        Oracle uses these email addresses to send notifications about planned and unplanned software maintenance updates, information about system hardware, and other information needed by administrators.
        Up to 10 email addresses can be added to the customer contacts for a DB System.


        :param customer_contacts: The customer_contacts of this UpdateDbSystemDetails.
        :type: list[oci.mysql.models.CustomerContact]
        """
        self._customer_contacts = customer_contacts

    @property
    def read_endpoint(self):
        """
        Gets the read_endpoint of this UpdateDbSystemDetails.

        :return: The read_endpoint of this UpdateDbSystemDetails.
        :rtype: oci.mysql.models.UpdateReadEndpointDetails
        """
        return self._read_endpoint

    @read_endpoint.setter
    def read_endpoint(self, read_endpoint):
        """
        Sets the read_endpoint of this UpdateDbSystemDetails.

        :param read_endpoint: The read_endpoint of this UpdateDbSystemDetails.
        :type: oci.mysql.models.UpdateReadEndpointDetails
        """
        self._read_endpoint = read_endpoint

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
