# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NatRuleSummary(object):
    """
    Summary of NAT Rules used in the firewall policy.
    A Nat Rule is used to define which traffic NAT should be applied by the firewall, and how it should do so.
    """

    #: A constant which can be used with the type property of a NatRuleSummary.
    #: This constant has a value of "NATV4"
    TYPE_NATV4 = "NATV4"

    def __init__(self, **kwargs):
        """
        Initializes a new NatRuleSummary object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.network_firewall.models.NatV4NatSummary`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this NatRuleSummary.
        :type name: str

        :param type:
            The value to assign to the type property of this NatRuleSummary.
            Allowed values for this property are: "NATV4", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param description:
            The value to assign to the description property of this NatRuleSummary.
        :type description: str

        :param priority_order:
            The value to assign to the priority_order property of this NatRuleSummary.
        :type priority_order: int

        :param parent_resource_id:
            The value to assign to the parent_resource_id property of this NatRuleSummary.
        :type parent_resource_id: str

        """
        self.swagger_types = {
            'name': 'str',
            'type': 'str',
            'description': 'str',
            'priority_order': 'int',
            'parent_resource_id': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'type': 'type',
            'description': 'description',
            'priority_order': 'priorityOrder',
            'parent_resource_id': 'parentResourceId'
        }
        self._name = None
        self._type = None
        self._description = None
        self._priority_order = None
        self._parent_resource_id = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'NATV4':
            return 'NatV4NatSummary'
        else:
            return 'NatRuleSummary'

    @property
    def name(self):
        """
        **[Required]** Gets the name of this NatRuleSummary.
        Name for the nat rule, must be unique within the policy.


        :return: The name of this NatRuleSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this NatRuleSummary.
        Name for the nat rule, must be unique within the policy.


        :param name: The name of this NatRuleSummary.
        :type: str
        """
        self._name = name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this NatRuleSummary.
        NAT type:

        * NATV4 - NATV4 type NAT.

        Allowed values for this property are: "NATV4", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this NatRuleSummary.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this NatRuleSummary.
        NAT type:

        * NATV4 - NATV4 type NAT.


        :param type: The type of this NatRuleSummary.
        :type: str
        """
        allowed_values = ["NATV4"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def description(self):
        """
        Gets the description of this NatRuleSummary.
        Description of a NAT rule. This field can be used to add additional info.


        :return: The description of this NatRuleSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this NatRuleSummary.
        Description of a NAT rule. This field can be used to add additional info.


        :param description: The description of this NatRuleSummary.
        :type: str
        """
        self._description = description

    @property
    def priority_order(self):
        """
        **[Required]** Gets the priority_order of this NatRuleSummary.
        The priority order in which this rule should be evaluated.


        :return: The priority_order of this NatRuleSummary.
        :rtype: int
        """
        return self._priority_order

    @priority_order.setter
    def priority_order(self, priority_order):
        """
        Sets the priority_order of this NatRuleSummary.
        The priority order in which this rule should be evaluated.


        :param priority_order: The priority_order of this NatRuleSummary.
        :type: int
        """
        self._priority_order = priority_order

    @property
    def parent_resource_id(self):
        """
        **[Required]** Gets the parent_resource_id of this NatRuleSummary.
        OCID of the Network Firewall Policy this application belongs to.


        :return: The parent_resource_id of this NatRuleSummary.
        :rtype: str
        """
        return self._parent_resource_id

    @parent_resource_id.setter
    def parent_resource_id(self, parent_resource_id):
        """
        Sets the parent_resource_id of this NatRuleSummary.
        OCID of the Network Firewall Policy this application belongs to.


        :param parent_resource_id: The parent_resource_id of this NatRuleSummary.
        :type: str
        """
        self._parent_resource_id = parent_resource_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
