# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KmsKey(object):
    """
    Information about the state of the service's encryption key management.
    The following properties are read-only and ignored when this object is
    used in UpdateConfiguration: kmsKeyState, timeCreated, timeUpdated.
    """

    #: A constant which can be used with the kms_key_state property of a KmsKey.
    #: This constant has a value of "UPDATING"
    KMS_KEY_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the kms_key_state property of a KmsKey.
    #: This constant has a value of "ACTIVE"
    KMS_KEY_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the kms_key_state property of a KmsKey.
    #: This constant has a value of "DELETED"
    KMS_KEY_STATE_DELETED = "DELETED"

    #: A constant which can be used with the kms_key_state property of a KmsKey.
    #: This constant has a value of "FAILED"
    KMS_KEY_STATE_FAILED = "FAILED"

    #: A constant which can be used with the kms_key_state property of a KmsKey.
    #: This constant has a value of "REVERTING"
    KMS_KEY_STATE_REVERTING = "REVERTING"

    #: A constant which can be used with the kms_key_state property of a KmsKey.
    #: This constant has a value of "DISABLED"
    KMS_KEY_STATE_DISABLED = "DISABLED"

    def __init__(self, **kwargs):
        """
        Initializes a new KmsKey object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this KmsKey.
        :type id: str

        :param kms_vault_id:
            The value to assign to the kms_vault_id property of this KmsKey.
        :type kms_vault_id: str

        :param kms_key_state:
            The value to assign to the kms_key_state property of this KmsKey.
            Allowed values for this property are: "UPDATING", "ACTIVE", "DELETED", "FAILED", "REVERTING", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type kms_key_state: str

        :param time_created:
            The value to assign to the time_created property of this KmsKey.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this KmsKey.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'kms_vault_id': 'str',
            'kms_key_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime'
        }
        self.attribute_map = {
            'id': 'id',
            'kms_vault_id': 'kmsVaultId',
            'kms_key_state': 'kmsKeyState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated'
        }
        self._id = None
        self._kms_vault_id = None
        self._kms_key_state = None
        self._time_created = None
        self._time_updated = None

    @property
    def id(self):
        """
        Gets the id of this KmsKey.
        The OCID of the KMS encryption key assigned to this Hosted
        Environment. If the Hosted Environment is using an
        Oracle-managed Key, then the id will be a null string..


        :return: The id of this KmsKey.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this KmsKey.
        The OCID of the KMS encryption key assigned to this Hosted
        Environment. If the Hosted Environment is using an
        Oracle-managed Key, then the id will be a null string..


        :param id: The id of this KmsKey.
        :type: str
        """
        self._id = id

    @property
    def kms_vault_id(self):
        """
        Gets the kms_vault_id of this KmsKey.
        The OCID of the vault containing the encryption key assigned
        to this Hosted Environment. If the Hosted Environment is
        using an Oracle-managed Key, then the kmsVaultId will be a
        null string.


        :return: The kms_vault_id of this KmsKey.
        :rtype: str
        """
        return self._kms_vault_id

    @kms_vault_id.setter
    def kms_vault_id(self, kms_vault_id):
        """
        Sets the kms_vault_id of this KmsKey.
        The OCID of the vault containing the encryption key assigned
        to this Hosted Environment. If the Hosted Environment is
        using an Oracle-managed Key, then the kmsVaultId will be a
        null string.


        :param kms_vault_id: The kms_vault_id of this KmsKey.
        :type: str
        """
        self._kms_vault_id = kms_vault_id

    @property
    def kms_key_state(self):
        """
        Gets the kms_key_state of this KmsKey.
        The current state of the encryption key assigned to this
        Hosted Environment. Oracle-managed keys will always report
        an ACTIVE state.

        Allowed values for this property are: "UPDATING", "ACTIVE", "DELETED", "FAILED", "REVERTING", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The kms_key_state of this KmsKey.
        :rtype: str
        """
        return self._kms_key_state

    @kms_key_state.setter
    def kms_key_state(self, kms_key_state):
        """
        Sets the kms_key_state of this KmsKey.
        The current state of the encryption key assigned to this
        Hosted Environment. Oracle-managed keys will always report
        an ACTIVE state.


        :param kms_key_state: The kms_key_state of this KmsKey.
        :type: str
        """
        allowed_values = ["UPDATING", "ACTIVE", "DELETED", "FAILED", "REVERTING", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(kms_key_state, allowed_values):
            kms_key_state = 'UNKNOWN_ENUM_VALUE'
        self._kms_key_state = kms_key_state

    @property
    def time_created(self):
        """
        Gets the time_created of this KmsKey.
        The timestamp when encryption key was first enabled for this Hosted Environment.
        RFC3339 formatted.


        :return: The time_created of this KmsKey.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this KmsKey.
        The timestamp when encryption key was first enabled for this Hosted Environment.
        RFC3339 formatted.


        :param time_created: The time_created of this KmsKey.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this KmsKey.
        The timestamp of the last update to the encryption key status. RFC3339 formatted.


        :return: The time_updated of this KmsKey.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this KmsKey.
        The timestamp of the last update to the encryption key status. RFC3339 formatted.


        :param time_updated: The time_updated of this KmsKey.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
