# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DetachDatastoreClusterFromEsxiHostDetails(object):
    """
    Details for the datastore cluster detachment from ESXi hosts.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DetachDatastoreClusterFromEsxiHostDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param esxi_host_id:
            The value to assign to the esxi_host_id property of this DetachDatastoreClusterFromEsxiHostDetails.
        :type esxi_host_id: str

        """
        self.swagger_types = {
            'esxi_host_id': 'str'
        }
        self.attribute_map = {
            'esxi_host_id': 'esxiHostId'
        }
        self._esxi_host_id = None

    @property
    def esxi_host_id(self):
        """
        **[Required]** Gets the esxi_host_id of this DetachDatastoreClusterFromEsxiHostDetails.
        The `OCID`__ of the ESXi host to detach the
        datastore cluster from.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The esxi_host_id of this DetachDatastoreClusterFromEsxiHostDetails.
        :rtype: str
        """
        return self._esxi_host_id

    @esxi_host_id.setter
    def esxi_host_id(self, esxi_host_id):
        """
        Sets the esxi_host_id of this DetachDatastoreClusterFromEsxiHostDetails.
        The `OCID`__ of the ESXi host to detach the
        datastore cluster from.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param esxi_host_id: The esxi_host_id of this DetachDatastoreClusterFromEsxiHostDetails.
        :type: str
        """
        self._esxi_host_id = esxi_host_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
