# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CertificateConfig(object):
    """
    Custom certificate config for customer provided certs.
    """

    #: A constant which can be used with the cluster_certificate_mode property of a CertificateConfig.
    #: This constant has a value of "OCI_CERTIFICATES_SERVICE"
    CLUSTER_CERTIFICATE_MODE_OCI_CERTIFICATES_SERVICE = "OCI_CERTIFICATES_SERVICE"

    #: A constant which can be used with the cluster_certificate_mode property of a CertificateConfig.
    #: This constant has a value of "OPENSEARCH_SERVICE"
    CLUSTER_CERTIFICATE_MODE_OPENSEARCH_SERVICE = "OPENSEARCH_SERVICE"

    #: A constant which can be used with the dashboard_certificate_mode property of a CertificateConfig.
    #: This constant has a value of "OCI_CERTIFICATES_SERVICE"
    DASHBOARD_CERTIFICATE_MODE_OCI_CERTIFICATES_SERVICE = "OCI_CERTIFICATES_SERVICE"

    #: A constant which can be used with the dashboard_certificate_mode property of a CertificateConfig.
    #: This constant has a value of "OPENSEARCH_SERVICE"
    DASHBOARD_CERTIFICATE_MODE_OPENSEARCH_SERVICE = "OPENSEARCH_SERVICE"

    def __init__(self, **kwargs):
        """
        Initializes a new CertificateConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cluster_certificate_mode:
            The value to assign to the cluster_certificate_mode property of this CertificateConfig.
            Allowed values for this property are: "OCI_CERTIFICATES_SERVICE", "OPENSEARCH_SERVICE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type cluster_certificate_mode: str

        :param dashboard_certificate_mode:
            The value to assign to the dashboard_certificate_mode property of this CertificateConfig.
            Allowed values for this property are: "OCI_CERTIFICATES_SERVICE", "OPENSEARCH_SERVICE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type dashboard_certificate_mode: str

        :param open_search_api_certificate_id:
            The value to assign to the open_search_api_certificate_id property of this CertificateConfig.
        :type open_search_api_certificate_id: str

        :param open_search_dashboard_certificate_id:
            The value to assign to the open_search_dashboard_certificate_id property of this CertificateConfig.
        :type open_search_dashboard_certificate_id: str

        """
        self.swagger_types = {
            'cluster_certificate_mode': 'str',
            'dashboard_certificate_mode': 'str',
            'open_search_api_certificate_id': 'str',
            'open_search_dashboard_certificate_id': 'str'
        }
        self.attribute_map = {
            'cluster_certificate_mode': 'clusterCertificateMode',
            'dashboard_certificate_mode': 'dashboardCertificateMode',
            'open_search_api_certificate_id': 'openSearchApiCertificateId',
            'open_search_dashboard_certificate_id': 'openSearchDashboardCertificateId'
        }
        self._cluster_certificate_mode = None
        self._dashboard_certificate_mode = None
        self._open_search_api_certificate_id = None
        self._open_search_dashboard_certificate_id = None

    @property
    def cluster_certificate_mode(self):
        """
        Gets the cluster_certificate_mode of this CertificateConfig.
        Specifies whether the certificate to be used in cluster is managed by OpenSearch or OCI Certificates service.

        Allowed values for this property are: "OCI_CERTIFICATES_SERVICE", "OPENSEARCH_SERVICE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The cluster_certificate_mode of this CertificateConfig.
        :rtype: str
        """
        return self._cluster_certificate_mode

    @cluster_certificate_mode.setter
    def cluster_certificate_mode(self, cluster_certificate_mode):
        """
        Sets the cluster_certificate_mode of this CertificateConfig.
        Specifies whether the certificate to be used in cluster is managed by OpenSearch or OCI Certificates service.


        :param cluster_certificate_mode: The cluster_certificate_mode of this CertificateConfig.
        :type: str
        """
        allowed_values = ["OCI_CERTIFICATES_SERVICE", "OPENSEARCH_SERVICE"]
        if not value_allowed_none_or_none_sentinel(cluster_certificate_mode, allowed_values):
            cluster_certificate_mode = 'UNKNOWN_ENUM_VALUE'
        self._cluster_certificate_mode = cluster_certificate_mode

    @property
    def dashboard_certificate_mode(self):
        """
        Gets the dashboard_certificate_mode of this CertificateConfig.
        Specifies whether the certificate to be used in dashboard is managed by OpenSearch or OCI Certificates service.

        Allowed values for this property are: "OCI_CERTIFICATES_SERVICE", "OPENSEARCH_SERVICE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The dashboard_certificate_mode of this CertificateConfig.
        :rtype: str
        """
        return self._dashboard_certificate_mode

    @dashboard_certificate_mode.setter
    def dashboard_certificate_mode(self, dashboard_certificate_mode):
        """
        Sets the dashboard_certificate_mode of this CertificateConfig.
        Specifies whether the certificate to be used in dashboard is managed by OpenSearch or OCI Certificates service.


        :param dashboard_certificate_mode: The dashboard_certificate_mode of this CertificateConfig.
        :type: str
        """
        allowed_values = ["OCI_CERTIFICATES_SERVICE", "OPENSEARCH_SERVICE"]
        if not value_allowed_none_or_none_sentinel(dashboard_certificate_mode, allowed_values):
            dashboard_certificate_mode = 'UNKNOWN_ENUM_VALUE'
        self._dashboard_certificate_mode = dashboard_certificate_mode

    @property
    def open_search_api_certificate_id(self):
        """
        Gets the open_search_api_certificate_id of this CertificateConfig.
        certificate to be used for OpenSearch cluster api communication


        :return: The open_search_api_certificate_id of this CertificateConfig.
        :rtype: str
        """
        return self._open_search_api_certificate_id

    @open_search_api_certificate_id.setter
    def open_search_api_certificate_id(self, open_search_api_certificate_id):
        """
        Sets the open_search_api_certificate_id of this CertificateConfig.
        certificate to be used for OpenSearch cluster api communication


        :param open_search_api_certificate_id: The open_search_api_certificate_id of this CertificateConfig.
        :type: str
        """
        self._open_search_api_certificate_id = open_search_api_certificate_id

    @property
    def open_search_dashboard_certificate_id(self):
        """
        Gets the open_search_dashboard_certificate_id of this CertificateConfig.
        certificate to be used for OpenSearch dashboard api communication


        :return: The open_search_dashboard_certificate_id of this CertificateConfig.
        :rtype: str
        """
        return self._open_search_dashboard_certificate_id

    @open_search_dashboard_certificate_id.setter
    def open_search_dashboard_certificate_id(self, open_search_dashboard_certificate_id):
        """
        Sets the open_search_dashboard_certificate_id of this CertificateConfig.
        certificate to be used for OpenSearch dashboard api communication


        :param open_search_dashboard_certificate_id: The open_search_dashboard_certificate_id of this CertificateConfig.
        :type: str
        """
        self._open_search_dashboard_certificate_id = open_search_dashboard_certificate_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
