# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateOpensearchClusterDetails(object):
    """
    The configuration details for a new OpenSearch cluster.
    """

    #: A constant which can be used with the master_node_host_type property of a CreateOpensearchClusterDetails.
    #: This constant has a value of "FLEX"
    MASTER_NODE_HOST_TYPE_FLEX = "FLEX"

    #: A constant which can be used with the master_node_host_type property of a CreateOpensearchClusterDetails.
    #: This constant has a value of "BM"
    MASTER_NODE_HOST_TYPE_BM = "BM"

    #: A constant which can be used with the data_node_host_type property of a CreateOpensearchClusterDetails.
    #: This constant has a value of "FLEX"
    DATA_NODE_HOST_TYPE_FLEX = "FLEX"

    #: A constant which can be used with the data_node_host_type property of a CreateOpensearchClusterDetails.
    #: This constant has a value of "BM"
    DATA_NODE_HOST_TYPE_BM = "BM"

    #: A constant which can be used with the search_node_host_type property of a CreateOpensearchClusterDetails.
    #: This constant has a value of "FLEX"
    SEARCH_NODE_HOST_TYPE_FLEX = "FLEX"

    #: A constant which can be used with the security_mode property of a CreateOpensearchClusterDetails.
    #: This constant has a value of "DISABLED"
    SECURITY_MODE_DISABLED = "DISABLED"

    #: A constant which can be used with the security_mode property of a CreateOpensearchClusterDetails.
    #: This constant has a value of "PERMISSIVE"
    SECURITY_MODE_PERMISSIVE = "PERMISSIVE"

    #: A constant which can be used with the security_mode property of a CreateOpensearchClusterDetails.
    #: This constant has a value of "ENFORCING"
    SECURITY_MODE_ENFORCING = "ENFORCING"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateOpensearchClusterDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateOpensearchClusterDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateOpensearchClusterDetails.
        :type compartment_id: str

        :param software_version:
            The value to assign to the software_version property of this CreateOpensearchClusterDetails.
        :type software_version: str

        :param master_node_count:
            The value to assign to the master_node_count property of this CreateOpensearchClusterDetails.
        :type master_node_count: int

        :param master_node_host_type:
            The value to assign to the master_node_host_type property of this CreateOpensearchClusterDetails.
            Allowed values for this property are: "FLEX", "BM"
        :type master_node_host_type: str

        :param master_node_host_bare_metal_shape:
            The value to assign to the master_node_host_bare_metal_shape property of this CreateOpensearchClusterDetails.
        :type master_node_host_bare_metal_shape: str

        :param master_node_host_shape:
            The value to assign to the master_node_host_shape property of this CreateOpensearchClusterDetails.
        :type master_node_host_shape: str

        :param master_node_host_ocpu_count:
            The value to assign to the master_node_host_ocpu_count property of this CreateOpensearchClusterDetails.
        :type master_node_host_ocpu_count: int

        :param master_node_host_memory_gb:
            The value to assign to the master_node_host_memory_gb property of this CreateOpensearchClusterDetails.
        :type master_node_host_memory_gb: int

        :param data_node_count:
            The value to assign to the data_node_count property of this CreateOpensearchClusterDetails.
        :type data_node_count: int

        :param data_node_host_type:
            The value to assign to the data_node_host_type property of this CreateOpensearchClusterDetails.
            Allowed values for this property are: "FLEX", "BM"
        :type data_node_host_type: str

        :param data_node_host_bare_metal_shape:
            The value to assign to the data_node_host_bare_metal_shape property of this CreateOpensearchClusterDetails.
        :type data_node_host_bare_metal_shape: str

        :param data_node_host_shape:
            The value to assign to the data_node_host_shape property of this CreateOpensearchClusterDetails.
        :type data_node_host_shape: str

        :param data_node_host_ocpu_count:
            The value to assign to the data_node_host_ocpu_count property of this CreateOpensearchClusterDetails.
        :type data_node_host_ocpu_count: int

        :param data_node_host_memory_gb:
            The value to assign to the data_node_host_memory_gb property of this CreateOpensearchClusterDetails.
        :type data_node_host_memory_gb: int

        :param data_node_storage_gb:
            The value to assign to the data_node_storage_gb property of this CreateOpensearchClusterDetails.
        :type data_node_storage_gb: int

        :param opendashboard_node_host_shape:
            The value to assign to the opendashboard_node_host_shape property of this CreateOpensearchClusterDetails.
        :type opendashboard_node_host_shape: str

        :param opendashboard_node_count:
            The value to assign to the opendashboard_node_count property of this CreateOpensearchClusterDetails.
        :type opendashboard_node_count: int

        :param opendashboard_node_host_ocpu_count:
            The value to assign to the opendashboard_node_host_ocpu_count property of this CreateOpensearchClusterDetails.
        :type opendashboard_node_host_ocpu_count: int

        :param opendashboard_node_host_memory_gb:
            The value to assign to the opendashboard_node_host_memory_gb property of this CreateOpensearchClusterDetails.
        :type opendashboard_node_host_memory_gb: int

        :param search_node_count:
            The value to assign to the search_node_count property of this CreateOpensearchClusterDetails.
        :type search_node_count: int

        :param search_node_host_type:
            The value to assign to the search_node_host_type property of this CreateOpensearchClusterDetails.
            Allowed values for this property are: "FLEX"
        :type search_node_host_type: str

        :param search_node_host_shape:
            The value to assign to the search_node_host_shape property of this CreateOpensearchClusterDetails.
        :type search_node_host_shape: str

        :param search_node_host_ocpu_count:
            The value to assign to the search_node_host_ocpu_count property of this CreateOpensearchClusterDetails.
        :type search_node_host_ocpu_count: int

        :param search_node_host_memory_gb:
            The value to assign to the search_node_host_memory_gb property of this CreateOpensearchClusterDetails.
        :type search_node_host_memory_gb: int

        :param search_node_storage_gb:
            The value to assign to the search_node_storage_gb property of this CreateOpensearchClusterDetails.
        :type search_node_storage_gb: int

        :param vcn_id:
            The value to assign to the vcn_id property of this CreateOpensearchClusterDetails.
        :type vcn_id: str

        :param subnet_id:
            The value to assign to the subnet_id property of this CreateOpensearchClusterDetails.
        :type subnet_id: str

        :param vcn_compartment_id:
            The value to assign to the vcn_compartment_id property of this CreateOpensearchClusterDetails.
        :type vcn_compartment_id: str

        :param subnet_compartment_id:
            The value to assign to the subnet_compartment_id property of this CreateOpensearchClusterDetails.
        :type subnet_compartment_id: str

        :param security_mode:
            The value to assign to the security_mode property of this CreateOpensearchClusterDetails.
            Allowed values for this property are: "DISABLED", "PERMISSIVE", "ENFORCING"
        :type security_mode: str

        :param security_master_user_name:
            The value to assign to the security_master_user_name property of this CreateOpensearchClusterDetails.
        :type security_master_user_name: str

        :param security_master_user_password_hash:
            The value to assign to the security_master_user_password_hash property of this CreateOpensearchClusterDetails.
        :type security_master_user_password_hash: str

        :param security_saml_config:
            The value to assign to the security_saml_config property of this CreateOpensearchClusterDetails.
        :type security_saml_config: oci.opensearch.models.SecuritySamlConfig

        :param backup_policy:
            The value to assign to the backup_policy property of this CreateOpensearchClusterDetails.
        :type backup_policy: oci.opensearch.models.BackupPolicy

        :param nsg_id:
            The value to assign to the nsg_id property of this CreateOpensearchClusterDetails.
        :type nsg_id: str

        :param reverse_connection_endpoint_customer_ips:
            The value to assign to the reverse_connection_endpoint_customer_ips property of this CreateOpensearchClusterDetails.
        :type reverse_connection_endpoint_customer_ips: list[str]

        :param inbound_cluster_ids:
            The value to assign to the inbound_cluster_ids property of this CreateOpensearchClusterDetails.
        :type inbound_cluster_ids: list[str]

        :param outbound_cluster_config:
            The value to assign to the outbound_cluster_config property of this CreateOpensearchClusterDetails.
        :type outbound_cluster_config: oci.opensearch.models.OutboundClusterConfig

        :param maintenance_details:
            The value to assign to the maintenance_details property of this CreateOpensearchClusterDetails.
        :type maintenance_details: oci.opensearch.models.CreateMaintenanceDetails

        :param certificate_config:
            The value to assign to the certificate_config property of this CreateOpensearchClusterDetails.
        :type certificate_config: oci.opensearch.models.CertificateConfig

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateOpensearchClusterDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateOpensearchClusterDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this CreateOpensearchClusterDetails.
        :type system_tags: dict(str, dict(str, object))

        :param security_attributes:
            The value to assign to the security_attributes property of this CreateOpensearchClusterDetails.
        :type security_attributes: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'compartment_id': 'str',
            'software_version': 'str',
            'master_node_count': 'int',
            'master_node_host_type': 'str',
            'master_node_host_bare_metal_shape': 'str',
            'master_node_host_shape': 'str',
            'master_node_host_ocpu_count': 'int',
            'master_node_host_memory_gb': 'int',
            'data_node_count': 'int',
            'data_node_host_type': 'str',
            'data_node_host_bare_metal_shape': 'str',
            'data_node_host_shape': 'str',
            'data_node_host_ocpu_count': 'int',
            'data_node_host_memory_gb': 'int',
            'data_node_storage_gb': 'int',
            'opendashboard_node_host_shape': 'str',
            'opendashboard_node_count': 'int',
            'opendashboard_node_host_ocpu_count': 'int',
            'opendashboard_node_host_memory_gb': 'int',
            'search_node_count': 'int',
            'search_node_host_type': 'str',
            'search_node_host_shape': 'str',
            'search_node_host_ocpu_count': 'int',
            'search_node_host_memory_gb': 'int',
            'search_node_storage_gb': 'int',
            'vcn_id': 'str',
            'subnet_id': 'str',
            'vcn_compartment_id': 'str',
            'subnet_compartment_id': 'str',
            'security_mode': 'str',
            'security_master_user_name': 'str',
            'security_master_user_password_hash': 'str',
            'security_saml_config': 'SecuritySamlConfig',
            'backup_policy': 'BackupPolicy',
            'nsg_id': 'str',
            'reverse_connection_endpoint_customer_ips': 'list[str]',
            'inbound_cluster_ids': 'list[str]',
            'outbound_cluster_config': 'OutboundClusterConfig',
            'maintenance_details': 'CreateMaintenanceDetails',
            'certificate_config': 'CertificateConfig',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'security_attributes': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'software_version': 'softwareVersion',
            'master_node_count': 'masterNodeCount',
            'master_node_host_type': 'masterNodeHostType',
            'master_node_host_bare_metal_shape': 'masterNodeHostBareMetalShape',
            'master_node_host_shape': 'masterNodeHostShape',
            'master_node_host_ocpu_count': 'masterNodeHostOcpuCount',
            'master_node_host_memory_gb': 'masterNodeHostMemoryGB',
            'data_node_count': 'dataNodeCount',
            'data_node_host_type': 'dataNodeHostType',
            'data_node_host_bare_metal_shape': 'dataNodeHostBareMetalShape',
            'data_node_host_shape': 'dataNodeHostShape',
            'data_node_host_ocpu_count': 'dataNodeHostOcpuCount',
            'data_node_host_memory_gb': 'dataNodeHostMemoryGB',
            'data_node_storage_gb': 'dataNodeStorageGB',
            'opendashboard_node_host_shape': 'opendashboardNodeHostShape',
            'opendashboard_node_count': 'opendashboardNodeCount',
            'opendashboard_node_host_ocpu_count': 'opendashboardNodeHostOcpuCount',
            'opendashboard_node_host_memory_gb': 'opendashboardNodeHostMemoryGB',
            'search_node_count': 'searchNodeCount',
            'search_node_host_type': 'searchNodeHostType',
            'search_node_host_shape': 'searchNodeHostShape',
            'search_node_host_ocpu_count': 'searchNodeHostOcpuCount',
            'search_node_host_memory_gb': 'searchNodeHostMemoryGB',
            'search_node_storage_gb': 'searchNodeStorageGB',
            'vcn_id': 'vcnId',
            'subnet_id': 'subnetId',
            'vcn_compartment_id': 'vcnCompartmentId',
            'subnet_compartment_id': 'subnetCompartmentId',
            'security_mode': 'securityMode',
            'security_master_user_name': 'securityMasterUserName',
            'security_master_user_password_hash': 'securityMasterUserPasswordHash',
            'security_saml_config': 'securitySamlConfig',
            'backup_policy': 'backupPolicy',
            'nsg_id': 'nsgId',
            'reverse_connection_endpoint_customer_ips': 'reverseConnectionEndpointCustomerIps',
            'inbound_cluster_ids': 'inboundClusterIds',
            'outbound_cluster_config': 'outboundClusterConfig',
            'maintenance_details': 'maintenanceDetails',
            'certificate_config': 'certificateConfig',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'security_attributes': 'securityAttributes'
        }
        self._display_name = None
        self._compartment_id = None
        self._software_version = None
        self._master_node_count = None
        self._master_node_host_type = None
        self._master_node_host_bare_metal_shape = None
        self._master_node_host_shape = None
        self._master_node_host_ocpu_count = None
        self._master_node_host_memory_gb = None
        self._data_node_count = None
        self._data_node_host_type = None
        self._data_node_host_bare_metal_shape = None
        self._data_node_host_shape = None
        self._data_node_host_ocpu_count = None
        self._data_node_host_memory_gb = None
        self._data_node_storage_gb = None
        self._opendashboard_node_host_shape = None
        self._opendashboard_node_count = None
        self._opendashboard_node_host_ocpu_count = None
        self._opendashboard_node_host_memory_gb = None
        self._search_node_count = None
        self._search_node_host_type = None
        self._search_node_host_shape = None
        self._search_node_host_ocpu_count = None
        self._search_node_host_memory_gb = None
        self._search_node_storage_gb = None
        self._vcn_id = None
        self._subnet_id = None
        self._vcn_compartment_id = None
        self._subnet_compartment_id = None
        self._security_mode = None
        self._security_master_user_name = None
        self._security_master_user_password_hash = None
        self._security_saml_config = None
        self._backup_policy = None
        self._nsg_id = None
        self._reverse_connection_endpoint_customer_ips = None
        self._inbound_cluster_ids = None
        self._outbound_cluster_config = None
        self._maintenance_details = None
        self._certificate_config = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._security_attributes = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateOpensearchClusterDetails.
        The name of the cluster. Avoid entering confidential information.


        :return: The display_name of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateOpensearchClusterDetails.
        The name of the cluster. Avoid entering confidential information.


        :param display_name: The display_name of this CreateOpensearchClusterDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateOpensearchClusterDetails.
        The OCID of the compartment to create the cluster in.


        :return: The compartment_id of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateOpensearchClusterDetails.
        The OCID of the compartment to create the cluster in.


        :param compartment_id: The compartment_id of this CreateOpensearchClusterDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def software_version(self):
        """
        **[Required]** Gets the software_version of this CreateOpensearchClusterDetails.
        The version of the software the cluster is running.


        :return: The software_version of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._software_version

    @software_version.setter
    def software_version(self, software_version):
        """
        Sets the software_version of this CreateOpensearchClusterDetails.
        The version of the software the cluster is running.


        :param software_version: The software_version of this CreateOpensearchClusterDetails.
        :type: str
        """
        self._software_version = software_version

    @property
    def master_node_count(self):
        """
        **[Required]** Gets the master_node_count of this CreateOpensearchClusterDetails.
        The number of master nodes to configure for the cluster.


        :return: The master_node_count of this CreateOpensearchClusterDetails.
        :rtype: int
        """
        return self._master_node_count

    @master_node_count.setter
    def master_node_count(self, master_node_count):
        """
        Sets the master_node_count of this CreateOpensearchClusterDetails.
        The number of master nodes to configure for the cluster.


        :param master_node_count: The master_node_count of this CreateOpensearchClusterDetails.
        :type: int
        """
        self._master_node_count = master_node_count

    @property
    def master_node_host_type(self):
        """
        **[Required]** Gets the master_node_host_type of this CreateOpensearchClusterDetails.
        The instance type for the cluster's master nodes.

        Allowed values for this property are: "FLEX", "BM"


        :return: The master_node_host_type of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._master_node_host_type

    @master_node_host_type.setter
    def master_node_host_type(self, master_node_host_type):
        """
        Sets the master_node_host_type of this CreateOpensearchClusterDetails.
        The instance type for the cluster's master nodes.


        :param master_node_host_type: The master_node_host_type of this CreateOpensearchClusterDetails.
        :type: str
        """
        allowed_values = ["FLEX", "BM"]
        if not value_allowed_none_or_none_sentinel(master_node_host_type, allowed_values):
            raise ValueError(
                f"Invalid value for `master_node_host_type`, must be None or one of {allowed_values}"
            )
        self._master_node_host_type = master_node_host_type

    @property
    def master_node_host_bare_metal_shape(self):
        """
        Gets the master_node_host_bare_metal_shape of this CreateOpensearchClusterDetails.
        The bare metal shape for the cluster's master nodes.


        :return: The master_node_host_bare_metal_shape of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._master_node_host_bare_metal_shape

    @master_node_host_bare_metal_shape.setter
    def master_node_host_bare_metal_shape(self, master_node_host_bare_metal_shape):
        """
        Sets the master_node_host_bare_metal_shape of this CreateOpensearchClusterDetails.
        The bare metal shape for the cluster's master nodes.


        :param master_node_host_bare_metal_shape: The master_node_host_bare_metal_shape of this CreateOpensearchClusterDetails.
        :type: str
        """
        self._master_node_host_bare_metal_shape = master_node_host_bare_metal_shape

    @property
    def master_node_host_shape(self):
        """
        Gets the master_node_host_shape of this CreateOpensearchClusterDetails.
        The node shape for the cluster's master nodes.


        :return: The master_node_host_shape of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._master_node_host_shape

    @master_node_host_shape.setter
    def master_node_host_shape(self, master_node_host_shape):
        """
        Sets the master_node_host_shape of this CreateOpensearchClusterDetails.
        The node shape for the cluster's master nodes.


        :param master_node_host_shape: The master_node_host_shape of this CreateOpensearchClusterDetails.
        :type: str
        """
        self._master_node_host_shape = master_node_host_shape

    @property
    def master_node_host_ocpu_count(self):
        """
        **[Required]** Gets the master_node_host_ocpu_count of this CreateOpensearchClusterDetails.
        The number of OCPUs to configure for the cluser's master nodes.


        :return: The master_node_host_ocpu_count of this CreateOpensearchClusterDetails.
        :rtype: int
        """
        return self._master_node_host_ocpu_count

    @master_node_host_ocpu_count.setter
    def master_node_host_ocpu_count(self, master_node_host_ocpu_count):
        """
        Sets the master_node_host_ocpu_count of this CreateOpensearchClusterDetails.
        The number of OCPUs to configure for the cluser's master nodes.


        :param master_node_host_ocpu_count: The master_node_host_ocpu_count of this CreateOpensearchClusterDetails.
        :type: int
        """
        self._master_node_host_ocpu_count = master_node_host_ocpu_count

    @property
    def master_node_host_memory_gb(self):
        """
        **[Required]** Gets the master_node_host_memory_gb of this CreateOpensearchClusterDetails.
        The amount of memory in GB, to configure per node for the cluster's master nodes.


        :return: The master_node_host_memory_gb of this CreateOpensearchClusterDetails.
        :rtype: int
        """
        return self._master_node_host_memory_gb

    @master_node_host_memory_gb.setter
    def master_node_host_memory_gb(self, master_node_host_memory_gb):
        """
        Sets the master_node_host_memory_gb of this CreateOpensearchClusterDetails.
        The amount of memory in GB, to configure per node for the cluster's master nodes.


        :param master_node_host_memory_gb: The master_node_host_memory_gb of this CreateOpensearchClusterDetails.
        :type: int
        """
        self._master_node_host_memory_gb = master_node_host_memory_gb

    @property
    def data_node_count(self):
        """
        **[Required]** Gets the data_node_count of this CreateOpensearchClusterDetails.
        The number of data nodes to configure for the cluster.


        :return: The data_node_count of this CreateOpensearchClusterDetails.
        :rtype: int
        """
        return self._data_node_count

    @data_node_count.setter
    def data_node_count(self, data_node_count):
        """
        Sets the data_node_count of this CreateOpensearchClusterDetails.
        The number of data nodes to configure for the cluster.


        :param data_node_count: The data_node_count of this CreateOpensearchClusterDetails.
        :type: int
        """
        self._data_node_count = data_node_count

    @property
    def data_node_host_type(self):
        """
        **[Required]** Gets the data_node_host_type of this CreateOpensearchClusterDetails.
        TThe instance type for the cluster's data nodes.

        Allowed values for this property are: "FLEX", "BM"


        :return: The data_node_host_type of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._data_node_host_type

    @data_node_host_type.setter
    def data_node_host_type(self, data_node_host_type):
        """
        Sets the data_node_host_type of this CreateOpensearchClusterDetails.
        TThe instance type for the cluster's data nodes.


        :param data_node_host_type: The data_node_host_type of this CreateOpensearchClusterDetails.
        :type: str
        """
        allowed_values = ["FLEX", "BM"]
        if not value_allowed_none_or_none_sentinel(data_node_host_type, allowed_values):
            raise ValueError(
                f"Invalid value for `data_node_host_type`, must be None or one of {allowed_values}"
            )
        self._data_node_host_type = data_node_host_type

    @property
    def data_node_host_bare_metal_shape(self):
        """
        Gets the data_node_host_bare_metal_shape of this CreateOpensearchClusterDetails.
        The bare metal shape for the cluster's data nodes.


        :return: The data_node_host_bare_metal_shape of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._data_node_host_bare_metal_shape

    @data_node_host_bare_metal_shape.setter
    def data_node_host_bare_metal_shape(self, data_node_host_bare_metal_shape):
        """
        Sets the data_node_host_bare_metal_shape of this CreateOpensearchClusterDetails.
        The bare metal shape for the cluster's data nodes.


        :param data_node_host_bare_metal_shape: The data_node_host_bare_metal_shape of this CreateOpensearchClusterDetails.
        :type: str
        """
        self._data_node_host_bare_metal_shape = data_node_host_bare_metal_shape

    @property
    def data_node_host_shape(self):
        """
        Gets the data_node_host_shape of this CreateOpensearchClusterDetails.
        The node shape for the cluster's data nodes.


        :return: The data_node_host_shape of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._data_node_host_shape

    @data_node_host_shape.setter
    def data_node_host_shape(self, data_node_host_shape):
        """
        Sets the data_node_host_shape of this CreateOpensearchClusterDetails.
        The node shape for the cluster's data nodes.


        :param data_node_host_shape: The data_node_host_shape of this CreateOpensearchClusterDetails.
        :type: str
        """
        self._data_node_host_shape = data_node_host_shape

    @property
    def data_node_host_ocpu_count(self):
        """
        **[Required]** Gets the data_node_host_ocpu_count of this CreateOpensearchClusterDetails.
        The number of OCPUs to configure for the cluster's data nodes.


        :return: The data_node_host_ocpu_count of this CreateOpensearchClusterDetails.
        :rtype: int
        """
        return self._data_node_host_ocpu_count

    @data_node_host_ocpu_count.setter
    def data_node_host_ocpu_count(self, data_node_host_ocpu_count):
        """
        Sets the data_node_host_ocpu_count of this CreateOpensearchClusterDetails.
        The number of OCPUs to configure for the cluster's data nodes.


        :param data_node_host_ocpu_count: The data_node_host_ocpu_count of this CreateOpensearchClusterDetails.
        :type: int
        """
        self._data_node_host_ocpu_count = data_node_host_ocpu_count

    @property
    def data_node_host_memory_gb(self):
        """
        **[Required]** Gets the data_node_host_memory_gb of this CreateOpensearchClusterDetails.
        The amount of memory in GB, to configure per node for the cluster's data nodes.


        :return: The data_node_host_memory_gb of this CreateOpensearchClusterDetails.
        :rtype: int
        """
        return self._data_node_host_memory_gb

    @data_node_host_memory_gb.setter
    def data_node_host_memory_gb(self, data_node_host_memory_gb):
        """
        Sets the data_node_host_memory_gb of this CreateOpensearchClusterDetails.
        The amount of memory in GB, to configure per node for the cluster's data nodes.


        :param data_node_host_memory_gb: The data_node_host_memory_gb of this CreateOpensearchClusterDetails.
        :type: int
        """
        self._data_node_host_memory_gb = data_node_host_memory_gb

    @property
    def data_node_storage_gb(self):
        """
        **[Required]** Gets the data_node_storage_gb of this CreateOpensearchClusterDetails.
        The amount of storage in GB, to configure per node for the cluster's data nodes.


        :return: The data_node_storage_gb of this CreateOpensearchClusterDetails.
        :rtype: int
        """
        return self._data_node_storage_gb

    @data_node_storage_gb.setter
    def data_node_storage_gb(self, data_node_storage_gb):
        """
        Sets the data_node_storage_gb of this CreateOpensearchClusterDetails.
        The amount of storage in GB, to configure per node for the cluster's data nodes.


        :param data_node_storage_gb: The data_node_storage_gb of this CreateOpensearchClusterDetails.
        :type: int
        """
        self._data_node_storage_gb = data_node_storage_gb

    @property
    def opendashboard_node_host_shape(self):
        """
        Gets the opendashboard_node_host_shape of this CreateOpensearchClusterDetails.
        The node shape for the cluster's OpenSearch Dashboard nodes.


        :return: The opendashboard_node_host_shape of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._opendashboard_node_host_shape

    @opendashboard_node_host_shape.setter
    def opendashboard_node_host_shape(self, opendashboard_node_host_shape):
        """
        Sets the opendashboard_node_host_shape of this CreateOpensearchClusterDetails.
        The node shape for the cluster's OpenSearch Dashboard nodes.


        :param opendashboard_node_host_shape: The opendashboard_node_host_shape of this CreateOpensearchClusterDetails.
        :type: str
        """
        self._opendashboard_node_host_shape = opendashboard_node_host_shape

    @property
    def opendashboard_node_count(self):
        """
        **[Required]** Gets the opendashboard_node_count of this CreateOpensearchClusterDetails.
        The number of OpenSearch Dashboard nodes to configure for the cluster.


        :return: The opendashboard_node_count of this CreateOpensearchClusterDetails.
        :rtype: int
        """
        return self._opendashboard_node_count

    @opendashboard_node_count.setter
    def opendashboard_node_count(self, opendashboard_node_count):
        """
        Sets the opendashboard_node_count of this CreateOpensearchClusterDetails.
        The number of OpenSearch Dashboard nodes to configure for the cluster.


        :param opendashboard_node_count: The opendashboard_node_count of this CreateOpensearchClusterDetails.
        :type: int
        """
        self._opendashboard_node_count = opendashboard_node_count

    @property
    def opendashboard_node_host_ocpu_count(self):
        """
        **[Required]** Gets the opendashboard_node_host_ocpu_count of this CreateOpensearchClusterDetails.
        The number of OCPUs to configure for the cluster's OpenSearch Dashboard nodes.


        :return: The opendashboard_node_host_ocpu_count of this CreateOpensearchClusterDetails.
        :rtype: int
        """
        return self._opendashboard_node_host_ocpu_count

    @opendashboard_node_host_ocpu_count.setter
    def opendashboard_node_host_ocpu_count(self, opendashboard_node_host_ocpu_count):
        """
        Sets the opendashboard_node_host_ocpu_count of this CreateOpensearchClusterDetails.
        The number of OCPUs to configure for the cluster's OpenSearch Dashboard nodes.


        :param opendashboard_node_host_ocpu_count: The opendashboard_node_host_ocpu_count of this CreateOpensearchClusterDetails.
        :type: int
        """
        self._opendashboard_node_host_ocpu_count = opendashboard_node_host_ocpu_count

    @property
    def opendashboard_node_host_memory_gb(self):
        """
        **[Required]** Gets the opendashboard_node_host_memory_gb of this CreateOpensearchClusterDetails.
        The amount of memory in GB, to configure for the cluster's OpenSearch Dashboard nodes.


        :return: The opendashboard_node_host_memory_gb of this CreateOpensearchClusterDetails.
        :rtype: int
        """
        return self._opendashboard_node_host_memory_gb

    @opendashboard_node_host_memory_gb.setter
    def opendashboard_node_host_memory_gb(self, opendashboard_node_host_memory_gb):
        """
        Sets the opendashboard_node_host_memory_gb of this CreateOpensearchClusterDetails.
        The amount of memory in GB, to configure for the cluster's OpenSearch Dashboard nodes.


        :param opendashboard_node_host_memory_gb: The opendashboard_node_host_memory_gb of this CreateOpensearchClusterDetails.
        :type: int
        """
        self._opendashboard_node_host_memory_gb = opendashboard_node_host_memory_gb

    @property
    def search_node_count(self):
        """
        Gets the search_node_count of this CreateOpensearchClusterDetails.
        The number of search nodes configured for the cluster.


        :return: The search_node_count of this CreateOpensearchClusterDetails.
        :rtype: int
        """
        return self._search_node_count

    @search_node_count.setter
    def search_node_count(self, search_node_count):
        """
        Sets the search_node_count of this CreateOpensearchClusterDetails.
        The number of search nodes configured for the cluster.


        :param search_node_count: The search_node_count of this CreateOpensearchClusterDetails.
        :type: int
        """
        self._search_node_count = search_node_count

    @property
    def search_node_host_type(self):
        """
        Gets the search_node_host_type of this CreateOpensearchClusterDetails.
        The instance type for the cluster's search nodes.

        Allowed values for this property are: "FLEX"


        :return: The search_node_host_type of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._search_node_host_type

    @search_node_host_type.setter
    def search_node_host_type(self, search_node_host_type):
        """
        Sets the search_node_host_type of this CreateOpensearchClusterDetails.
        The instance type for the cluster's search nodes.


        :param search_node_host_type: The search_node_host_type of this CreateOpensearchClusterDetails.
        :type: str
        """
        allowed_values = ["FLEX"]
        if not value_allowed_none_or_none_sentinel(search_node_host_type, allowed_values):
            raise ValueError(
                f"Invalid value for `search_node_host_type`, must be None or one of {allowed_values}"
            )
        self._search_node_host_type = search_node_host_type

    @property
    def search_node_host_shape(self):
        """
        Gets the search_node_host_shape of this CreateOpensearchClusterDetails.
        The node shape for the cluster's search nodes.


        :return: The search_node_host_shape of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._search_node_host_shape

    @search_node_host_shape.setter
    def search_node_host_shape(self, search_node_host_shape):
        """
        Sets the search_node_host_shape of this CreateOpensearchClusterDetails.
        The node shape for the cluster's search nodes.


        :param search_node_host_shape: The search_node_host_shape of this CreateOpensearchClusterDetails.
        :type: str
        """
        self._search_node_host_shape = search_node_host_shape

    @property
    def search_node_host_ocpu_count(self):
        """
        Gets the search_node_host_ocpu_count of this CreateOpensearchClusterDetails.
        The number of OCPUs configured for the cluster's search nodes.


        :return: The search_node_host_ocpu_count of this CreateOpensearchClusterDetails.
        :rtype: int
        """
        return self._search_node_host_ocpu_count

    @search_node_host_ocpu_count.setter
    def search_node_host_ocpu_count(self, search_node_host_ocpu_count):
        """
        Sets the search_node_host_ocpu_count of this CreateOpensearchClusterDetails.
        The number of OCPUs configured for the cluster's search nodes.


        :param search_node_host_ocpu_count: The search_node_host_ocpu_count of this CreateOpensearchClusterDetails.
        :type: int
        """
        self._search_node_host_ocpu_count = search_node_host_ocpu_count

    @property
    def search_node_host_memory_gb(self):
        """
        Gets the search_node_host_memory_gb of this CreateOpensearchClusterDetails.
        The amount of memory in GB, for the cluster's search nodes.


        :return: The search_node_host_memory_gb of this CreateOpensearchClusterDetails.
        :rtype: int
        """
        return self._search_node_host_memory_gb

    @search_node_host_memory_gb.setter
    def search_node_host_memory_gb(self, search_node_host_memory_gb):
        """
        Sets the search_node_host_memory_gb of this CreateOpensearchClusterDetails.
        The amount of memory in GB, for the cluster's search nodes.


        :param search_node_host_memory_gb: The search_node_host_memory_gb of this CreateOpensearchClusterDetails.
        :type: int
        """
        self._search_node_host_memory_gb = search_node_host_memory_gb

    @property
    def search_node_storage_gb(self):
        """
        Gets the search_node_storage_gb of this CreateOpensearchClusterDetails.
        The amount of storage in GB, to configure per node for the cluster's search nodes.


        :return: The search_node_storage_gb of this CreateOpensearchClusterDetails.
        :rtype: int
        """
        return self._search_node_storage_gb

    @search_node_storage_gb.setter
    def search_node_storage_gb(self, search_node_storage_gb):
        """
        Sets the search_node_storage_gb of this CreateOpensearchClusterDetails.
        The amount of storage in GB, to configure per node for the cluster's search nodes.


        :param search_node_storage_gb: The search_node_storage_gb of this CreateOpensearchClusterDetails.
        :type: int
        """
        self._search_node_storage_gb = search_node_storage_gb

    @property
    def vcn_id(self):
        """
        **[Required]** Gets the vcn_id of this CreateOpensearchClusterDetails.
        The OCID of the cluster's VCN.


        :return: The vcn_id of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._vcn_id

    @vcn_id.setter
    def vcn_id(self, vcn_id):
        """
        Sets the vcn_id of this CreateOpensearchClusterDetails.
        The OCID of the cluster's VCN.


        :param vcn_id: The vcn_id of this CreateOpensearchClusterDetails.
        :type: str
        """
        self._vcn_id = vcn_id

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this CreateOpensearchClusterDetails.
        The OCID of the cluster's subnet.


        :return: The subnet_id of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreateOpensearchClusterDetails.
        The OCID of the cluster's subnet.


        :param subnet_id: The subnet_id of this CreateOpensearchClusterDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def vcn_compartment_id(self):
        """
        **[Required]** Gets the vcn_compartment_id of this CreateOpensearchClusterDetails.
        The OCID for the compartment where the cluster's VCN is located.


        :return: The vcn_compartment_id of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._vcn_compartment_id

    @vcn_compartment_id.setter
    def vcn_compartment_id(self, vcn_compartment_id):
        """
        Sets the vcn_compartment_id of this CreateOpensearchClusterDetails.
        The OCID for the compartment where the cluster's VCN is located.


        :param vcn_compartment_id: The vcn_compartment_id of this CreateOpensearchClusterDetails.
        :type: str
        """
        self._vcn_compartment_id = vcn_compartment_id

    @property
    def subnet_compartment_id(self):
        """
        **[Required]** Gets the subnet_compartment_id of this CreateOpensearchClusterDetails.
        The OCID for the compartment where the cluster's subnet is located.


        :return: The subnet_compartment_id of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._subnet_compartment_id

    @subnet_compartment_id.setter
    def subnet_compartment_id(self, subnet_compartment_id):
        """
        Sets the subnet_compartment_id of this CreateOpensearchClusterDetails.
        The OCID for the compartment where the cluster's subnet is located.


        :param subnet_compartment_id: The subnet_compartment_id of this CreateOpensearchClusterDetails.
        :type: str
        """
        self._subnet_compartment_id = subnet_compartment_id

    @property
    def security_mode(self):
        """
        Gets the security_mode of this CreateOpensearchClusterDetails.
        The security mode of the cluster.

        Allowed values for this property are: "DISABLED", "PERMISSIVE", "ENFORCING"


        :return: The security_mode of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._security_mode

    @security_mode.setter
    def security_mode(self, security_mode):
        """
        Sets the security_mode of this CreateOpensearchClusterDetails.
        The security mode of the cluster.


        :param security_mode: The security_mode of this CreateOpensearchClusterDetails.
        :type: str
        """
        allowed_values = ["DISABLED", "PERMISSIVE", "ENFORCING"]
        if not value_allowed_none_or_none_sentinel(security_mode, allowed_values):
            raise ValueError(
                f"Invalid value for `security_mode`, must be None or one of {allowed_values}"
            )
        self._security_mode = security_mode

    @property
    def security_master_user_name(self):
        """
        Gets the security_master_user_name of this CreateOpensearchClusterDetails.
        The name of the master user that are used to manage security config


        :return: The security_master_user_name of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._security_master_user_name

    @security_master_user_name.setter
    def security_master_user_name(self, security_master_user_name):
        """
        Sets the security_master_user_name of this CreateOpensearchClusterDetails.
        The name of the master user that are used to manage security config


        :param security_master_user_name: The security_master_user_name of this CreateOpensearchClusterDetails.
        :type: str
        """
        self._security_master_user_name = security_master_user_name

    @property
    def security_master_user_password_hash(self):
        """
        Gets the security_master_user_password_hash of this CreateOpensearchClusterDetails.
        The password hash of the master user that are used to manage security config


        :return: The security_master_user_password_hash of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._security_master_user_password_hash

    @security_master_user_password_hash.setter
    def security_master_user_password_hash(self, security_master_user_password_hash):
        """
        Sets the security_master_user_password_hash of this CreateOpensearchClusterDetails.
        The password hash of the master user that are used to manage security config


        :param security_master_user_password_hash: The security_master_user_password_hash of this CreateOpensearchClusterDetails.
        :type: str
        """
        self._security_master_user_password_hash = security_master_user_password_hash

    @property
    def security_saml_config(self):
        """
        Gets the security_saml_config of this CreateOpensearchClusterDetails.

        :return: The security_saml_config of this CreateOpensearchClusterDetails.
        :rtype: oci.opensearch.models.SecuritySamlConfig
        """
        return self._security_saml_config

    @security_saml_config.setter
    def security_saml_config(self, security_saml_config):
        """
        Sets the security_saml_config of this CreateOpensearchClusterDetails.

        :param security_saml_config: The security_saml_config of this CreateOpensearchClusterDetails.
        :type: oci.opensearch.models.SecuritySamlConfig
        """
        self._security_saml_config = security_saml_config

    @property
    def backup_policy(self):
        """
        Gets the backup_policy of this CreateOpensearchClusterDetails.

        :return: The backup_policy of this CreateOpensearchClusterDetails.
        :rtype: oci.opensearch.models.BackupPolicy
        """
        return self._backup_policy

    @backup_policy.setter
    def backup_policy(self, backup_policy):
        """
        Sets the backup_policy of this CreateOpensearchClusterDetails.

        :param backup_policy: The backup_policy of this CreateOpensearchClusterDetails.
        :type: oci.opensearch.models.BackupPolicy
        """
        self._backup_policy = backup_policy

    @property
    def nsg_id(self):
        """
        Gets the nsg_id of this CreateOpensearchClusterDetails.
        The OCID of the NSG where the private endpoint vnic will be attached.


        :return: The nsg_id of this CreateOpensearchClusterDetails.
        :rtype: str
        """
        return self._nsg_id

    @nsg_id.setter
    def nsg_id(self, nsg_id):
        """
        Sets the nsg_id of this CreateOpensearchClusterDetails.
        The OCID of the NSG where the private endpoint vnic will be attached.


        :param nsg_id: The nsg_id of this CreateOpensearchClusterDetails.
        :type: str
        """
        self._nsg_id = nsg_id

    @property
    def reverse_connection_endpoint_customer_ips(self):
        """
        Gets the reverse_connection_endpoint_customer_ips of this CreateOpensearchClusterDetails.
        The customer IP addresses of the endpoint in customer VCN


        :return: The reverse_connection_endpoint_customer_ips of this CreateOpensearchClusterDetails.
        :rtype: list[str]
        """
        return self._reverse_connection_endpoint_customer_ips

    @reverse_connection_endpoint_customer_ips.setter
    def reverse_connection_endpoint_customer_ips(self, reverse_connection_endpoint_customer_ips):
        """
        Sets the reverse_connection_endpoint_customer_ips of this CreateOpensearchClusterDetails.
        The customer IP addresses of the endpoint in customer VCN


        :param reverse_connection_endpoint_customer_ips: The reverse_connection_endpoint_customer_ips of this CreateOpensearchClusterDetails.
        :type: list[str]
        """
        self._reverse_connection_endpoint_customer_ips = reverse_connection_endpoint_customer_ips

    @property
    def inbound_cluster_ids(self):
        """
        Gets the inbound_cluster_ids of this CreateOpensearchClusterDetails.
        List of inbound clusters that will be queried using cross cluster search


        :return: The inbound_cluster_ids of this CreateOpensearchClusterDetails.
        :rtype: list[str]
        """
        return self._inbound_cluster_ids

    @inbound_cluster_ids.setter
    def inbound_cluster_ids(self, inbound_cluster_ids):
        """
        Sets the inbound_cluster_ids of this CreateOpensearchClusterDetails.
        List of inbound clusters that will be queried using cross cluster search


        :param inbound_cluster_ids: The inbound_cluster_ids of this CreateOpensearchClusterDetails.
        :type: list[str]
        """
        self._inbound_cluster_ids = inbound_cluster_ids

    @property
    def outbound_cluster_config(self):
        """
        Gets the outbound_cluster_config of this CreateOpensearchClusterDetails.

        :return: The outbound_cluster_config of this CreateOpensearchClusterDetails.
        :rtype: oci.opensearch.models.OutboundClusterConfig
        """
        return self._outbound_cluster_config

    @outbound_cluster_config.setter
    def outbound_cluster_config(self, outbound_cluster_config):
        """
        Sets the outbound_cluster_config of this CreateOpensearchClusterDetails.

        :param outbound_cluster_config: The outbound_cluster_config of this CreateOpensearchClusterDetails.
        :type: oci.opensearch.models.OutboundClusterConfig
        """
        self._outbound_cluster_config = outbound_cluster_config

    @property
    def maintenance_details(self):
        """
        Gets the maintenance_details of this CreateOpensearchClusterDetails.

        :return: The maintenance_details of this CreateOpensearchClusterDetails.
        :rtype: oci.opensearch.models.CreateMaintenanceDetails
        """
        return self._maintenance_details

    @maintenance_details.setter
    def maintenance_details(self, maintenance_details):
        """
        Sets the maintenance_details of this CreateOpensearchClusterDetails.

        :param maintenance_details: The maintenance_details of this CreateOpensearchClusterDetails.
        :type: oci.opensearch.models.CreateMaintenanceDetails
        """
        self._maintenance_details = maintenance_details

    @property
    def certificate_config(self):
        """
        Gets the certificate_config of this CreateOpensearchClusterDetails.

        :return: The certificate_config of this CreateOpensearchClusterDetails.
        :rtype: oci.opensearch.models.CertificateConfig
        """
        return self._certificate_config

    @certificate_config.setter
    def certificate_config(self, certificate_config):
        """
        Sets the certificate_config of this CreateOpensearchClusterDetails.

        :param certificate_config: The certificate_config of this CreateOpensearchClusterDetails.
        :type: oci.opensearch.models.CertificateConfig
        """
        self._certificate_config = certificate_config

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateOpensearchClusterDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateOpensearchClusterDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateOpensearchClusterDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateOpensearchClusterDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateOpensearchClusterDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateOpensearchClusterDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateOpensearchClusterDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateOpensearchClusterDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this CreateOpensearchClusterDetails.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this CreateOpensearchClusterDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this CreateOpensearchClusterDetails.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this CreateOpensearchClusterDetails.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def security_attributes(self):
        """
        Gets the security_attributes of this CreateOpensearchClusterDetails.
        Security attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"enforce\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The security_attributes of this CreateOpensearchClusterDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._security_attributes

    @security_attributes.setter
    def security_attributes(self, security_attributes):
        """
        Sets the security_attributes of this CreateOpensearchClusterDetails.
        Security attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"enforce\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param security_attributes: The security_attributes of this CreateOpensearchClusterDetails.
        :type: dict(str, dict(str, object))
        """
        self._security_attributes = security_attributes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
