# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateAwrHubSourceDetails(object):
    """
    payload to register Awr Hub source
    """

    #: A constant which can be used with the type property of a CreateAwrHubSourceDetails.
    #: This constant has a value of "ADW_S"
    TYPE_ADW_S = "ADW_S"

    #: A constant which can be used with the type property of a CreateAwrHubSourceDetails.
    #: This constant has a value of "ATP_S"
    TYPE_ATP_S = "ATP_S"

    #: A constant which can be used with the type property of a CreateAwrHubSourceDetails.
    #: This constant has a value of "ADW_D"
    TYPE_ADW_D = "ADW_D"

    #: A constant which can be used with the type property of a CreateAwrHubSourceDetails.
    #: This constant has a value of "ATP_D"
    TYPE_ATP_D = "ATP_D"

    #: A constant which can be used with the type property of a CreateAwrHubSourceDetails.
    #: This constant has a value of "EXTERNAL_PDB"
    TYPE_EXTERNAL_PDB = "EXTERNAL_PDB"

    #: A constant which can be used with the type property of a CreateAwrHubSourceDetails.
    #: This constant has a value of "EXTERNAL_NONCDB"
    TYPE_EXTERNAL_NONCDB = "EXTERNAL_NONCDB"

    #: A constant which can be used with the type property of a CreateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_VM_CDB"
    TYPE_COMANAGED_VM_CDB = "COMANAGED_VM_CDB"

    #: A constant which can be used with the type property of a CreateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_VM_PDB"
    TYPE_COMANAGED_VM_PDB = "COMANAGED_VM_PDB"

    #: A constant which can be used with the type property of a CreateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_VM_NONCDB"
    TYPE_COMANAGED_VM_NONCDB = "COMANAGED_VM_NONCDB"

    #: A constant which can be used with the type property of a CreateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_BM_CDB"
    TYPE_COMANAGED_BM_CDB = "COMANAGED_BM_CDB"

    #: A constant which can be used with the type property of a CreateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_BM_PDB"
    TYPE_COMANAGED_BM_PDB = "COMANAGED_BM_PDB"

    #: A constant which can be used with the type property of a CreateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_BM_NONCDB"
    TYPE_COMANAGED_BM_NONCDB = "COMANAGED_BM_NONCDB"

    #: A constant which can be used with the type property of a CreateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_EXACS_CDB"
    TYPE_COMANAGED_EXACS_CDB = "COMANAGED_EXACS_CDB"

    #: A constant which can be used with the type property of a CreateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_EXACS_PDB"
    TYPE_COMANAGED_EXACS_PDB = "COMANAGED_EXACS_PDB"

    #: A constant which can be used with the type property of a CreateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_EXACS_NONCDB"
    TYPE_COMANAGED_EXACS_NONCDB = "COMANAGED_EXACS_NONCDB"

    #: A constant which can be used with the type property of a CreateAwrHubSourceDetails.
    #: This constant has a value of "UNDEFINED"
    TYPE_UNDEFINED = "UNDEFINED"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateAwrHubSourceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CreateAwrHubSourceDetails.
        :type name: str

        :param awr_hub_id:
            The value to assign to the awr_hub_id property of this CreateAwrHubSourceDetails.
        :type awr_hub_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateAwrHubSourceDetails.
        :type compartment_id: str

        :param associated_resource_id:
            The value to assign to the associated_resource_id property of this CreateAwrHubSourceDetails.
        :type associated_resource_id: str

        :param associated_opsi_id:
            The value to assign to the associated_opsi_id property of this CreateAwrHubSourceDetails.
        :type associated_opsi_id: str

        :param type:
            The value to assign to the type property of this CreateAwrHubSourceDetails.
            Allowed values for this property are: "ADW_S", "ATP_S", "ADW_D", "ATP_D", "EXTERNAL_PDB", "EXTERNAL_NONCDB", "COMANAGED_VM_CDB", "COMANAGED_VM_PDB", "COMANAGED_VM_NONCDB", "COMANAGED_BM_CDB", "COMANAGED_BM_PDB", "COMANAGED_BM_NONCDB", "COMANAGED_EXACS_CDB", "COMANAGED_EXACS_PDB", "COMANAGED_EXACS_NONCDB", "UNDEFINED"
        :type type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateAwrHubSourceDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateAwrHubSourceDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'name': 'str',
            'awr_hub_id': 'str',
            'compartment_id': 'str',
            'associated_resource_id': 'str',
            'associated_opsi_id': 'str',
            'type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'name': 'name',
            'awr_hub_id': 'awrHubId',
            'compartment_id': 'compartmentId',
            'associated_resource_id': 'associatedResourceId',
            'associated_opsi_id': 'associatedOpsiId',
            'type': 'type',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._name = None
        self._awr_hub_id = None
        self._compartment_id = None
        self._associated_resource_id = None
        self._associated_opsi_id = None
        self._type = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateAwrHubSourceDetails.
        The name of the Awr Hub source database.


        :return: The name of this CreateAwrHubSourceDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateAwrHubSourceDetails.
        The name of the Awr Hub source database.


        :param name: The name of this CreateAwrHubSourceDetails.
        :type: str
        """
        self._name = name

    @property
    def awr_hub_id(self):
        """
        **[Required]** Gets the awr_hub_id of this CreateAwrHubSourceDetails.
        AWR Hub OCID


        :return: The awr_hub_id of this CreateAwrHubSourceDetails.
        :rtype: str
        """
        return self._awr_hub_id

    @awr_hub_id.setter
    def awr_hub_id(self, awr_hub_id):
        """
        Sets the awr_hub_id of this CreateAwrHubSourceDetails.
        AWR Hub OCID


        :param awr_hub_id: The awr_hub_id of this CreateAwrHubSourceDetails.
        :type: str
        """
        self._awr_hub_id = awr_hub_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateAwrHubSourceDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateAwrHubSourceDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateAwrHubSourceDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateAwrHubSourceDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def associated_resource_id(self):
        """
        Gets the associated_resource_id of this CreateAwrHubSourceDetails.
        The `OCID`__ of the database id.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The associated_resource_id of this CreateAwrHubSourceDetails.
        :rtype: str
        """
        return self._associated_resource_id

    @associated_resource_id.setter
    def associated_resource_id(self, associated_resource_id):
        """
        Sets the associated_resource_id of this CreateAwrHubSourceDetails.
        The `OCID`__ of the database id.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param associated_resource_id: The associated_resource_id of this CreateAwrHubSourceDetails.
        :type: str
        """
        self._associated_resource_id = associated_resource_id

    @property
    def associated_opsi_id(self):
        """
        Gets the associated_opsi_id of this CreateAwrHubSourceDetails.
        The `OCID`__ of the database id.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The associated_opsi_id of this CreateAwrHubSourceDetails.
        :rtype: str
        """
        return self._associated_opsi_id

    @associated_opsi_id.setter
    def associated_opsi_id(self, associated_opsi_id):
        """
        Sets the associated_opsi_id of this CreateAwrHubSourceDetails.
        The `OCID`__ of the database id.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param associated_opsi_id: The associated_opsi_id of this CreateAwrHubSourceDetails.
        :type: str
        """
        self._associated_opsi_id = associated_opsi_id

    @property
    def type(self):
        """
        **[Required]** Gets the type of this CreateAwrHubSourceDetails.
        source type of the database

        Allowed values for this property are: "ADW_S", "ATP_S", "ADW_D", "ATP_D", "EXTERNAL_PDB", "EXTERNAL_NONCDB", "COMANAGED_VM_CDB", "COMANAGED_VM_PDB", "COMANAGED_VM_NONCDB", "COMANAGED_BM_CDB", "COMANAGED_BM_PDB", "COMANAGED_BM_NONCDB", "COMANAGED_EXACS_CDB", "COMANAGED_EXACS_PDB", "COMANAGED_EXACS_NONCDB", "UNDEFINED"


        :return: The type of this CreateAwrHubSourceDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CreateAwrHubSourceDetails.
        source type of the database


        :param type: The type of this CreateAwrHubSourceDetails.
        :type: str
        """
        allowed_values = ["ADW_S", "ATP_S", "ADW_D", "ATP_D", "EXTERNAL_PDB", "EXTERNAL_NONCDB", "COMANAGED_VM_CDB", "COMANAGED_VM_PDB", "COMANAGED_VM_NONCDB", "COMANAGED_BM_CDB", "COMANAGED_BM_PDB", "COMANAGED_BM_NONCDB", "COMANAGED_EXACS_CDB", "COMANAGED_EXACS_PDB", "COMANAGED_EXACS_NONCDB", "UNDEFINED"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateAwrHubSourceDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateAwrHubSourceDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateAwrHubSourceDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateAwrHubSourceDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateAwrHubSourceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateAwrHubSourceDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateAwrHubSourceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateAwrHubSourceDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
