# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateMacsManagedCloudExadataClusterDetails(object):
    """
    The information of the VM Cluster which contains databases.
    """

    #: A constant which can be used with the vm_cluster_type property of a CreateMacsManagedCloudExadataClusterDetails.
    #: This constant has a value of "vmCluster"
    VM_CLUSTER_TYPE_VM_CLUSTER = "vmCluster"

    #: A constant which can be used with the vm_cluster_type property of a CreateMacsManagedCloudExadataClusterDetails.
    #: This constant has a value of "autonomousVmCluster"
    VM_CLUSTER_TYPE_AUTONOMOUS_VM_CLUSTER = "autonomousVmCluster"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateMacsManagedCloudExadataClusterDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.opsi.models.CreateMacsManagedCloudExadataVmclusterDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vm_cluster_type:
            The value to assign to the vm_cluster_type property of this CreateMacsManagedCloudExadataClusterDetails.
            Allowed values for this property are: "vmCluster", "autonomousVmCluster"
        :type vm_cluster_type: str

        :param vmcluster_id:
            The value to assign to the vmcluster_id property of this CreateMacsManagedCloudExadataClusterDetails.
        :type vmcluster_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateMacsManagedCloudExadataClusterDetails.
        :type compartment_id: str

        """
        self.swagger_types = {
            'vm_cluster_type': 'str',
            'vmcluster_id': 'str',
            'compartment_id': 'str'
        }
        self.attribute_map = {
            'vm_cluster_type': 'vmClusterType',
            'vmcluster_id': 'vmclusterId',
            'compartment_id': 'compartmentId'
        }
        self._vm_cluster_type = None
        self._vmcluster_id = None
        self._compartment_id = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['vmClusterType']

        if type == 'vmCluster':
            return 'CreateMacsManagedCloudExadataVmclusterDetails'
        else:
            return 'CreateMacsManagedCloudExadataClusterDetails'

    @property
    def vm_cluster_type(self):
        """
        Gets the vm_cluster_type of this CreateMacsManagedCloudExadataClusterDetails.
        Exadata VMCluster type

        Allowed values for this property are: "vmCluster", "autonomousVmCluster"


        :return: The vm_cluster_type of this CreateMacsManagedCloudExadataClusterDetails.
        :rtype: str
        """
        return self._vm_cluster_type

    @vm_cluster_type.setter
    def vm_cluster_type(self, vm_cluster_type):
        """
        Sets the vm_cluster_type of this CreateMacsManagedCloudExadataClusterDetails.
        Exadata VMCluster type


        :param vm_cluster_type: The vm_cluster_type of this CreateMacsManagedCloudExadataClusterDetails.
        :type: str
        """
        allowed_values = ["vmCluster", "autonomousVmCluster"]
        if not value_allowed_none_or_none_sentinel(vm_cluster_type, allowed_values):
            raise ValueError(
                f"Invalid value for `vm_cluster_type`, must be None or one of {allowed_values}"
            )
        self._vm_cluster_type = vm_cluster_type

    @property
    def vmcluster_id(self):
        """
        **[Required]** Gets the vmcluster_id of this CreateMacsManagedCloudExadataClusterDetails.
        The `OCID`__ of the VM Cluster.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The vmcluster_id of this CreateMacsManagedCloudExadataClusterDetails.
        :rtype: str
        """
        return self._vmcluster_id

    @vmcluster_id.setter
    def vmcluster_id(self, vmcluster_id):
        """
        Sets the vmcluster_id of this CreateMacsManagedCloudExadataClusterDetails.
        The `OCID`__ of the VM Cluster.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param vmcluster_id: The vmcluster_id of this CreateMacsManagedCloudExadataClusterDetails.
        :type: str
        """
        self._vmcluster_id = vmcluster_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateMacsManagedCloudExadataClusterDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateMacsManagedCloudExadataClusterDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateMacsManagedCloudExadataClusterDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateMacsManagedCloudExadataClusterDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
