# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220315


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateOciCacheConfigSetDetails(object):
    """
    The information to create a new OCI Cache Config Set.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateOciCacheConfigSetDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateOciCacheConfigSetDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateOciCacheConfigSetDetails.
        :type compartment_id: str

        :param description:
            The value to assign to the description property of this CreateOciCacheConfigSetDetails.
        :type description: str

        :param software_version:
            The value to assign to the software_version property of this CreateOciCacheConfigSetDetails.
        :type software_version: str

        :param configuration_details:
            The value to assign to the configuration_details property of this CreateOciCacheConfigSetDetails.
        :type configuration_details: oci.redis.models.ConfigurationDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateOciCacheConfigSetDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateOciCacheConfigSetDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'compartment_id': 'str',
            'description': 'str',
            'software_version': 'str',
            'configuration_details': 'ConfigurationDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'description': 'description',
            'software_version': 'softwareVersion',
            'configuration_details': 'configurationDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._compartment_id = None
        self._description = None
        self._software_version = None
        self._configuration_details = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateOciCacheConfigSetDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this CreateOciCacheConfigSetDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateOciCacheConfigSetDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this CreateOciCacheConfigSetDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateOciCacheConfigSetDetails.
        The `OCID`__ of the compartment that contains the OCI Cache Config Set.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :return: The compartment_id of this CreateOciCacheConfigSetDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateOciCacheConfigSetDetails.
        The `OCID`__ of the compartment that contains the OCI Cache Config Set.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :param compartment_id: The compartment_id of this CreateOciCacheConfigSetDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def description(self):
        """
        Gets the description of this CreateOciCacheConfigSetDetails.
        Description for the custom OCI Cache Config Set.


        :return: The description of this CreateOciCacheConfigSetDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateOciCacheConfigSetDetails.
        Description for the custom OCI Cache Config Set.


        :param description: The description of this CreateOciCacheConfigSetDetails.
        :type: str
        """
        self._description = description

    @property
    def software_version(self):
        """
        **[Required]** Gets the software_version of this CreateOciCacheConfigSetDetails.
        The OCI Cache engine version that the cluster is running.


        :return: The software_version of this CreateOciCacheConfigSetDetails.
        :rtype: str
        """
        return self._software_version

    @software_version.setter
    def software_version(self, software_version):
        """
        Sets the software_version of this CreateOciCacheConfigSetDetails.
        The OCI Cache engine version that the cluster is running.


        :param software_version: The software_version of this CreateOciCacheConfigSetDetails.
        :type: str
        """
        self._software_version = software_version

    @property
    def configuration_details(self):
        """
        **[Required]** Gets the configuration_details of this CreateOciCacheConfigSetDetails.

        :return: The configuration_details of this CreateOciCacheConfigSetDetails.
        :rtype: oci.redis.models.ConfigurationDetails
        """
        return self._configuration_details

    @configuration_details.setter
    def configuration_details(self, configuration_details):
        """
        Sets the configuration_details of this CreateOciCacheConfigSetDetails.

        :param configuration_details: The configuration_details of this CreateOciCacheConfigSetDetails.
        :type: oci.redis.models.ConfigurationDetails
        """
        self._configuration_details = configuration_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateOciCacheConfigSetDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateOciCacheConfigSetDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateOciCacheConfigSetDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateOciCacheConfigSetDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateOciCacheConfigSetDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateOciCacheConfigSetDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateOciCacheConfigSetDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateOciCacheConfigSetDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
