# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330

from .maintenance_window_schedule import MaintenanceWindowSchedule
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OneTimeMaintenanceWindowSchedule(MaintenanceWindowSchedule):
    """
    Schedule information for the Maintenance Window that is executed only once.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OneTimeMaintenanceWindowSchedule object with values from keyword arguments. The default value of the :py:attr:`~oci.stack_monitoring.models.OneTimeMaintenanceWindowSchedule.schedule_type` attribute
        of this class is ``ONE_TIME`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param schedule_type:
            The value to assign to the schedule_type property of this OneTimeMaintenanceWindowSchedule.
            Allowed values for this property are: "ONE_TIME", "RECURRENT"
        :type schedule_type: str

        :param time_maintenance_window_start:
            The value to assign to the time_maintenance_window_start property of this OneTimeMaintenanceWindowSchedule.
        :type time_maintenance_window_start: datetime

        :param time_maintenance_window_end:
            The value to assign to the time_maintenance_window_end property of this OneTimeMaintenanceWindowSchedule.
        :type time_maintenance_window_end: datetime

        """
        self.swagger_types = {
            'schedule_type': 'str',
            'time_maintenance_window_start': 'datetime',
            'time_maintenance_window_end': 'datetime'
        }
        self.attribute_map = {
            'schedule_type': 'scheduleType',
            'time_maintenance_window_start': 'timeMaintenanceWindowStart',
            'time_maintenance_window_end': 'timeMaintenanceWindowEnd'
        }
        self._schedule_type = None
        self._time_maintenance_window_start = None
        self._time_maintenance_window_end = None
        self._schedule_type = 'ONE_TIME'

    @property
    def time_maintenance_window_start(self):
        """
        Gets the time_maintenance_window_start of this OneTimeMaintenanceWindowSchedule.
        Start time of Maintenance window. A RFC3339 formatted datetime string


        :return: The time_maintenance_window_start of this OneTimeMaintenanceWindowSchedule.
        :rtype: datetime
        """
        return self._time_maintenance_window_start

    @time_maintenance_window_start.setter
    def time_maintenance_window_start(self, time_maintenance_window_start):
        """
        Sets the time_maintenance_window_start of this OneTimeMaintenanceWindowSchedule.
        Start time of Maintenance window. A RFC3339 formatted datetime string


        :param time_maintenance_window_start: The time_maintenance_window_start of this OneTimeMaintenanceWindowSchedule.
        :type: datetime
        """
        self._time_maintenance_window_start = time_maintenance_window_start

    @property
    def time_maintenance_window_end(self):
        """
        Gets the time_maintenance_window_end of this OneTimeMaintenanceWindowSchedule.
        Start time of Maintenance window. A RFC3339 formatted datetime string


        :return: The time_maintenance_window_end of this OneTimeMaintenanceWindowSchedule.
        :rtype: datetime
        """
        return self._time_maintenance_window_end

    @time_maintenance_window_end.setter
    def time_maintenance_window_end(self, time_maintenance_window_end):
        """
        Sets the time_maintenance_window_end of this OneTimeMaintenanceWindowSchedule.
        Start time of Maintenance window. A RFC3339 formatted datetime string


        :param time_maintenance_window_end: The time_maintenance_window_end of this OneTimeMaintenanceWindowSchedule.
        :type: datetime
        """
        self._time_maintenance_window_end = time_maintenance_window_end

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
