# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .drg_attachment_network_details import DrgAttachmentNetworkDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FlexTunnelDrgAttachmentNetworkDetails(DrgAttachmentNetworkDetails):
    """
    Specifies the flex tunnel attached to the DRG.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FlexTunnelDrgAttachmentNetworkDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.vn_monitoring.models.FlexTunnelDrgAttachmentNetworkDetails.type` attribute
        of this class is ``FLEX_TUNNEL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this FlexTunnelDrgAttachmentNetworkDetails.
            Allowed values for this property are: "VCN", "IPSEC_TUNNEL", "VIRTUAL_CIRCUIT", "REMOTE_PEERING_CONNECTION", "FLEX_TUNNEL", "LOOPBACK", "INTERNET"
        :type type: str

        :param id:
            The value to assign to the id property of this FlexTunnelDrgAttachmentNetworkDetails.
        :type id: str

        :param transport_attachment_id:
            The value to assign to the transport_attachment_id property of this FlexTunnelDrgAttachmentNetworkDetails.
        :type transport_attachment_id: str

        :param regional_oci_asn:
            The value to assign to the regional_oci_asn property of this FlexTunnelDrgAttachmentNetworkDetails.
        :type regional_oci_asn: str

        :param import_route_target:
            The value to assign to the import_route_target property of this FlexTunnelDrgAttachmentNetworkDetails.
        :type import_route_target: str

        :param export_route_target:
            The value to assign to the export_route_target property of this FlexTunnelDrgAttachmentNetworkDetails.
        :type export_route_target: str

        :param mpls_label:
            The value to assign to the mpls_label property of this FlexTunnelDrgAttachmentNetworkDetails.
        :type mpls_label: int

        :param ingress_vip:
            The value to assign to the ingress_vip property of this FlexTunnelDrgAttachmentNetworkDetails.
        :type ingress_vip: str

        """
        self.swagger_types = {
            'type': 'str',
            'id': 'str',
            'transport_attachment_id': 'str',
            'regional_oci_asn': 'str',
            'import_route_target': 'str',
            'export_route_target': 'str',
            'mpls_label': 'int',
            'ingress_vip': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'id': 'id',
            'transport_attachment_id': 'transportAttachmentId',
            'regional_oci_asn': 'regionalOciAsn',
            'import_route_target': 'importRouteTarget',
            'export_route_target': 'exportRouteTarget',
            'mpls_label': 'mplsLabel',
            'ingress_vip': 'ingressVip'
        }
        self._type = None
        self._id = None
        self._transport_attachment_id = None
        self._regional_oci_asn = None
        self._import_route_target = None
        self._export_route_target = None
        self._mpls_label = None
        self._ingress_vip = None
        self._type = 'FLEX_TUNNEL'

    @property
    def transport_attachment_id(self):
        """
        Gets the transport_attachment_id of this FlexTunnelDrgAttachmentNetworkDetails.
        The `OCID`__ of the transport drg attachment of the flex tunnel.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The transport_attachment_id of this FlexTunnelDrgAttachmentNetworkDetails.
        :rtype: str
        """
        return self._transport_attachment_id

    @transport_attachment_id.setter
    def transport_attachment_id(self, transport_attachment_id):
        """
        Sets the transport_attachment_id of this FlexTunnelDrgAttachmentNetworkDetails.
        The `OCID`__ of the transport drg attachment of the flex tunnel.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param transport_attachment_id: The transport_attachment_id of this FlexTunnelDrgAttachmentNetworkDetails.
        :type: str
        """
        self._transport_attachment_id = transport_attachment_id

    @property
    def regional_oci_asn(self):
        """
        Gets the regional_oci_asn of this FlexTunnelDrgAttachmentNetworkDetails.
        The BGP ASN to use for the Flex Tunnel connection's route target


        :return: The regional_oci_asn of this FlexTunnelDrgAttachmentNetworkDetails.
        :rtype: str
        """
        return self._regional_oci_asn

    @regional_oci_asn.setter
    def regional_oci_asn(self, regional_oci_asn):
        """
        Sets the regional_oci_asn of this FlexTunnelDrgAttachmentNetworkDetails.
        The BGP ASN to use for the Flex Tunnel connection's route target


        :param regional_oci_asn: The regional_oci_asn of this FlexTunnelDrgAttachmentNetworkDetails.
        :type: str
        """
        self._regional_oci_asn = regional_oci_asn

    @property
    def import_route_target(self):
        """
        Gets the import_route_target of this FlexTunnelDrgAttachmentNetworkDetails.
        Routes which may be imported from the attachment (subject to import policy) appear in the route reflectors
        tagged with the attachment's import route target.


        :return: The import_route_target of this FlexTunnelDrgAttachmentNetworkDetails.
        :rtype: str
        """
        return self._import_route_target

    @import_route_target.setter
    def import_route_target(self, import_route_target):
        """
        Sets the import_route_target of this FlexTunnelDrgAttachmentNetworkDetails.
        Routes which may be imported from the attachment (subject to import policy) appear in the route reflectors
        tagged with the attachment's import route target.


        :param import_route_target: The import_route_target of this FlexTunnelDrgAttachmentNetworkDetails.
        :type: str
        """
        self._import_route_target = import_route_target

    @property
    def export_route_target(self):
        """
        Gets the export_route_target of this FlexTunnelDrgAttachmentNetworkDetails.
        Routes which are exported to the attachment are exported to the route reflectors
        with the route target set to the value of the attachment's export route target.


        :return: The export_route_target of this FlexTunnelDrgAttachmentNetworkDetails.
        :rtype: str
        """
        return self._export_route_target

    @export_route_target.setter
    def export_route_target(self, export_route_target):
        """
        Sets the export_route_target of this FlexTunnelDrgAttachmentNetworkDetails.
        Routes which are exported to the attachment are exported to the route reflectors
        with the route target set to the value of the attachment's export route target.


        :param export_route_target: The export_route_target of this FlexTunnelDrgAttachmentNetworkDetails.
        :type: str
        """
        self._export_route_target = export_route_target

    @property
    def mpls_label(self):
        """
        Gets the mpls_label of this FlexTunnelDrgAttachmentNetworkDetails.
        The MPLS label of the DRG attachment.


        :return: The mpls_label of this FlexTunnelDrgAttachmentNetworkDetails.
        :rtype: int
        """
        return self._mpls_label

    @mpls_label.setter
    def mpls_label(self, mpls_label):
        """
        Sets the mpls_label of this FlexTunnelDrgAttachmentNetworkDetails.
        The MPLS label of the DRG attachment.


        :param mpls_label: The mpls_label of this FlexTunnelDrgAttachmentNetworkDetails.
        :type: int
        """
        self._mpls_label = mpls_label

    @property
    def ingress_vip(self):
        """
        Gets the ingress_vip of this FlexTunnelDrgAttachmentNetworkDetails.
        IPv4 address used to encapsulate ingress traffic to the DRG through this attachment


        :return: The ingress_vip of this FlexTunnelDrgAttachmentNetworkDetails.
        :rtype: str
        """
        return self._ingress_vip

    @ingress_vip.setter
    def ingress_vip(self, ingress_vip):
        """
        Sets the ingress_vip of this FlexTunnelDrgAttachmentNetworkDetails.
        IPv4 address used to encapsulate ingress traffic to the DRG through this attachment


        :param ingress_vip: The ingress_vip of this FlexTunnelDrgAttachmentNetworkDetails.
        :type: str
        """
        self._ingress_vip = ingress_vip

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
