# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .drg_attachment_network_create_details import DrgAttachmentNetworkCreateDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IpsecTunnelDrgAttachmentNetworkCreateDetails(DrgAttachmentNetworkCreateDetails):
    """
    Specifies the IPSec tunnel attachment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new IpsecTunnelDrgAttachmentNetworkCreateDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.vn_monitoring.models.IpsecTunnelDrgAttachmentNetworkCreateDetails.type` attribute
        of this class is ``IPSEC_TUNNEL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
            Allowed values for this property are: "VCN", "VIRTUAL_CIRCUIT", "REMOTE_PEERING_CONNECTION", "IPSEC_TUNNEL", "LOOPBACK", "FLEX_TUNNEL", "INTERNET"
        :type type: str

        :param id:
            The value to assign to the id property of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        :type compartment_id: str

        :param regional_oci_asn:
            The value to assign to the regional_oci_asn property of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        :type regional_oci_asn: str

        :param ipsec_connection_id:
            The value to assign to the ipsec_connection_id property of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        :type ipsec_connection_id: str

        :param transport_attachment_id:
            The value to assign to the transport_attachment_id property of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        :type transport_attachment_id: str

        """
        self.swagger_types = {
            'type': 'str',
            'id': 'str',
            'compartment_id': 'str',
            'regional_oci_asn': 'str',
            'ipsec_connection_id': 'str',
            'transport_attachment_id': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'id': 'id',
            'compartment_id': 'compartmentId',
            'regional_oci_asn': 'regionalOciAsn',
            'ipsec_connection_id': 'ipsecConnectionId',
            'transport_attachment_id': 'transportAttachmentId'
        }
        self._type = None
        self._id = None
        self._compartment_id = None
        self._regional_oci_asn = None
        self._ipsec_connection_id = None
        self._transport_attachment_id = None
        self._type = 'IPSEC_TUNNEL'

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        The `OCID`__ of the compartment that contains the IPSec connection.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        The `OCID`__ of the compartment that contains the IPSec connection.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def regional_oci_asn(self):
        """
        Gets the regional_oci_asn of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        The BGP ASN to use for the IPSec connection's route target


        :return: The regional_oci_asn of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        :rtype: str
        """
        return self._regional_oci_asn

    @regional_oci_asn.setter
    def regional_oci_asn(self, regional_oci_asn):
        """
        Sets the regional_oci_asn of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        The BGP ASN to use for the IPSec connection's route target


        :param regional_oci_asn: The regional_oci_asn of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        :type: str
        """
        self._regional_oci_asn = regional_oci_asn

    @property
    def ipsec_connection_id(self):
        """
        **[Required]** Gets the ipsec_connection_id of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        The IPSec connection that contains the attached IPSec tunnel.


        :return: The ipsec_connection_id of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        :rtype: str
        """
        return self._ipsec_connection_id

    @ipsec_connection_id.setter
    def ipsec_connection_id(self, ipsec_connection_id):
        """
        Sets the ipsec_connection_id of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        The IPSec connection that contains the attached IPSec tunnel.


        :param ipsec_connection_id: The ipsec_connection_id of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        :type: str
        """
        self._ipsec_connection_id = ipsec_connection_id

    @property
    def transport_attachment_id(self):
        """
        Gets the transport_attachment_id of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        The `OCID`__ of the virtual-circuit drg attachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The transport_attachment_id of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        :rtype: str
        """
        return self._transport_attachment_id

    @transport_attachment_id.setter
    def transport_attachment_id(self, transport_attachment_id):
        """
        Sets the transport_attachment_id of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        The `OCID`__ of the virtual-circuit drg attachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param transport_attachment_id: The transport_attachment_id of this IpsecTunnelDrgAttachmentNetworkCreateDetails.
        :type: str
        """
        self._transport_attachment_id = transport_attachment_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
