# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ContainerScanTarget(object):
    """
    A container scan target (application of a container scan recipe to the registry or list of repos)
    """

    #: A constant which can be used with the lifecycle_state property of a ContainerScanTarget.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a ContainerScanTarget.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a ContainerScanTarget.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ContainerScanTarget.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a ContainerScanTarget.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a ContainerScanTarget.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new ContainerScanTarget object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ContainerScanTarget.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this ContainerScanTarget.
        :type display_name: str

        :param description:
            The value to assign to the description property of this ContainerScanTarget.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ContainerScanTarget.
        :type compartment_id: str

        :param target_registry:
            The value to assign to the target_registry property of this ContainerScanTarget.
        :type target_registry: oci.vulnerability_scanning.models.ContainerScanRegistry

        :param container_scan_recipe_id:
            The value to assign to the container_scan_recipe_id property of this ContainerScanTarget.
        :type container_scan_recipe_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ContainerScanTarget.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this ContainerScanTarget.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ContainerScanTarget.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ContainerScanTarget.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ContainerScanTarget.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ContainerScanTarget.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'target_registry': 'ContainerScanRegistry',
            'container_scan_recipe_id': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'target_registry': 'targetRegistry',
            'container_scan_recipe_id': 'containerScanRecipeId',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._target_registry = None
        self._container_scan_recipe_id = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ContainerScanTarget.
        The `OCID`__ of container scan target. Immutable and generated on creation.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this ContainerScanTarget.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ContainerScanTarget.
        The `OCID`__ of container scan target. Immutable and generated on creation.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this ContainerScanTarget.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ContainerScanTarget.
        User friendly name of container scan target


        :return: The display_name of this ContainerScanTarget.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ContainerScanTarget.
        User friendly name of container scan target


        :param display_name: The display_name of this ContainerScanTarget.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this ContainerScanTarget.
        Target description.


        :return: The description of this ContainerScanTarget.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ContainerScanTarget.
        Target description.


        :param description: The description of this ContainerScanTarget.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ContainerScanTarget.
        The `OCID`__ of the container scan target's compartment

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ContainerScanTarget.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ContainerScanTarget.
        The `OCID`__ of the container scan target's compartment

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ContainerScanTarget.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def target_registry(self):
        """
        Gets the target_registry of this ContainerScanTarget.

        :return: The target_registry of this ContainerScanTarget.
        :rtype: oci.vulnerability_scanning.models.ContainerScanRegistry
        """
        return self._target_registry

    @target_registry.setter
    def target_registry(self, target_registry):
        """
        Sets the target_registry of this ContainerScanTarget.

        :param target_registry: The target_registry of this ContainerScanTarget.
        :type: oci.vulnerability_scanning.models.ContainerScanRegistry
        """
        self._target_registry = target_registry

    @property
    def container_scan_recipe_id(self):
        """
        **[Required]** Gets the container_scan_recipe_id of this ContainerScanTarget.
        ID of the container scan recipe this target applies.


        :return: The container_scan_recipe_id of this ContainerScanTarget.
        :rtype: str
        """
        return self._container_scan_recipe_id

    @container_scan_recipe_id.setter
    def container_scan_recipe_id(self, container_scan_recipe_id):
        """
        Sets the container_scan_recipe_id of this ContainerScanTarget.
        ID of the container scan recipe this target applies.


        :param container_scan_recipe_id: The container_scan_recipe_id of this ContainerScanTarget.
        :type: str
        """
        self._container_scan_recipe_id = container_scan_recipe_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ContainerScanTarget.
        The current state of the config.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ContainerScanTarget.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ContainerScanTarget.
        The current state of the config.


        :param lifecycle_state: The lifecycle_state of this ContainerScanTarget.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ContainerScanTarget.
        Date and time the target was created, format as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this ContainerScanTarget.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ContainerScanTarget.
        Date and time the target was created, format as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this ContainerScanTarget.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this ContainerScanTarget.
        Date and time the target was last updated, format as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_updated of this ContainerScanTarget.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ContainerScanTarget.
        Date and time the target was last updated, format as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_updated: The time_updated of this ContainerScanTarget.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ContainerScanTarget.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this ContainerScanTarget.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ContainerScanTarget.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this ContainerScanTarget.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ContainerScanTarget.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this ContainerScanTarget.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ContainerScanTarget.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this ContainerScanTarget.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ContainerScanTarget.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ContainerScanTarget.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ContainerScanTarget.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ContainerScanTarget.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
