# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SetRestartOrderDetails(object):
    """
    This object contains the server with updated restart order in a WebLogic domain.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SetRestartOrderDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param servers:
            The value to assign to the servers property of this SetRestartOrderDetails.
        :type servers: oci.wlms.models.SetRestartOrderServerCollection

        """
        self.swagger_types = {
            'servers': 'SetRestartOrderServerCollection'
        }
        self.attribute_map = {
            'servers': 'servers'
        }
        self._servers = None

    @property
    def servers(self):
        """
        **[Required]** Gets the servers of this SetRestartOrderDetails.

        :return: The servers of this SetRestartOrderDetails.
        :rtype: oci.wlms.models.SetRestartOrderServerCollection
        """
        return self._servers

    @servers.setter
    def servers(self, servers):
        """
        Sets the servers of this SetRestartOrderDetails.

        :param servers: The servers of this SetRestartOrderDetails.
        :type: oci.wlms.models.SetRestartOrderServerCollection
        """
        self._servers = servers

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
