# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RemediationRunStage(object):
    """
    A remediation run stage is one step of an remediation run. Each stage provides output logs and has a specific type.
    The stages are: DETECT, RECOMMEND, VERIFY, and APPLY.
    """

    #: A constant which can be used with the status property of a RemediationRunStage.
    #: This constant has a value of "CREATED"
    STATUS_CREATED = "CREATED"

    #: A constant which can be used with the status property of a RemediationRunStage.
    #: This constant has a value of "IN_PROGRESS"
    STATUS_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the status property of a RemediationRunStage.
    #: This constant has a value of "SUCCEEDED"
    STATUS_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the status property of a RemediationRunStage.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    #: A constant which can be used with the status property of a RemediationRunStage.
    #: This constant has a value of "CANCELING"
    STATUS_CANCELING = "CANCELING"

    #: A constant which can be used with the status property of a RemediationRunStage.
    #: This constant has a value of "CANCELED"
    STATUS_CANCELED = "CANCELED"

    #: A constant which can be used with the type property of a RemediationRunStage.
    #: This constant has a value of "DETECT"
    TYPE_DETECT = "DETECT"

    #: A constant which can be used with the type property of a RemediationRunStage.
    #: This constant has a value of "RECOMMEND"
    TYPE_RECOMMEND = "RECOMMEND"

    #: A constant which can be used with the type property of a RemediationRunStage.
    #: This constant has a value of "VERIFY"
    TYPE_VERIFY = "VERIFY"

    #: A constant which can be used with the type property of a RemediationRunStage.
    #: This constant has a value of "APPLY"
    TYPE_APPLY = "APPLY"

    #: A constant which can be used with the previous_stage_type property of a RemediationRunStage.
    #: This constant has a value of "DETECT"
    PREVIOUS_STAGE_TYPE_DETECT = "DETECT"

    #: A constant which can be used with the previous_stage_type property of a RemediationRunStage.
    #: This constant has a value of "RECOMMEND"
    PREVIOUS_STAGE_TYPE_RECOMMEND = "RECOMMEND"

    #: A constant which can be used with the previous_stage_type property of a RemediationRunStage.
    #: This constant has a value of "VERIFY"
    PREVIOUS_STAGE_TYPE_VERIFY = "VERIFY"

    #: A constant which can be used with the previous_stage_type property of a RemediationRunStage.
    #: This constant has a value of "APPLY"
    PREVIOUS_STAGE_TYPE_APPLY = "APPLY"

    #: A constant which can be used with the next_stage_type property of a RemediationRunStage.
    #: This constant has a value of "DETECT"
    NEXT_STAGE_TYPE_DETECT = "DETECT"

    #: A constant which can be used with the next_stage_type property of a RemediationRunStage.
    #: This constant has a value of "RECOMMEND"
    NEXT_STAGE_TYPE_RECOMMEND = "RECOMMEND"

    #: A constant which can be used with the next_stage_type property of a RemediationRunStage.
    #: This constant has a value of "VERIFY"
    NEXT_STAGE_TYPE_VERIFY = "VERIFY"

    #: A constant which can be used with the next_stage_type property of a RemediationRunStage.
    #: This constant has a value of "APPLY"
    NEXT_STAGE_TYPE_APPLY = "APPLY"

    def __init__(self, **kwargs):
        """
        Initializes a new RemediationRunStage object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.adm.models.RecommendStage`
        * :class:`~oci.adm.models.VerifyStage`
        * :class:`~oci.adm.models.ApplyStage`
        * :class:`~oci.adm.models.DetectStage`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param status:
            The value to assign to the status property of this RemediationRunStage.
            Allowed values for this property are: "CREATED", "IN_PROGRESS", "SUCCEEDED", "FAILED", "CANCELING", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param time_created:
            The value to assign to the time_created property of this RemediationRunStage.
        :type time_created: datetime

        :param time_started:
            The value to assign to the time_started property of this RemediationRunStage.
        :type time_started: datetime

        :param time_finished:
            The value to assign to the time_finished property of this RemediationRunStage.
        :type time_finished: datetime

        :param type:
            The value to assign to the type property of this RemediationRunStage.
            Allowed values for this property are: "DETECT", "RECOMMEND", "VERIFY", "APPLY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param summary:
            The value to assign to the summary property of this RemediationRunStage.
        :type summary: str

        :param remediation_run_id:
            The value to assign to the remediation_run_id property of this RemediationRunStage.
        :type remediation_run_id: str

        :param previous_stage_type:
            The value to assign to the previous_stage_type property of this RemediationRunStage.
            Allowed values for this property are: "DETECT", "RECOMMEND", "VERIFY", "APPLY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type previous_stage_type: str

        :param next_stage_type:
            The value to assign to the next_stage_type property of this RemediationRunStage.
            Allowed values for this property are: "DETECT", "RECOMMEND", "VERIFY", "APPLY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type next_stage_type: str

        """
        self.swagger_types = {
            'status': 'str',
            'time_created': 'datetime',
            'time_started': 'datetime',
            'time_finished': 'datetime',
            'type': 'str',
            'summary': 'str',
            'remediation_run_id': 'str',
            'previous_stage_type': 'str',
            'next_stage_type': 'str'
        }
        self.attribute_map = {
            'status': 'status',
            'time_created': 'timeCreated',
            'time_started': 'timeStarted',
            'time_finished': 'timeFinished',
            'type': 'type',
            'summary': 'summary',
            'remediation_run_id': 'remediationRunId',
            'previous_stage_type': 'previousStageType',
            'next_stage_type': 'nextStageType'
        }
        self._status = None
        self._time_created = None
        self._time_started = None
        self._time_finished = None
        self._type = None
        self._summary = None
        self._remediation_run_id = None
        self._previous_stage_type = None
        self._next_stage_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'RECOMMEND':
            return 'RecommendStage'

        if type == 'VERIFY':
            return 'VerifyStage'

        if type == 'APPLY':
            return 'ApplyStage'

        if type == 'DETECT':
            return 'DetectStage'
        else:
            return 'RemediationRunStage'

    @property
    def status(self):
        """
        **[Required]** Gets the status of this RemediationRunStage.
        The current status of a remediation run stage.

        Allowed values for this property are: "CREATED", "IN_PROGRESS", "SUCCEEDED", "FAILED", "CANCELING", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this RemediationRunStage.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this RemediationRunStage.
        The current status of a remediation run stage.


        :param status: The status of this RemediationRunStage.
        :type: str
        """
        allowed_values = ["CREATED", "IN_PROGRESS", "SUCCEEDED", "FAILED", "CANCELING", "CANCELED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this RemediationRunStage.
        The creation date and time of the remediation run stage (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_created of this RemediationRunStage.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this RemediationRunStage.
        The creation date and time of the remediation run stage (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_created: The time_created of this RemediationRunStage.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_started(self):
        """
        Gets the time_started of this RemediationRunStage.
        The date and time of the start of the remediation run stage (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_started of this RemediationRunStage.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this RemediationRunStage.
        The date and time of the start of the remediation run stage (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_started: The time_started of this RemediationRunStage.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_finished(self):
        """
        Gets the time_finished of this RemediationRunStage.
        The date and time of the finish of the remediation run stage (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_finished of this RemediationRunStage.
        :rtype: datetime
        """
        return self._time_finished

    @time_finished.setter
    def time_finished(self, time_finished):
        """
        Sets the time_finished of this RemediationRunStage.
        The date and time of the finish of the remediation run stage (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_finished: The time_finished of this RemediationRunStage.
        :type: datetime
        """
        self._time_finished = time_finished

    @property
    def type(self):
        """
        **[Required]** Gets the type of this RemediationRunStage.
        The type of the remediation run stage.

        Allowed values for this property are: "DETECT", "RECOMMEND", "VERIFY", "APPLY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this RemediationRunStage.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this RemediationRunStage.
        The type of the remediation run stage.


        :param type: The type of this RemediationRunStage.
        :type: str
        """
        allowed_values = ["DETECT", "RECOMMEND", "VERIFY", "APPLY"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def summary(self):
        """
        Gets the summary of this RemediationRunStage.
        Information about the current step within the stage.


        :return: The summary of this RemediationRunStage.
        :rtype: str
        """
        return self._summary

    @summary.setter
    def summary(self, summary):
        """
        Sets the summary of this RemediationRunStage.
        Information about the current step within the stage.


        :param summary: The summary of this RemediationRunStage.
        :type: str
        """
        self._summary = summary

    @property
    def remediation_run_id(self):
        """
        **[Required]** Gets the remediation_run_id of this RemediationRunStage.
        The Oracle Cloud identifier (`OCID`__) of the remediation run.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The remediation_run_id of this RemediationRunStage.
        :rtype: str
        """
        return self._remediation_run_id

    @remediation_run_id.setter
    def remediation_run_id(self, remediation_run_id):
        """
        Sets the remediation_run_id of this RemediationRunStage.
        The Oracle Cloud identifier (`OCID`__) of the remediation run.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param remediation_run_id: The remediation_run_id of this RemediationRunStage.
        :type: str
        """
        self._remediation_run_id = remediation_run_id

    @property
    def previous_stage_type(self):
        """
        Gets the previous_stage_type of this RemediationRunStage.
        The previous type of stage in the remediation run.

        Allowed values for this property are: "DETECT", "RECOMMEND", "VERIFY", "APPLY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The previous_stage_type of this RemediationRunStage.
        :rtype: str
        """
        return self._previous_stage_type

    @previous_stage_type.setter
    def previous_stage_type(self, previous_stage_type):
        """
        Sets the previous_stage_type of this RemediationRunStage.
        The previous type of stage in the remediation run.


        :param previous_stage_type: The previous_stage_type of this RemediationRunStage.
        :type: str
        """
        allowed_values = ["DETECT", "RECOMMEND", "VERIFY", "APPLY"]
        if not value_allowed_none_or_none_sentinel(previous_stage_type, allowed_values):
            previous_stage_type = 'UNKNOWN_ENUM_VALUE'
        self._previous_stage_type = previous_stage_type

    @property
    def next_stage_type(self):
        """
        Gets the next_stage_type of this RemediationRunStage.
        The next type of stage in the remediation run.

        Allowed values for this property are: "DETECT", "RECOMMEND", "VERIFY", "APPLY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The next_stage_type of this RemediationRunStage.
        :rtype: str
        """
        return self._next_stage_type

    @next_stage_type.setter
    def next_stage_type(self, next_stage_type):
        """
        Sets the next_stage_type of this RemediationRunStage.
        The next type of stage in the remediation run.


        :param next_stage_type: The next_stage_type of this RemediationRunStage.
        :type: str
        """
        allowed_values = ["DETECT", "RECOMMEND", "VERIFY", "APPLY"]
        if not value_allowed_none_or_none_sentinel(next_stage_type, allowed_values):
            next_stage_type = 'UNKNOWN_ENUM_VALUE'
        self._next_stage_type = next_stage_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
