# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221109

from .model_sub_type import ModelSubType
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KvModelSubType(ModelSubType):
    """
    The Kv model sub type
    """

    #: A constant which can be used with the model_sub_type property of a KvModelSubType.
    #: This constant has a value of "RECEIPT"
    MODEL_SUB_TYPE_RECEIPT = "RECEIPT"

    #: A constant which can be used with the model_sub_type property of a KvModelSubType.
    #: This constant has a value of "INVOICE"
    MODEL_SUB_TYPE_INVOICE = "INVOICE"

    #: A constant which can be used with the model_sub_type property of a KvModelSubType.
    #: This constant has a value of "PASSPORT"
    MODEL_SUB_TYPE_PASSPORT = "PASSPORT"

    #: A constant which can be used with the model_sub_type property of a KvModelSubType.
    #: This constant has a value of "DRIVER_LICENSE"
    MODEL_SUB_TYPE_DRIVER_LICENSE = "DRIVER_LICENSE"

    #: A constant which can be used with the model_sub_type property of a KvModelSubType.
    #: This constant has a value of "HEALTH_INSURANCE_ID"
    MODEL_SUB_TYPE_HEALTH_INSURANCE_ID = "HEALTH_INSURANCE_ID"

    def __init__(self, **kwargs):
        """
        Initializes a new KvModelSubType object with values from keyword arguments. The default value of the :py:attr:`~oci.ai_document.models.KvModelSubType.model_type` attribute
        of this class is ``PRE_TRAINED_KEY_VALUE_EXTRACTION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param model_type:
            The value to assign to the model_type property of this KvModelSubType.
            Allowed values for this property are: "PRE_TRAINED_KEY_VALUE_EXTRACTION", "PRE_TRAINED_DOCUMENT_ELEMENTS_EXTRACTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type model_type: str

        :param model_sub_type:
            The value to assign to the model_sub_type property of this KvModelSubType.
            Allowed values for this property are: "RECEIPT", "INVOICE", "PASSPORT", "DRIVER_LICENSE", "HEALTH_INSURANCE_ID", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type model_sub_type: str

        """
        self.swagger_types = {
            'model_type': 'str',
            'model_sub_type': 'str'
        }
        self.attribute_map = {
            'model_type': 'modelType',
            'model_sub_type': 'modelSubType'
        }
        self._model_type = None
        self._model_sub_type = None
        self._model_type = 'PRE_TRAINED_KEY_VALUE_EXTRACTION'

    @property
    def model_sub_type(self):
        """
        **[Required]** Gets the model_sub_type of this KvModelSubType.
        The model sub type for KEY_VALUE_EXTRACTION
        The allowed values are:
        - `RECEIPT`
        - `INVOICE`
        - `PASSPORT`
        - `DRIVER_LICENSE`
        - `HEALTH_INSURANCE_ID`

        Allowed values for this property are: "RECEIPT", "INVOICE", "PASSPORT", "DRIVER_LICENSE", "HEALTH_INSURANCE_ID", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The model_sub_type of this KvModelSubType.
        :rtype: str
        """
        return self._model_sub_type

    @model_sub_type.setter
    def model_sub_type(self, model_sub_type):
        """
        Sets the model_sub_type of this KvModelSubType.
        The model sub type for KEY_VALUE_EXTRACTION
        The allowed values are:
        - `RECEIPT`
        - `INVOICE`
        - `PASSPORT`
        - `DRIVER_LICENSE`
        - `HEALTH_INSURANCE_ID`


        :param model_sub_type: The model_sub_type of this KvModelSubType.
        :type: str
        """
        allowed_values = ["RECEIPT", "INVOICE", "PASSPORT", "DRIVER_LICENSE", "HEALTH_INSURANCE_ID"]
        if not value_allowed_none_or_none_sentinel(model_sub_type, allowed_values):
            model_sub_type = 'UNKNOWN_ENUM_VALUE'
        self._model_sub_type = model_sub_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
