# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221001


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HealthEntity(object):
    """
    Health entity object
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HealthEntity object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param offset:
            The value to assign to the offset property of this HealthEntity.
        :type offset: int

        :param length:
            The value to assign to the length property of this HealthEntity.
        :type length: int

        :param text:
            The value to assign to the text property of this HealthEntity.
        :type text: str

        :param type:
            The value to assign to the type property of this HealthEntity.
        :type type: str

        :param sub_type:
            The value to assign to the sub_type property of this HealthEntity.
        :type sub_type: str

        :param score:
            The value to assign to the score property of this HealthEntity.
        :type score: float

        :param category:
            The value to assign to the category property of this HealthEntity.
        :type category: str

        :param id:
            The value to assign to the id property of this HealthEntity.
        :type id: str

        :param assertions:
            The value to assign to the assertions property of this HealthEntity.
        :type assertions: list[oci.ai_language.models.AssertionDetails]

        :param matched_concepts:
            The value to assign to the matched_concepts property of this HealthEntity.
        :type matched_concepts: list[oci.ai_language.models.MelConcept]

        """
        self.swagger_types = {
            'offset': 'int',
            'length': 'int',
            'text': 'str',
            'type': 'str',
            'sub_type': 'str',
            'score': 'float',
            'category': 'str',
            'id': 'str',
            'assertions': 'list[AssertionDetails]',
            'matched_concepts': 'list[MelConcept]'
        }
        self.attribute_map = {
            'offset': 'offset',
            'length': 'length',
            'text': 'text',
            'type': 'type',
            'sub_type': 'subType',
            'score': 'score',
            'category': 'category',
            'id': 'id',
            'assertions': 'assertions',
            'matched_concepts': 'matchedConcepts'
        }
        self._offset = None
        self._length = None
        self._text = None
        self._type = None
        self._sub_type = None
        self._score = None
        self._category = None
        self._id = None
        self._assertions = None
        self._matched_concepts = None

    @property
    def offset(self):
        """
        **[Required]** Gets the offset of this HealthEntity.
        The number of Unicode code points preceding this entity in the submitted text.


        :return: The offset of this HealthEntity.
        :rtype: int
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """
        Sets the offset of this HealthEntity.
        The number of Unicode code points preceding this entity in the submitted text.


        :param offset: The offset of this HealthEntity.
        :type: int
        """
        self._offset = offset

    @property
    def length(self):
        """
        **[Required]** Gets the length of this HealthEntity.
        Length of entity text


        :return: The length of this HealthEntity.
        :rtype: int
        """
        return self._length

    @length.setter
    def length(self, length):
        """
        Sets the length of this HealthEntity.
        Length of entity text


        :param length: The length of this HealthEntity.
        :type: int
        """
        self._length = length

    @property
    def text(self):
        """
        **[Required]** Gets the text of this HealthEntity.
        Entity text like name of person, location, and so on.


        :return: The text of this HealthEntity.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """
        Sets the text of this HealthEntity.
        Entity text like name of person, location, and so on.


        :param text: The text of this HealthEntity.
        :type: str
        """
        self._text = text

    @property
    def type(self):
        """
        **[Required]** Gets the type of this HealthEntity.
        Type of entity text like PER, LOC.


        :return: The type of this HealthEntity.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this HealthEntity.
        Type of entity text like PER, LOC.


        :param type: The type of this HealthEntity.
        :type: str
        """
        self._type = type

    @property
    def sub_type(self):
        """
        Gets the sub_type of this HealthEntity.
        Sub-type of entity text like GPE for LOCATION type


        :return: The sub_type of this HealthEntity.
        :rtype: str
        """
        return self._sub_type

    @sub_type.setter
    def sub_type(self, sub_type):
        """
        Sets the sub_type of this HealthEntity.
        Sub-type of entity text like GPE for LOCATION type


        :param sub_type: The sub_type of this HealthEntity.
        :type: str
        """
        self._sub_type = sub_type

    @property
    def score(self):
        """
        **[Required]** Gets the score of this HealthEntity.
        Score or confidence for detected entity.


        :return: The score of this HealthEntity.
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """
        Sets the score of this HealthEntity.
        Score or confidence for detected entity.


        :param score: The score of this HealthEntity.
        :type: float
        """
        self._score = score

    @property
    def category(self):
        """
        Gets the category of this HealthEntity.
        Entity category e.g, MEDICAL_CONDITION, MEDICATION, GENERAL, ANATOMY


        :return: The category of this HealthEntity.
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """
        Sets the category of this HealthEntity.
        Entity category e.g, MEDICAL_CONDITION, MEDICATION, GENERAL, ANATOMY


        :param category: The category of this HealthEntity.
        :type: str
        """
        self._category = category

    @property
    def id(self):
        """
        **[Required]** Gets the id of this HealthEntity.
        Unique id of the entity


        :return: The id of this HealthEntity.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this HealthEntity.
        Unique id of the entity


        :param id: The id of this HealthEntity.
        :type: str
        """
        self._id = id

    @property
    def assertions(self):
        """
        Gets the assertions of this HealthEntity.
        list of all assertions associated with this entity.


        :return: The assertions of this HealthEntity.
        :rtype: list[oci.ai_language.models.AssertionDetails]
        """
        return self._assertions

    @assertions.setter
    def assertions(self, assertions):
        """
        Sets the assertions of this HealthEntity.
        list of all assertions associated with this entity.


        :param assertions: The assertions of this HealthEntity.
        :type: list[oci.ai_language.models.AssertionDetails]
        """
        self._assertions = assertions

    @property
    def matched_concepts(self):
        """
        Gets the matched_concepts of this HealthEntity.
        This contains the list of matched concepts which are ranked by the relevant score with the input text


        :return: The matched_concepts of this HealthEntity.
        :rtype: list[oci.ai_language.models.MelConcept]
        """
        return self._matched_concepts

    @matched_concepts.setter
    def matched_concepts(self, matched_concepts):
        """
        Sets the matched_concepts of this HealthEntity.
        This contains the list of matched concepts which are ranked by the relevant score with the input text


        :param matched_concepts: The matched_concepts of this HealthEntity.
        :type: list[oci.ai_language.models.MelConcept]
        """
        self._matched_concepts = matched_concepts

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
