# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModelVersionDetails(object):
    """
    Model version for object detection/tracking.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ModelVersionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param objects:
            The value to assign to the objects property of this ModelVersionDetails.
        :type objects: list[str]

        :param model_version:
            The value to assign to the model_version property of this ModelVersionDetails.
        :type model_version: str

        """
        self.swagger_types = {
            'objects': 'list[str]',
            'model_version': 'str'
        }
        self.attribute_map = {
            'objects': 'objects',
            'model_version': 'modelVersion'
        }
        self._objects = None
        self._model_version = None

    @property
    def objects(self):
        """
        **[Required]** Gets the objects of this ModelVersionDetails.
        List of the object category labels.


        :return: The objects of this ModelVersionDetails.
        :rtype: list[str]
        """
        return self._objects

    @objects.setter
    def objects(self, objects):
        """
        Sets the objects of this ModelVersionDetails.
        List of the object category labels.


        :param objects: The objects of this ModelVersionDetails.
        :type: list[str]
        """
        self._objects = objects

    @property
    def model_version(self):
        """
        **[Required]** Gets the model_version of this ModelVersionDetails.
        Model version or ocid


        :return: The model_version of this ModelVersionDetails.
        :rtype: str
        """
        return self._model_version

    @model_version.setter
    def model_version(self, model_version):
        """
        Sets the model_version of this ModelVersionDetails.
        Model version or ocid


        :param model_version: The model_version of this ModelVersionDetails.
        :type: str
        """
        self._model_version = model_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
