# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VideoTextFrame(object):
    """
    A text frame.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VideoTextFrame object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_offset_ms:
            The value to assign to the time_offset_ms property of this VideoTextFrame.
        :type time_offset_ms: int

        :param confidence:
            The value to assign to the confidence property of this VideoTextFrame.
        :type confidence: float

        :param bounding_polygon:
            The value to assign to the bounding_polygon property of this VideoTextFrame.
        :type bounding_polygon: oci.ai_vision.models.BoundingPolygon

        """
        self.swagger_types = {
            'time_offset_ms': 'int',
            'confidence': 'float',
            'bounding_polygon': 'BoundingPolygon'
        }
        self.attribute_map = {
            'time_offset_ms': 'timeOffsetMs',
            'confidence': 'confidence',
            'bounding_polygon': 'boundingPolygon'
        }
        self._time_offset_ms = None
        self._confidence = None
        self._bounding_polygon = None

    @property
    def time_offset_ms(self):
        """
        **[Required]** Gets the time_offset_ms of this VideoTextFrame.
        Time offset(Milliseconds) in the video.


        :return: The time_offset_ms of this VideoTextFrame.
        :rtype: int
        """
        return self._time_offset_ms

    @time_offset_ms.setter
    def time_offset_ms(self, time_offset_ms):
        """
        Sets the time_offset_ms of this VideoTextFrame.
        Time offset(Milliseconds) in the video.


        :param time_offset_ms: The time_offset_ms of this VideoTextFrame.
        :type: int
        """
        self._time_offset_ms = time_offset_ms

    @property
    def confidence(self):
        """
        **[Required]** Gets the confidence of this VideoTextFrame.
        The confidence score, between 0 and 1.


        :return: The confidence of this VideoTextFrame.
        :rtype: float
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence):
        """
        Sets the confidence of this VideoTextFrame.
        The confidence score, between 0 and 1.


        :param confidence: The confidence of this VideoTextFrame.
        :type: float
        """
        self._confidence = confidence

    @property
    def bounding_polygon(self):
        """
        **[Required]** Gets the bounding_polygon of this VideoTextFrame.

        :return: The bounding_polygon of this VideoTextFrame.
        :rtype: oci.ai_vision.models.BoundingPolygon
        """
        return self._bounding_polygon

    @bounding_polygon.setter
    def bounding_polygon(self, bounding_polygon):
        """
        Sets the bounding_polygon of this VideoTextFrame.

        :param bounding_polygon: The bounding_polygon of this VideoTextFrame.
        :type: oci.ai_vision.models.BoundingPolygon
        """
        self._bounding_polygon = bounding_polygon

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
