# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateBatchTaskEnvironmentDetails(object):
    """
    The data to create a batch task environment.
    If the value for a collection is absent or is explicitly provided as null, it will be converted to an empty value, i.e. \"[]\" or \"{}\" in json notation. This applies to nested collections as well.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateBatchTaskEnvironmentDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateBatchTaskEnvironmentDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateBatchTaskEnvironmentDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateBatchTaskEnvironmentDetails.
        :type description: str

        :param image_url:
            The value to assign to the image_url property of this CreateBatchTaskEnvironmentDetails.
        :type image_url: str

        :param security_context:
            The value to assign to the security_context property of this CreateBatchTaskEnvironmentDetails.
        :type security_context: oci.batch.models.SecurityContext

        :param working_directory:
            The value to assign to the working_directory property of this CreateBatchTaskEnvironmentDetails.
        :type working_directory: str

        :param volumes:
            The value to assign to the volumes property of this CreateBatchTaskEnvironmentDetails.
        :type volumes: list[oci.batch.models.BatchTaskEnvironmentVolume]

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateBatchTaskEnvironmentDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateBatchTaskEnvironmentDetails.
        :type freeform_tags: dict(str, str)

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'image_url': 'str',
            'security_context': 'SecurityContext',
            'working_directory': 'str',
            'volumes': 'list[BatchTaskEnvironmentVolume]',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'description': 'description',
            'image_url': 'imageUrl',
            'security_context': 'securityContext',
            'working_directory': 'workingDirectory',
            'volumes': 'volumes',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags'
        }
        self._compartment_id = None
        self._display_name = None
        self._description = None
        self._image_url = None
        self._security_context = None
        self._working_directory = None
        self._volumes = None
        self._defined_tags = None
        self._freeform_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateBatchTaskEnvironmentDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateBatchTaskEnvironmentDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateBatchTaskEnvironmentDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateBatchTaskEnvironmentDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateBatchTaskEnvironmentDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        If not specified or provided as null or empty string, it be generated as \"<resourceType><timeCreated>\", where timeCreated corresponds with the resource creation time in ISO 8601 basic format, i.e. omitting separating punctuation, at second-level precision and no UTC offset. Example: batchtaskenvironment20250914115623.


        :return: The display_name of this CreateBatchTaskEnvironmentDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateBatchTaskEnvironmentDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        If not specified or provided as null or empty string, it be generated as \"<resourceType><timeCreated>\", where timeCreated corresponds with the resource creation time in ISO 8601 basic format, i.e. omitting separating punctuation, at second-level precision and no UTC offset. Example: batchtaskenvironment20250914115623.


        :param display_name: The display_name of this CreateBatchTaskEnvironmentDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateBatchTaskEnvironmentDetails.
        The batch task environment description.


        :return: The description of this CreateBatchTaskEnvironmentDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateBatchTaskEnvironmentDetails.
        The batch task environment description.


        :param description: The description of this CreateBatchTaskEnvironmentDetails.
        :type: str
        """
        self._description = description

    @property
    def image_url(self):
        """
        **[Required]** Gets the image_url of this CreateBatchTaskEnvironmentDetails.
        The URL of the ocir image.


        :return: The image_url of this CreateBatchTaskEnvironmentDetails.
        :rtype: str
        """
        return self._image_url

    @image_url.setter
    def image_url(self, image_url):
        """
        Sets the image_url of this CreateBatchTaskEnvironmentDetails.
        The URL of the ocir image.


        :param image_url: The image_url of this CreateBatchTaskEnvironmentDetails.
        :type: str
        """
        self._image_url = image_url

    @property
    def security_context(self):
        """
        Gets the security_context of this CreateBatchTaskEnvironmentDetails.

        :return: The security_context of this CreateBatchTaskEnvironmentDetails.
        :rtype: oci.batch.models.SecurityContext
        """
        return self._security_context

    @security_context.setter
    def security_context(self, security_context):
        """
        Sets the security_context of this CreateBatchTaskEnvironmentDetails.

        :param security_context: The security_context of this CreateBatchTaskEnvironmentDetails.
        :type: oci.batch.models.SecurityContext
        """
        self._security_context = security_context

    @property
    def working_directory(self):
        """
        Gets the working_directory of this CreateBatchTaskEnvironmentDetails.
        Container's working directory.


        :return: The working_directory of this CreateBatchTaskEnvironmentDetails.
        :rtype: str
        """
        return self._working_directory

    @working_directory.setter
    def working_directory(self, working_directory):
        """
        Sets the working_directory of this CreateBatchTaskEnvironmentDetails.
        Container's working directory.


        :param working_directory: The working_directory of this CreateBatchTaskEnvironmentDetails.
        :type: str
        """
        self._working_directory = working_directory

    @property
    def volumes(self):
        """
        Gets the volumes of this CreateBatchTaskEnvironmentDetails.
        List of volumes attached to the image.
        The use cases of the volumes are but not limited to: read the input of the task and write the output.


        :return: The volumes of this CreateBatchTaskEnvironmentDetails.
        :rtype: list[oci.batch.models.BatchTaskEnvironmentVolume]
        """
        return self._volumes

    @volumes.setter
    def volumes(self, volumes):
        """
        Sets the volumes of this CreateBatchTaskEnvironmentDetails.
        List of volumes attached to the image.
        The use cases of the volumes are but not limited to: read the input of the task and write the output.


        :param volumes: The volumes of this CreateBatchTaskEnvironmentDetails.
        :type: list[oci.batch.models.BatchTaskEnvironmentVolume]
        """
        self._volumes = volumes

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateBatchTaskEnvironmentDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateBatchTaskEnvironmentDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateBatchTaskEnvironmentDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateBatchTaskEnvironmentDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateBatchTaskEnvironmentDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateBatchTaskEnvironmentDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateBatchTaskEnvironmentDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateBatchTaskEnvironmentDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
