# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FleetShape(object):
    """
    Shape of the fleet. Describes hardware resources of each node in the fleet.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FleetShape object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param shape_name:
            The value to assign to the shape_name property of this FleetShape.
        :type shape_name: str

        :param ocpus:
            The value to assign to the ocpus property of this FleetShape.
        :type ocpus: int

        :param memory_in_gbs:
            The value to assign to the memory_in_gbs property of this FleetShape.
        :type memory_in_gbs: int

        """
        self.swagger_types = {
            'shape_name': 'str',
            'ocpus': 'int',
            'memory_in_gbs': 'int'
        }
        self.attribute_map = {
            'shape_name': 'shapeName',
            'ocpus': 'ocpus',
            'memory_in_gbs': 'memoryInGBs'
        }
        self._shape_name = None
        self._ocpus = None
        self._memory_in_gbs = None

    @property
    def shape_name(self):
        """
        **[Required]** Gets the shape_name of this FleetShape.
        The name of the shape.


        :return: The shape_name of this FleetShape.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this FleetShape.
        The name of the shape.


        :param shape_name: The shape_name of this FleetShape.
        :type: str
        """
        self._shape_name = shape_name

    @property
    def ocpus(self):
        """
        **[Required]** Gets the ocpus of this FleetShape.
        Number of OCPUs required by the shape.


        :return: The ocpus of this FleetShape.
        :rtype: int
        """
        return self._ocpus

    @ocpus.setter
    def ocpus(self, ocpus):
        """
        Sets the ocpus of this FleetShape.
        Number of OCPUs required by the shape.


        :param ocpus: The ocpus of this FleetShape.
        :type: int
        """
        self._ocpus = ocpus

    @property
    def memory_in_gbs(self):
        """
        **[Required]** Gets the memory_in_gbs of this FleetShape.
        Amount of memory in GBs required by the shape.


        :return: The memory_in_gbs of this FleetShape.
        :rtype: int
        """
        return self._memory_in_gbs

    @memory_in_gbs.setter
    def memory_in_gbs(self, memory_in_gbs):
        """
        Sets the memory_in_gbs of this FleetShape.
        Amount of memory in GBs required by the shape.


        :param memory_in_gbs: The memory_in_gbs of this FleetShape.
        :type: int
        """
        self._memory_in_gbs = memory_in_gbs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
