# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IamUserSyncConfiguration(object):
    """
    Information about the IAM user sync configuration.
    """

    #: A constant which can be used with the lifecycle_state property of a IamUserSyncConfiguration.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a IamUserSyncConfiguration.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a IamUserSyncConfiguration.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a IamUserSyncConfiguration.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a IamUserSyncConfiguration.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a IamUserSyncConfiguration.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new IamUserSyncConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_posix_attributes_addition_required:
            The value to assign to the is_posix_attributes_addition_required property of this IamUserSyncConfiguration.
        :type is_posix_attributes_addition_required: bool

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this IamUserSyncConfiguration.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "DELETING", "UPDATING", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this IamUserSyncConfiguration.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this IamUserSyncConfiguration.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'is_posix_attributes_addition_required': 'bool',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime'
        }
        self.attribute_map = {
            'is_posix_attributes_addition_required': 'isPosixAttributesAdditionRequired',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated'
        }
        self._is_posix_attributes_addition_required = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None

    @property
    def is_posix_attributes_addition_required(self):
        """
        **[Required]** Gets the is_posix_attributes_addition_required of this IamUserSyncConfiguration.
        whether to append POSIX attributes to IAM users


        :return: The is_posix_attributes_addition_required of this IamUserSyncConfiguration.
        :rtype: bool
        """
        return self._is_posix_attributes_addition_required

    @is_posix_attributes_addition_required.setter
    def is_posix_attributes_addition_required(self, is_posix_attributes_addition_required):
        """
        Sets the is_posix_attributes_addition_required of this IamUserSyncConfiguration.
        whether to append POSIX attributes to IAM users


        :param is_posix_attributes_addition_required: The is_posix_attributes_addition_required of this IamUserSyncConfiguration.
        :type: bool
        """
        self._is_posix_attributes_addition_required = is_posix_attributes_addition_required

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this IamUserSyncConfiguration.
        Lifecycle state of the IAM user sync config

        Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "DELETING", "UPDATING", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this IamUserSyncConfiguration.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this IamUserSyncConfiguration.
        Lifecycle state of the IAM user sync config


        :param lifecycle_state: The lifecycle_state of this IamUserSyncConfiguration.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "INACTIVE", "DELETING", "UPDATING", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this IamUserSyncConfiguration.
        Time when this IAM user sync config was created, shown as an RFC 3339 formatted datetime string.


        :return: The time_created of this IamUserSyncConfiguration.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this IamUserSyncConfiguration.
        Time when this IAM user sync config was created, shown as an RFC 3339 formatted datetime string.


        :param time_created: The time_created of this IamUserSyncConfiguration.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this IamUserSyncConfiguration.
        Time when this IAM user sync config was updated, shown as an RFC 3339 formatted datetime string.


        :return: The time_updated of this IamUserSyncConfiguration.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this IamUserSyncConfiguration.
        Time when this IAM user sync config was updated, shown as an RFC 3339 formatted datetime string.


        :param time_updated: The time_updated of this IamUserSyncConfiguration.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
