# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LevelTypeDetails(object):
    """
    Details of the type of level used to trigger the creation of a new node backup configuration or node replacement configuration.
    """

    #: A constant which can be used with the level_type property of a LevelTypeDetails.
    #: This constant has a value of "NODE_LEVEL"
    LEVEL_TYPE_NODE_LEVEL = "NODE_LEVEL"

    #: A constant which can be used with the level_type property of a LevelTypeDetails.
    #: This constant has a value of "NODE_TYPE_LEVEL"
    LEVEL_TYPE_NODE_TYPE_LEVEL = "NODE_TYPE_LEVEL"

    def __init__(self, **kwargs):
        """
        Initializes a new LevelTypeDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.bds.models.NodeTypeLevelDetails`
        * :class:`~oci.bds.models.NodeLevelDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param level_type:
            The value to assign to the level_type property of this LevelTypeDetails.
            Allowed values for this property are: "NODE_LEVEL", "NODE_TYPE_LEVEL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type level_type: str

        """
        self.swagger_types = {
            'level_type': 'str'
        }
        self.attribute_map = {
            'level_type': 'levelType'
        }
        self._level_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['levelType']

        if type == 'NODE_TYPE_LEVEL':
            return 'NodeTypeLevelDetails'

        if type == 'NODE_LEVEL':
            return 'NodeLevelDetails'
        else:
            return 'LevelTypeDetails'

    @property
    def level_type(self):
        """
        **[Required]** Gets the level_type of this LevelTypeDetails.
        Type of level used to trigger the creation of a new node backup configuration or node replacement configuration.

        Allowed values for this property are: "NODE_LEVEL", "NODE_TYPE_LEVEL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The level_type of this LevelTypeDetails.
        :rtype: str
        """
        return self._level_type

    @level_type.setter
    def level_type(self, level_type):
        """
        Sets the level_type of this LevelTypeDetails.
        Type of level used to trigger the creation of a new node backup configuration or node replacement configuration.


        :param level_type: The level_type of this LevelTypeDetails.
        :type: str
        """
        allowed_values = ["NODE_LEVEL", "NODE_TYPE_LEVEL"]
        if not value_allowed_none_or_none_sentinel(level_type, allowed_values):
            level_type = 'UNKNOWN_ENUM_VALUE'
        self._level_type = level_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
