# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateIdentityConfigurationDetails(object):
    """
    Details for updating identity config on the cluster
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateIdentityConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cluster_admin_password:
            The value to assign to the cluster_admin_password property of this UpdateIdentityConfigurationDetails.
        :type cluster_admin_password: str

        :param upst_configuration_details:
            The value to assign to the upst_configuration_details property of this UpdateIdentityConfigurationDetails.
        :type upst_configuration_details: oci.bds.models.UpstConfigurationDetails

        :param iam_user_sync_configuration_details:
            The value to assign to the iam_user_sync_configuration_details property of this UpdateIdentityConfigurationDetails.
        :type iam_user_sync_configuration_details: oci.bds.models.IamUserSyncConfigurationDetails

        """
        self.swagger_types = {
            'cluster_admin_password': 'str',
            'upst_configuration_details': 'UpstConfigurationDetails',
            'iam_user_sync_configuration_details': 'IamUserSyncConfigurationDetails'
        }
        self.attribute_map = {
            'cluster_admin_password': 'clusterAdminPassword',
            'upst_configuration_details': 'upstConfigurationDetails',
            'iam_user_sync_configuration_details': 'iamUserSyncConfigurationDetails'
        }
        self._cluster_admin_password = None
        self._upst_configuration_details = None
        self._iam_user_sync_configuration_details = None

    @property
    def cluster_admin_password(self):
        """
        **[Required]** Gets the cluster_admin_password of this UpdateIdentityConfigurationDetails.
        Base-64 encoded password for the cluster admin user.


        :return: The cluster_admin_password of this UpdateIdentityConfigurationDetails.
        :rtype: str
        """
        return self._cluster_admin_password

    @cluster_admin_password.setter
    def cluster_admin_password(self, cluster_admin_password):
        """
        Sets the cluster_admin_password of this UpdateIdentityConfigurationDetails.
        Base-64 encoded password for the cluster admin user.


        :param cluster_admin_password: The cluster_admin_password of this UpdateIdentityConfigurationDetails.
        :type: str
        """
        self._cluster_admin_password = cluster_admin_password

    @property
    def upst_configuration_details(self):
        """
        Gets the upst_configuration_details of this UpdateIdentityConfigurationDetails.

        :return: The upst_configuration_details of this UpdateIdentityConfigurationDetails.
        :rtype: oci.bds.models.UpstConfigurationDetails
        """
        return self._upst_configuration_details

    @upst_configuration_details.setter
    def upst_configuration_details(self, upst_configuration_details):
        """
        Sets the upst_configuration_details of this UpdateIdentityConfigurationDetails.

        :param upst_configuration_details: The upst_configuration_details of this UpdateIdentityConfigurationDetails.
        :type: oci.bds.models.UpstConfigurationDetails
        """
        self._upst_configuration_details = upst_configuration_details

    @property
    def iam_user_sync_configuration_details(self):
        """
        Gets the iam_user_sync_configuration_details of this UpdateIdentityConfigurationDetails.

        :return: The iam_user_sync_configuration_details of this UpdateIdentityConfigurationDetails.
        :rtype: oci.bds.models.IamUserSyncConfigurationDetails
        """
        return self._iam_user_sync_configuration_details

    @iam_user_sync_configuration_details.setter
    def iam_user_sync_configuration_details(self, iam_user_sync_configuration_details):
        """
        Sets the iam_user_sync_configuration_details of this UpdateIdentityConfigurationDetails.

        :param iam_user_sync_configuration_details: The iam_user_sync_configuration_details of this UpdateIdentityConfigurationDetails.
        :type: oci.bds.models.IamUserSyncConfigurationDetails
        """
        self._iam_user_sync_configuration_details = iam_user_sync_configuration_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
