# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190111


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CostAnomalyEventAnalyticSummary(object):
    """
    A CostAnomalyEventAnalyticSummary.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CostAnomalyEventAnalyticSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param count:
            The value to assign to the count property of this CostAnomalyEventAnalyticSummary.
        :type count: int

        :param average_cost_impact:
            The value to assign to the average_cost_impact property of this CostAnomalyEventAnalyticSummary.
        :type average_cost_impact: float

        :param average_cost_variance:
            The value to assign to the average_cost_variance property of this CostAnomalyEventAnalyticSummary.
        :type average_cost_variance: float

        """
        self.swagger_types = {
            'count': 'int',
            'average_cost_impact': 'float',
            'average_cost_variance': 'float'
        }
        self.attribute_map = {
            'count': 'count',
            'average_cost_impact': 'averageCostImpact',
            'average_cost_variance': 'averageCostVariance'
        }
        self._count = None
        self._average_cost_impact = None
        self._average_cost_variance = None

    @property
    def count(self):
        """
        **[Required]** Gets the count of this CostAnomalyEventAnalyticSummary.
        The number of cost anomaly events in the given time period.


        :return: The count of this CostAnomalyEventAnalyticSummary.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this CostAnomalyEventAnalyticSummary.
        The number of cost anomaly events in the given time period.


        :param count: The count of this CostAnomalyEventAnalyticSummary.
        :type: int
        """
        self._count = count

    @property
    def average_cost_impact(self):
        """
        **[Required]** Gets the average_cost_impact of this CostAnomalyEventAnalyticSummary.
        The average cost impact of the anomaly events in the given time period.


        :return: The average_cost_impact of this CostAnomalyEventAnalyticSummary.
        :rtype: float
        """
        return self._average_cost_impact

    @average_cost_impact.setter
    def average_cost_impact(self, average_cost_impact):
        """
        Sets the average_cost_impact of this CostAnomalyEventAnalyticSummary.
        The average cost impact of the anomaly events in the given time period.


        :param average_cost_impact: The average_cost_impact of this CostAnomalyEventAnalyticSummary.
        :type: float
        """
        self._average_cost_impact = average_cost_impact

    @property
    def average_cost_variance(self):
        """
        **[Required]** Gets the average_cost_variance of this CostAnomalyEventAnalyticSummary.
        The average cost variance of the anomaly events in the given time period.


        :return: The average_cost_variance of this CostAnomalyEventAnalyticSummary.
        :rtype: float
        """
        return self._average_cost_variance

    @average_cost_variance.setter
    def average_cost_variance(self, average_cost_variance):
        """
        Sets the average_cost_variance of this CostAnomalyEventAnalyticSummary.
        The average cost variance of the anomaly events in the given time period.


        :param average_cost_variance: The average_cost_variance of this CostAnomalyEventAnalyticSummary.
        :type: float
        """
        self._average_cost_variance = average_cost_variance

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
