# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190111


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TargetResourceFilter(object):
    """
    The filter object to target resources for cost monitor.
    Cost generated by one or more resources identified by this
    filter is monitored for anomalous deviations.
    """

    #: A constant which can be used with the operator property of a TargetResourceFilter.
    #: This constant has a value of "AND"
    OPERATOR_AND = "AND"

    #: A constant which can be used with the operator property of a TargetResourceFilter.
    #: This constant has a value of "OR"
    OPERATOR_OR = "OR"

    def __init__(self, **kwargs):
        """
        Initializes a new TargetResourceFilter object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param operator:
            The value to assign to the operator property of this TargetResourceFilter.
            Allowed values for this property are: "AND", "OR", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type operator: str

        :param dimensions:
            The value to assign to the dimensions property of this TargetResourceFilter.
        :type dimensions: list[oci.budget.models.Dimension]

        :param tags:
            The value to assign to the tags property of this TargetResourceFilter.
        :type tags: list[oci.budget.models.Tag]

        :param filters:
            The value to assign to the filters property of this TargetResourceFilter.
        :type filters: list[oci.budget.models.TargetResourceFilter]

        """
        self.swagger_types = {
            'operator': 'str',
            'dimensions': 'list[Dimension]',
            'tags': 'list[Tag]',
            'filters': 'list[TargetResourceFilter]'
        }
        self.attribute_map = {
            'operator': 'operator',
            'dimensions': 'dimensions',
            'tags': 'tags',
            'filters': 'filters'
        }
        self._operator = None
        self._dimensions = None
        self._tags = None
        self._filters = None

    @property
    def operator(self):
        """
        Gets the operator of this TargetResourceFilter.
        The filter operator. Example: 'AND', 'OR'.

        Allowed values for this property are: "AND", "OR", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The operator of this TargetResourceFilter.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator):
        """
        Sets the operator of this TargetResourceFilter.
        The filter operator. Example: 'AND', 'OR'.


        :param operator: The operator of this TargetResourceFilter.
        :type: str
        """
        allowed_values = ["AND", "OR"]
        if not value_allowed_none_or_none_sentinel(operator, allowed_values):
            operator = 'UNKNOWN_ENUM_VALUE'
        self._operator = operator

    @property
    def dimensions(self):
        """
        Gets the dimensions of this TargetResourceFilter.
        The dimensions to filter on.


        :return: The dimensions of this TargetResourceFilter.
        :rtype: list[oci.budget.models.Dimension]
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """
        Sets the dimensions of this TargetResourceFilter.
        The dimensions to filter on.


        :param dimensions: The dimensions of this TargetResourceFilter.
        :type: list[oci.budget.models.Dimension]
        """
        self._dimensions = dimensions

    @property
    def tags(self):
        """
        Gets the tags of this TargetResourceFilter.
        The tags to filter on.


        :return: The tags of this TargetResourceFilter.
        :rtype: list[oci.budget.models.Tag]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this TargetResourceFilter.
        The tags to filter on.


        :param tags: The tags of this TargetResourceFilter.
        :type: list[oci.budget.models.Tag]
        """
        self._tags = tags

    @property
    def filters(self):
        """
        Gets the filters of this TargetResourceFilter.
        The nested filter object.


        :return: The filters of this TargetResourceFilter.
        :rtype: list[oci.budget.models.TargetResourceFilter]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """
        Sets the filters of this TargetResourceFilter.
        The nested filter object.


        :param filters: The filters of this TargetResourceFilter.
        :type: list[oci.budget.models.TargetResourceFilter]
        """
        self._filters = filters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
