# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AssociatedCapacityRequestDetails(object):
    """
    Details about the associated capacity requests against which the resources were provisioned by oracle.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AssociatedCapacityRequestDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param occ_capacity_request_id:
            The value to assign to the occ_capacity_request_id property of this AssociatedCapacityRequestDetails.
        :type occ_capacity_request_id: str

        :param handover_quantity:
            The value to assign to the handover_quantity property of this AssociatedCapacityRequestDetails.
        :type handover_quantity: int

        """
        self.swagger_types = {
            'occ_capacity_request_id': 'str',
            'handover_quantity': 'int'
        }
        self.attribute_map = {
            'occ_capacity_request_id': 'occCapacityRequestId',
            'handover_quantity': 'handoverQuantity'
        }
        self._occ_capacity_request_id = None
        self._handover_quantity = None

    @property
    def occ_capacity_request_id(self):
        """
        **[Required]** Gets the occ_capacity_request_id of this AssociatedCapacityRequestDetails.
        The OCID of the capacity request against which the resources were provisioned.


        :return: The occ_capacity_request_id of this AssociatedCapacityRequestDetails.
        :rtype: str
        """
        return self._occ_capacity_request_id

    @occ_capacity_request_id.setter
    def occ_capacity_request_id(self, occ_capacity_request_id):
        """
        Sets the occ_capacity_request_id of this AssociatedCapacityRequestDetails.
        The OCID of the capacity request against which the resources were provisioned.


        :param occ_capacity_request_id: The occ_capacity_request_id of this AssociatedCapacityRequestDetails.
        :type: str
        """
        self._occ_capacity_request_id = occ_capacity_request_id

    @property
    def handover_quantity(self):
        """
        **[Required]** Gets the handover_quantity of this AssociatedCapacityRequestDetails.
        The total quantity of the bare metal hardware that was made available corresponding to the capacity request ocid.


        :return: The handover_quantity of this AssociatedCapacityRequestDetails.
        :rtype: int
        """
        return self._handover_quantity

    @handover_quantity.setter
    def handover_quantity(self, handover_quantity):
        """
        Sets the handover_quantity of this AssociatedCapacityRequestDetails.
        The total quantity of the bare metal hardware that was made available corresponding to the capacity request ocid.


        :param handover_quantity: The handover_quantity of this AssociatedCapacityRequestDetails.
        :type: int
        """
        self._handover_quantity = handover_quantity

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
