# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InternalOccmDemandSignalDeliverySummary(object):
    """
    An internal summary model containing information about the demand signal delivery resources.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InternalOccmDemandSignalDeliverySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this InternalOccmDemandSignalDeliverySummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this InternalOccmDemandSignalDeliverySummary.
        :type compartment_id: str

        :param occ_customer_group_id:
            The value to assign to the occ_customer_group_id property of this InternalOccmDemandSignalDeliverySummary.
        :type occ_customer_group_id: str

        :param demand_signal_id:
            The value to assign to the demand_signal_id property of this InternalOccmDemandSignalDeliverySummary.
        :type demand_signal_id: str

        :param demand_signal_item_id:
            The value to assign to the demand_signal_item_id property of this InternalOccmDemandSignalDeliverySummary.
        :type demand_signal_item_id: str

        :param accepted_quantity:
            The value to assign to the accepted_quantity property of this InternalOccmDemandSignalDeliverySummary.
        :type accepted_quantity: int

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this InternalOccmDemandSignalDeliverySummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this InternalOccmDemandSignalDeliverySummary.
        :type lifecycle_details: str

        :param justification:
            The value to assign to the justification property of this InternalOccmDemandSignalDeliverySummary.
        :type justification: str

        :param time_delivered:
            The value to assign to the time_delivered property of this InternalOccmDemandSignalDeliverySummary.
        :type time_delivered: datetime

        :param notes:
            The value to assign to the notes property of this InternalOccmDemandSignalDeliverySummary.
        :type notes: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this InternalOccmDemandSignalDeliverySummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this InternalOccmDemandSignalDeliverySummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this InternalOccmDemandSignalDeliverySummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'occ_customer_group_id': 'str',
            'demand_signal_id': 'str',
            'demand_signal_item_id': 'str',
            'accepted_quantity': 'int',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'justification': 'str',
            'time_delivered': 'datetime',
            'notes': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'occ_customer_group_id': 'occCustomerGroupId',
            'demand_signal_id': 'demandSignalId',
            'demand_signal_item_id': 'demandSignalItemId',
            'accepted_quantity': 'acceptedQuantity',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'justification': 'justification',
            'time_delivered': 'timeDelivered',
            'notes': 'notes',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._occ_customer_group_id = None
        self._demand_signal_id = None
        self._demand_signal_item_id = None
        self._accepted_quantity = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._justification = None
        self._time_delivered = None
        self._notes = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this InternalOccmDemandSignalDeliverySummary.
        The OCID of this demand signal delivery resource.


        :return: The id of this InternalOccmDemandSignalDeliverySummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this InternalOccmDemandSignalDeliverySummary.
        The OCID of this demand signal delivery resource.


        :param id: The id of this InternalOccmDemandSignalDeliverySummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this InternalOccmDemandSignalDeliverySummary.
        The OCID of the tenancy from which the demand signal delivery resource is created.


        :return: The compartment_id of this InternalOccmDemandSignalDeliverySummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this InternalOccmDemandSignalDeliverySummary.
        The OCID of the tenancy from which the demand signal delivery resource is created.


        :param compartment_id: The compartment_id of this InternalOccmDemandSignalDeliverySummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def occ_customer_group_id(self):
        """
        **[Required]** Gets the occ_customer_group_id of this InternalOccmDemandSignalDeliverySummary.
        The OCID of the corresponding customer group to which this demand signal delivery resource belongs to.


        :return: The occ_customer_group_id of this InternalOccmDemandSignalDeliverySummary.
        :rtype: str
        """
        return self._occ_customer_group_id

    @occ_customer_group_id.setter
    def occ_customer_group_id(self, occ_customer_group_id):
        """
        Sets the occ_customer_group_id of this InternalOccmDemandSignalDeliverySummary.
        The OCID of the corresponding customer group to which this demand signal delivery resource belongs to.


        :param occ_customer_group_id: The occ_customer_group_id of this InternalOccmDemandSignalDeliverySummary.
        :type: str
        """
        self._occ_customer_group_id = occ_customer_group_id

    @property
    def demand_signal_id(self):
        """
        **[Required]** Gets the demand_signal_id of this InternalOccmDemandSignalDeliverySummary.
        The OCID of the demand signal under which this delivery will be grouped.


        :return: The demand_signal_id of this InternalOccmDemandSignalDeliverySummary.
        :rtype: str
        """
        return self._demand_signal_id

    @demand_signal_id.setter
    def demand_signal_id(self, demand_signal_id):
        """
        Sets the demand_signal_id of this InternalOccmDemandSignalDeliverySummary.
        The OCID of the demand signal under which this delivery will be grouped.


        :param demand_signal_id: The demand_signal_id of this InternalOccmDemandSignalDeliverySummary.
        :type: str
        """
        self._demand_signal_id = demand_signal_id

    @property
    def demand_signal_item_id(self):
        """
        **[Required]** Gets the demand_signal_item_id of this InternalOccmDemandSignalDeliverySummary.
        The OCID of the demand signal item corresponding to which this delivery is made.


        :return: The demand_signal_item_id of this InternalOccmDemandSignalDeliverySummary.
        :rtype: str
        """
        return self._demand_signal_item_id

    @demand_signal_item_id.setter
    def demand_signal_item_id(self, demand_signal_item_id):
        """
        Sets the demand_signal_item_id of this InternalOccmDemandSignalDeliverySummary.
        The OCID of the demand signal item corresponding to which this delivery is made.


        :param demand_signal_item_id: The demand_signal_item_id of this InternalOccmDemandSignalDeliverySummary.
        :type: str
        """
        self._demand_signal_item_id = demand_signal_item_id

    @property
    def accepted_quantity(self):
        """
        **[Required]** Gets the accepted_quantity of this InternalOccmDemandSignalDeliverySummary.
        The quantity of the resource that OCI will supply to the customer.


        :return: The accepted_quantity of this InternalOccmDemandSignalDeliverySummary.
        :rtype: int
        """
        return self._accepted_quantity

    @accepted_quantity.setter
    def accepted_quantity(self, accepted_quantity):
        """
        Sets the accepted_quantity of this InternalOccmDemandSignalDeliverySummary.
        The quantity of the resource that OCI will supply to the customer.


        :param accepted_quantity: The accepted_quantity of this InternalOccmDemandSignalDeliverySummary.
        :type: int
        """
        self._accepted_quantity = accepted_quantity

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this InternalOccmDemandSignalDeliverySummary.
        The current lifecycle state of the resource.


        :return: The lifecycle_state of this InternalOccmDemandSignalDeliverySummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this InternalOccmDemandSignalDeliverySummary.
        The current lifecycle state of the resource.


        :param lifecycle_state: The lifecycle_state of this InternalOccmDemandSignalDeliverySummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        **[Required]** Gets the lifecycle_details of this InternalOccmDemandSignalDeliverySummary.
        The enum values corresponding to the various states associated with the delivery resource.

        SUBMITTED -> The state where operators have started working and thinking on the quantity that OCI can delivery for the corresponding demand signal item.
        IN_REVIEW -> The operators are waiting on approvals from different teams/folks in this state.
        ACCEPTED -> OCI has accepted your resource request and will deliver the quantity as specified by acceptance quantity of this resource.
        DECLINED -> OCI has declined you resource request.
        DELIVERED -> OCI has delivered the accepted quantity to the customers.

        NOTE: The resource becomes visible to customers in ACCEPTED, DECLINED or DELIVERED state.


        :return: The lifecycle_details of this InternalOccmDemandSignalDeliverySummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this InternalOccmDemandSignalDeliverySummary.
        The enum values corresponding to the various states associated with the delivery resource.

        SUBMITTED -> The state where operators have started working and thinking on the quantity that OCI can delivery for the corresponding demand signal item.
        IN_REVIEW -> The operators are waiting on approvals from different teams/folks in this state.
        ACCEPTED -> OCI has accepted your resource request and will deliver the quantity as specified by acceptance quantity of this resource.
        DECLINED -> OCI has declined you resource request.
        DELIVERED -> OCI has delivered the accepted quantity to the customers.

        NOTE: The resource becomes visible to customers in ACCEPTED, DECLINED or DELIVERED state.


        :param lifecycle_details: The lifecycle_details of this InternalOccmDemandSignalDeliverySummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def justification(self):
        """
        Gets the justification of this InternalOccmDemandSignalDeliverySummary.
        This field could be used by OCI to communicate the reason for declining the request.


        :return: The justification of this InternalOccmDemandSignalDeliverySummary.
        :rtype: str
        """
        return self._justification

    @justification.setter
    def justification(self, justification):
        """
        Sets the justification of this InternalOccmDemandSignalDeliverySummary.
        This field could be used by OCI to communicate the reason for declining the request.


        :param justification: The justification of this InternalOccmDemandSignalDeliverySummary.
        :type: str
        """
        self._justification = justification

    @property
    def time_delivered(self):
        """
        Gets the time_delivered of this InternalOccmDemandSignalDeliverySummary.
        The date on which the OCI delivered the resource to the customers.


        :return: The time_delivered of this InternalOccmDemandSignalDeliverySummary.
        :rtype: datetime
        """
        return self._time_delivered

    @time_delivered.setter
    def time_delivered(self, time_delivered):
        """
        Sets the time_delivered of this InternalOccmDemandSignalDeliverySummary.
        The date on which the OCI delivered the resource to the customers.


        :param time_delivered: The time_delivered of this InternalOccmDemandSignalDeliverySummary.
        :type: datetime
        """
        self._time_delivered = time_delivered

    @property
    def notes(self):
        """
        Gets the notes of this InternalOccmDemandSignalDeliverySummary.
        This field acts as a notes section for operators.


        :return: The notes of this InternalOccmDemandSignalDeliverySummary.
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """
        Sets the notes of this InternalOccmDemandSignalDeliverySummary.
        This field acts as a notes section for operators.


        :param notes: The notes of this InternalOccmDemandSignalDeliverySummary.
        :type: str
        """
        self._notes = notes

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this InternalOccmDemandSignalDeliverySummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this InternalOccmDemandSignalDeliverySummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this InternalOccmDemandSignalDeliverySummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this InternalOccmDemandSignalDeliverySummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this InternalOccmDemandSignalDeliverySummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this InternalOccmDemandSignalDeliverySummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this InternalOccmDemandSignalDeliverySummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this InternalOccmDemandSignalDeliverySummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this InternalOccmDemandSignalDeliverySummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this InternalOccmDemandSignalDeliverySummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this InternalOccmDemandSignalDeliverySummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this InternalOccmDemandSignalDeliverySummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
